/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render.lwjgl;

import org.jagatoo.logging.LogChannel;
import org.jagatoo.logging.ProfileTimer;
import org.lwjgl.opengl.GL11;
import org.openmali.vecmath2.Colorf;
import org.xith3d.render.CanvasPeer;
import org.xith3d.render.OpenGLCapabilities;
import org.xith3d.render.OpenGLStatesCache;
import org.xith3d.render.RenderOptions;
import org.xith3d.render.RenderPeer;
import org.xith3d.render.preprocessing.RenderAtom;
import org.xith3d.render.states.StateUnit;
import org.xith3d.render.states.units.ColoringStateUnit;
import org.xith3d.render.states.units.StateUnitPeer;
import org.xith3d.scenegraph.ColoringAttributes;
import org.xith3d.scenegraph.TransparencyAttributes;
import org.xith3d.scenegraph.View;
import org.xith3d.utility.logging.X3DLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColoringStateUnitPeer
implements StateUnitPeer {
    @Override
    public void apply(RenderAtom<?> atom, StateUnit stateUnit, Object glObj, CanvasPeer canvasPeer, RenderPeer renderPeer, OpenGLCapabilities glCaps, View view, OpenGLStatesCache statesCache, RenderOptions options, long nanoTime, long nanoStep, RenderPeer.RenderMode renderMode, long frameId) {
        if (renderMode != RenderPeer.RenderMode.NORMAL) {
            return;
        }
        ProfileTimer.startProfile((LogChannel)X3DLog.LOG_CHANNEL, (String)"ColoringStateUnitPeer::apply()");
        ColoringAttributes ca = ((ColoringStateUnit)stateUnit).getColoringAttributes();
        Colorf color = ca.getColor();
        TransparencyAttributes ta = ((ColoringStateUnit)stateUnit).getTransparencyAttributes();
        if (ta.getMode() == TransparencyAttributes.BLENDED && ta.isEnabled()) {
            if (!statesCache.enabled || !statesCache.blendingEnabled) {
                X3DLog.debug("Blending enabled");
                GL11.glEnable((int)3042);
                statesCache.blendingEnabled = true;
            }
            GL11.glBlendFunc((int)ta.getSrcBlendFunction().toOpenGL(), (int)ta.getDstBlendFunction().toOpenGL());
            GL11.glColor4f((float)color.getRed(), (float)color.getGreen(), (float)color.getBlue(), (float)(1.0f - ta.getTransparency()));
            statesCache.color.set(color);
        } else {
            if (!statesCache.enabled || statesCache.blendingEnabled) {
                X3DLog.debug("Blending disabled");
                GL11.glDisable((int)3042);
                statesCache.blendingEnabled = false;
            }
            GL11.glColor3f((float)color.getRed(), (float)color.getGreen(), (float)color.getBlue());
            statesCache.color.set(color.getRed(), color.getGreen(), color.getBlue());
        }
        GL11.glShadeModel((int)ca.getShadeModel().toOpenGL());
        ProfileTimer.endProfile();
    }
}

