/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render.lwjgl;

import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import org.xith3d.render.config.DisplayMode;
import org.xith3d.render.config.DisplayModeSelector;
import org.xith3d.render.config.OpenGLLayer;

public class DisplayModeSelectorAWTImpl
extends DisplayModeSelector {
    private static final OpenGLLayer OPENGL_LAYER = OpenGLLayer.LWJGL_AWT;
    private static DisplayMode[] cachedModes = null;

    private DisplayMode[] getFallbackModes() {
        GraphicsDevice graphDev = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        java.awt.DisplayMode awtMode = graphDev.getDisplayMode();
        int bpp = awtMode.getBitDepth();
        int freq = awtMode.getRefreshRate();
        DisplayMode[] modes = new DisplayMode[]{new DisplayMode(OPENGL_LAYER, null, 320, 240, bpp, freq), new DisplayMode(OPENGL_LAYER, null, 640, 480, bpp, freq), new DisplayMode(OPENGL_LAYER, null, 800, 600, bpp, freq), new DisplayMode(OPENGL_LAYER, null, 1024, 768, bpp, freq), new DisplayMode(OPENGL_LAYER, null, 1152, 864, bpp, freq), new DisplayMode(OPENGL_LAYER, null, 1280, 960, bpp, freq), new DisplayMode(OPENGL_LAYER, null, 1280, 1024, bpp, freq), new DisplayMode(OPENGL_LAYER, null, 1480, 925, bpp, freq), new DisplayMode(OPENGL_LAYER, null, 1600, 1200, bpp, freq), new DisplayMode(OPENGL_LAYER, null, 1680, 1050, bpp, freq), new DisplayMode(OPENGL_LAYER, null, 1920, 1200, bpp, freq)};
        return modes;
    }

    public DisplayMode[] getAvailableModes() {
        if (cachedModes != null) {
            return cachedModes;
        }
        GraphicsDevice graphDev = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        java.awt.DisplayMode[] awtModes = graphDev.getDisplayModes();
        if (awtModes.length <= 1 || !graphDev.isFullScreenSupported()) {
            return this.getFallbackModes();
        }
        DisplayMode[] modes = new DisplayMode[awtModes.length];
        for (int i = 0; i < awtModes.length; ++i) {
            modes[i] = new DisplayMode(OPENGL_LAYER, awtModes[i], awtModes[i].getWidth(), awtModes[i].getHeight(), awtModes[i].getBitDepth(), awtModes[i].getRefreshRate());
        }
        this.sortModes(modes);
        cachedModes = modes;
        return modes;
    }
}

