/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render.lwjgl;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;
import org.xith3d.render.OpenGLCapabilities;
import org.xith3d.render.OpenGLStatesCache;
import org.xith3d.render.OpenGlExtensions;
import org.xith3d.render.lwjgl.AssemblyShaderProgramStateUnitPeer;
import org.xith3d.render.lwjgl.GLSLShaderProgramStateUnitPeer;
import org.xith3d.render.lwjgl.RenderPeerImpl;
import org.xith3d.render.lwjgl.ShapeAtomPeer;
import org.xith3d.render.lwjgl.TextureUnitStateUnitPeer;

public class OpenGLStatesCacheImpl
extends OpenGLStatesCache {
    private static final FloatBuffer floatBuffer = BufferUtils.createFloatBuffer((int)16);
    private static final ByteBuffer byteBuffer = BufferUtils.createByteBuffer((int)16);

    public final void update(Object glObj, OpenGLCapabilities glCaps) {
        int oldSelectedServerTU = this.currentServerTextureUnit == -1 ? 0 : this.currentServerTextureUnit;
        int oldSelectedClientTU = this.currentClientTextureUnit == -1 ? 0 : this.currentClientTextureUnit;
        int texCoordArrayEnabledMask = 0;
        boolean[] texture1DEnabled = new boolean[glCaps.getMaxTextureUnits()];
        boolean[] texture2DEnabled = new boolean[glCaps.getMaxTextureUnits()];
        boolean[] texture3DEnabled = new boolean[glCaps.getMaxTextureUnits()];
        boolean[] textureCMEnabled = new boolean[glCaps.getMaxTextureUnits()];
        int[] texGenEnableMask = new int[glCaps.getMaxTextureUnits()];
        int maskValue = 1;
        for (int i = 0; i < glCaps.getMaxTextureUnits(); ++i) {
            TextureUnitStateUnitPeer.selectServerTextureUnit(i, this, true);
            if (GL11.glIsEnabled((int)32888)) {
                texCoordArrayEnabledMask |= maskValue;
            }
            texture1DEnabled[i] = GL11.glIsEnabled((int)3552);
            texture2DEnabled[i] = GL11.glIsEnabled((int)3553);
            texture3DEnabled[i] = GL11.glIsEnabled((int)32879);
            textureCMEnabled[i] = GL11.glIsEnabled((int)34067);
            maskValue *= 2;
            texGenEnableMask[i] = 0;
            if (GL11.glIsEnabled((int)3168)) {
                int n = i;
                texGenEnableMask[n] = texGenEnableMask[n] | 1;
            }
            if (GL11.glIsEnabled((int)3169)) {
                int n = i;
                texGenEnableMask[n] = texGenEnableMask[n] | 2;
            }
            if (GL11.glIsEnabled((int)3170)) {
                int n = i;
                texGenEnableMask[n] = texGenEnableMask[n] | 4;
            }
            if (!GL11.glIsEnabled((int)3171)) continue;
            int n = i;
            texGenEnableMask[n] = texGenEnableMask[n] | 8;
        }
        TextureUnitStateUnitPeer.selectServerTextureUnit(oldSelectedServerTU, this, true);
        ShapeAtomPeer.selectClientTextureUnit(oldSelectedClientTU, this, true);
        long vertexAttribsEnableMask = 0L;
        if (OpenGlExtensions.GL_CUSTOM_VERTEX_ATTRIBUTES) {
            for (int i = 0; i < glCaps.getMaxVertexAttributes(); ++i) {
                GL20.glDisableVertexAttribArray((int)i);
            }
        }
        byteBuffer.rewind();
        GL11.glGetBoolean((int)3107, (ByteBuffer)byteBuffer);
        int colorWriteMask = 0;
        if (byteBuffer.get(0) == 1) {
            colorWriteMask |= 1;
        }
        if (byteBuffer.get(1) == 1) {
            colorWriteMask |= 2;
        }
        if (byteBuffer.get(2) == 1) {
            colorWriteMask |= 4;
        }
        if (byteBuffer.get(3) == 1) {
            colorWriteMask |= 8;
        }
        byteBuffer.rewind();
        GL11.glGetBoolean((int)2930, (ByteBuffer)byteBuffer);
        boolean depthWriteMask = byteBuffer.get(0) == 1;
        int currentGLSLShaderProgram = GLSLShaderProgramStateUnitPeer.getCurrentShaderProgram();
        boolean[] clipPlaneEnabled = new boolean[6];
        for (int i = 0; i < clipPlaneEnabled.length; ++i) {
            int glPlane = RenderPeerImpl.translateClipPlaneIndex(i);
            clipPlaneEnabled[i] = GL11.glIsEnabled((int)glPlane);
        }
        float[] color = new float[4];
        floatBuffer.rewind();
        GL11.glGetFloat((int)2816, (FloatBuffer)floatBuffer);
        color[0] = floatBuffer.get();
        color[1] = floatBuffer.get();
        color[2] = floatBuffer.get();
        color[3] = 1.0f - floatBuffer.get();
        boolean[] lightEnabled = new boolean[]{GL11.glIsEnabled((int)16384), GL11.glIsEnabled((int)16385), GL11.glIsEnabled((int)16386), GL11.glIsEnabled((int)16387), GL11.glIsEnabled((int)16388), GL11.glIsEnabled((int)16389), GL11.glIsEnabled((int)16390), GL11.glIsEnabled((int)16391)};
        this.update(GL11.glIsEnabled((int)32884), GL11.glIsEnabled((int)32885), GL11.glIsEnabled((int)32886), texCoordArrayEnabledMask, texGenEnableMask, texture1DEnabled, texture2DEnabled, texture3DEnabled, textureCMEnabled, 0L, oldSelectedServerTU, oldSelectedClientTU, this.maxUsedVertexAttrib, colorWriteMask, depthWriteMask, AssemblyShaderProgramStateUnitPeer.areARBShaderProgramsSupported() ? GL11.glIsEnabled((int)34336) : false, AssemblyShaderProgramStateUnitPeer.areARBShaderProgramsSupported() ? GL11.glIsEnabled((int)34820) : false, currentGLSLShaderProgram, GL11.glIsEnabled((int)2929), GL11.glIsEnabled((int)3008), GL11.glIsEnabled((int)2960), GL11.glIsEnabled((int)3089), clipPlaneEnabled, GL11.glIsEnabled((int)3042), GL11.glIsEnabled((int)2832), GL11.glIsEnabled((int)2852), GL11.glIsEnabled((int)2848), GL11.glIsEnabled((int)2881), GL11.glIsEnabled((int)10753), GL11.glIsEnabled((int)10754), GL11.glIsEnabled((int)32823), GL11.glIsEnabled((int)2884), GL11.glIsEnabled((int)2977), GL11.glIsEnabled((int)2903), GL11.glIsEnabled((int)2896), lightEnabled, GL11.glIsEnabled((int)2912), color);
    }
}

