/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render.lwjgl;

import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.jagatoo.opengl.enums.TextureFormat;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.EXTFramebufferObject;
import org.lwjgl.opengl.GL11;
import org.openmali.types.twodee.Rect2i;
import org.openmali.vecmath2.Colorf;
import org.xith3d.render.CanvasPeer;
import org.xith3d.render.ImageRenderTarget;
import org.xith3d.render.OpenGLCapabilities;
import org.xith3d.render.OpenGLStatesCache;
import org.xith3d.render.RenderTarget;
import org.xith3d.render.SceneGraphOpenGLReference;
import org.xith3d.render.SceneGraphOpenGLReferences;
import org.xith3d.render.TextureRenderTarget;
import org.xith3d.render.lwjgl.CanvasPeerImplBase;
import org.xith3d.render.lwjgl.RenderPeerImpl;
import org.xith3d.render.lwjgl.TextureUnitStateUnitPeer;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.Texture2D;

public class RenderTargetPeer {
    private final IntBuffer intBuffer = BufferUtils.createIntBuffer((int)1);
    private final RenderPeerImpl renderPeer;
    private final SceneGraphOpenGLReferences.Provider frameBufferNameProvider = new SceneGraphOpenGLReferences.Provider(){

        public SceneGraphOpenGLReference newReference(CanvasPeer canvasPeer, SceneGraphOpenGLReferences references, int numNamesPerContext) {
            return new SceneGraphOpenGLReference(canvasPeer, references, numNamesPerContext){

                public void prepareObjectForDestroy() {
                    SceneGraphOpenGLReference ref = this.getReferences().removeReference(this.getContext().getCanvasID());
                    ((CanvasPeerImplBase)this.getContext()).addDestroyableObject(ref);
                }

                public void destroyObject(int index, int name) {
                    RenderTargetPeer.this.intBuffer.clear();
                    RenderTargetPeer.this.intBuffer.put(name).rewind();
                    if (index == 0) {
                        EXTFramebufferObject.glDeleteFramebuffersEXT((IntBuffer)RenderTargetPeer.this.intBuffer);
                    } else if (index > 0) {
                        EXTFramebufferObject.glDeleteRenderbuffersEXT((IntBuffer)RenderTargetPeer.this.intBuffer);
                    }
                }
            };
        }
    };

    private final void setupRenderTarget(OpenGLCapabilities glCaps, OpenGLStatesCache statesCache, CanvasPeer canvasPeer, TextureRenderTarget renderTarget) {
        SceneGraphOpenGLReference openGLRef = renderTarget.getOpenGLReferences().getReference(canvasPeer, this.frameBufferNameProvider);
        Texture texture = renderTarget.getTexture();
        int texWidth = texture.getWidth();
        int texHeight = texture.getHeight();
        if (texWidth <= 0 || texHeight <= 0) {
            throw new Error("The Texture \"" + texture.getName() + "\" of TextureRenderTarget \"" + renderTarget + "\" doesn't seem to have an InputComponent.");
        }
        if (!openGLRef.nameExists(0)) {
            this.intBuffer.clear();
            EXTFramebufferObject.glGenFramebuffersEXT((IntBuffer)this.intBuffer);
            openGLRef.setName(0, this.intBuffer.get(0));
        }
        int fb = openGLRef.getName(0);
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)fb);
        int tex = TextureUnitStateUnitPeer.setTextureState2(glCaps, statesCache, texture, statesCache.currentServerTextureUnit, texture.isChanged2(), canvasPeer, this.renderPeer.getCanvasPeer().getDepthBufferSize());
        if (texture.getFormat() == TextureFormat.DEPTH) {
            EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)36096, (int)3553, (int)tex, (int)0);
            GL11.glDrawBuffer((int)0);
            GL11.glReadBuffer((int)0);
        } else {
            if (!openGLRef.nameExists(1)) {
                this.intBuffer.clear();
                EXTFramebufferObject.glGenRenderbuffersEXT((IntBuffer)this.intBuffer);
                openGLRef.setName(1, this.intBuffer.get(0));
            }
            int rb = openGLRef.getName(1);
            EXTFramebufferObject.glBindRenderbufferEXT((int)36161, (int)rb);
            EXTFramebufferObject.glRenderbufferStorageEXT((int)36161, (int)33190, (int)texWidth, (int)texHeight);
            EXTFramebufferObject.glFramebufferRenderbufferEXT((int)36160, (int)36096, (int)36161, (int)rb);
            EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)36064, (int)3553, (int)tex, (int)0);
        }
        GL11.glPushAttrib((int)2048);
        GL11.glViewport((int)0, (int)0, (int)texWidth, (int)texHeight);
        Colorf bgCol = renderTarget.getBackgroundColor();
        if (bgCol != null) {
            GL11.glClearColor((float)bgCol.getRed(), (float)bgCol.getGreen(), (float)bgCol.getBlue(), (float)(1.0f - bgCol.getAlpha()));
            GL11.glClear((int)17664);
            float[] clearColor = this.renderPeer.getClearColor();
            GL11.glClearColor((float)clearColor[0], (float)clearColor[1], (float)clearColor[2], (float)clearColor[3]);
        }
    }

    private final void finishRenderTarget(TextureRenderTarget renderTarget) {
        Texture2D texture;
        ByteBuffer bb;
        if (renderTarget.isPixelReadbackEnabled() && (bb = (texture = (Texture2D)renderTarget.getTexture()).getImage0().getDataBuffer()) != null) {
            GL11.glReadPixels((int)0, (int)0, (int)texture.getWidth(), (int)texture.getHeight(), (int)(texture.getFormat().hasAlpha() ? 6408 : 6407), (int)5121, (ByteBuffer)bb);
        }
        GL11.glPopAttrib();
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)0);
    }

    private final void setupRenderTarget(ImageRenderTarget renderTarget) {
        Rect2i viewport = ((CanvasPeerImplBase)this.renderPeer.getCanvasPeer()).getCurrentViewport();
        BufferedImage image = renderTarget.getImage();
        if (image == null || image.getWidth() != viewport.getWidth() || image.getHeight() != viewport.getHeight()) {
            renderTarget.setImage(new BufferedImage(viewport.getWidth(), viewport.getHeight(), 2));
        }
    }

    private final void finishRenderTarget(ImageRenderTarget renderTarget) {
        BufferedImage image = renderTarget.getImage();
        GL11.glReadPixels((int)0, (int)0, (int)image.getWidth(), (int)image.getHeight(), (int)6408, (int)5121, (ByteBuffer)renderTarget.getByteBuffer());
        renderTarget.copyBufferToImage();
    }

    public final void setupRenderTarget(OpenGLCapabilities glCaps, OpenGLStatesCache statesCache, CanvasPeer canvasPeer, RenderTarget renderTarget) {
        if (renderTarget instanceof TextureRenderTarget) {
            this.setupRenderTarget(glCaps, statesCache, canvasPeer, (TextureRenderTarget)renderTarget);
        } else if (renderTarget instanceof ImageRenderTarget) {
            this.setupRenderTarget((ImageRenderTarget)renderTarget);
        }
    }

    public final void finishRenderTarget(RenderTarget renderTarget) {
        if (renderTarget instanceof TextureRenderTarget) {
            this.finishRenderTarget((TextureRenderTarget)renderTarget);
        } else if (renderTarget instanceof ImageRenderTarget) {
            this.finishRenderTarget((ImageRenderTarget)renderTarget);
        }
    }

    public RenderTargetPeer(RenderPeerImpl renderPeer) {
        this.renderPeer = renderPeer;
    }
}

