/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render.lwjgl;

import org.jagatoo.logging.LogChannel;
import org.jagatoo.logging.ProfileTimer;
import org.jagatoo.opengl.enums.TestFunction;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;
import org.xith3d.render.CanvasPeer;
import org.xith3d.render.OpenGLCapabilities;
import org.xith3d.render.OpenGLStatesCache;
import org.xith3d.render.RenderOptions;
import org.xith3d.render.RenderPeer;
import org.xith3d.render.preprocessing.RenderAtom;
import org.xith3d.render.states.StateUnit;
import org.xith3d.render.states.units.RenderingAttribsStateUnit;
import org.xith3d.render.states.units.StateUnitPeer;
import org.xith3d.scenegraph.RenderingAttributes;
import org.xith3d.scenegraph.StencilFuncSeparate;
import org.xith3d.scenegraph.StencilMaskSeparate;
import org.xith3d.scenegraph.StencilOpSeparate;
import org.xith3d.scenegraph.View;
import org.xith3d.utility.logging.X3DLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderingAttribsStateUnitPeer
implements StateUnitPeer {
    @Override
    public void apply(RenderAtom<?> atom, StateUnit stateUnit, Object glObj, CanvasPeer canvasPeer, RenderPeer renderPeer, OpenGLCapabilities glCaps, View view, OpenGLStatesCache statesCache, RenderOptions options, long nanoTime, long nanoStep, RenderPeer.RenderMode renderMode, long frameId) {
        boolean alphaTest;
        boolean depthTest;
        ProfileTimer.startProfile((LogChannel)X3DLog.LOG_CHANNEL, (String)"RenderingAttribsStateUnitPeer::apply()");
        RenderingAttributes ra = ((RenderingAttribsStateUnit)stateUnit).getRenderingAttributes();
        if (!statesCache.enabled || statesCache.depthWriteMask != ra.isDepthBufferWriteEnabled()) {
            GL11.glDepthMask((boolean)ra.isDepthBufferWriteEnabled());
            statesCache.depthWriteMask = ra.isDepthBufferWriteEnabled();
        }
        if (ra.hasColorWriteMask() && (!statesCache.enabled || statesCache.colorWriteMask != ra.getColorWriteMask())) {
            GL11.glColorMask((boolean)ra.isRedWriteEnabled(), (boolean)ra.isGreenWriteEnabled(), (boolean)ra.isBlueWriteEnabled(), (boolean)ra.isAlphaWriteEnabled());
            statesCache.colorWriteMask = ra.getColorWriteMask();
        }
        if (ra.isDepthBufferEnabled()) {
            GL11.glDepthFunc((int)ra.getDepthTestFunction().toOpenGL());
            depthTest = ra.getDepthTestFunction() != TestFunction.ALWAYS;
        } else {
            depthTest = false;
        }
        if (!(!depthTest || statesCache.enabled && statesCache.depthTestEnabled)) {
            GL11.glEnable((int)2929);
        } else if (!(depthTest || statesCache.enabled && !statesCache.depthTestEnabled)) {
            GL11.glDisable((int)2929);
        }
        statesCache.depthTestEnabled = depthTest;
        if (!statesCache.enabled || statesCache.blendingEnabled) {
            GL11.glAlphaFunc((int)ra.getAlphaTestFunction().toOpenGL(), (float)ra.getAlphaTestValue());
            alphaTest = ra.getAlphaTestFunction() != TestFunction.ALWAYS;
        } else {
            alphaTest = false;
        }
        if (!(!alphaTest || statesCache.enabled && statesCache.alphaTestEnabled)) {
            GL11.glEnable((int)3008);
        } else if (!(alphaTest || statesCache.enabled && !statesCache.alphaTestEnabled)) {
            GL11.glDisable((int)3008);
        }
        statesCache.alphaTestEnabled = alphaTest;
        if (ra.isStencilEnabled()) {
            if (!statesCache.enabled || !statesCache.stencilTestEnabled) {
                GL11.glEnable((int)2960);
            }
            GL11.glStencilFunc((int)ra.getStencilTestFunction().toOpenGL(), (int)ra.getStencilRef(), (int)ra.getStencilMask());
            GL11.glStencilOp((int)ra.getStencilOpFail().toOpenGL(), (int)ra.getStencilOpZFail().toOpenGL(), (int)ra.getStencilOpZPass().toOpenGL());
            if (renderPeer.getCanvasPeer().getOpenGLInfo().getVersionMajor() >= 2) {
                StencilMaskSeparate maskSep;
                StencilOpSeparate opSep;
                StencilFuncSeparate funcSep = ra.getStencilFuncSeparate();
                if (funcSep != null) {
                    GL20.glStencilFuncSeparate((int)funcSep.getFace().toOpenGL(), (int)funcSep.getTestFunction().toOpenGL(), (int)funcSep.getRef(), (int)funcSep.getMask());
                }
                if ((opSep = ra.getStencilOpSeparate()) != null) {
                    GL20.glStencilOpSeparate((int)opSep.getFace().toOpenGL(), (int)opSep.getSFail().toOpenGL(), (int)opSep.getDPFail().toOpenGL(), (int)opSep.getDPPass().toOpenGL());
                }
                if ((maskSep = ra.getStencilMaskSeparate()) != null) {
                    GL20.glStencilMaskSeparate((int)maskSep.getFace().toOpenGL(), (int)maskSep.getMask());
                }
            }
        } else if (!statesCache.enabled || statesCache.stencilTestEnabled) {
            GL11.glDisable((int)2960);
        }
        statesCache.stencilTestEnabled = ra.isStencilEnabled();
        ProfileTimer.endProfile();
    }
}

