/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render.preprocessing;

import org.xith3d.render.OpenGLCapabilities;
import org.xith3d.render.preprocessing.ShadowAtom;
import org.xith3d.render.states.StateUnit;
import org.xith3d.render.states.units.ColoringStateUnit;
import org.xith3d.render.states.units.LineAttribsStateUnit;
import org.xith3d.render.states.units.MaterialStateUnit;
import org.xith3d.render.states.units.PointAttribsStateUnit;
import org.xith3d.render.states.units.PolygonAttribsStateUnit;
import org.xith3d.render.states.units.RenderingAttribsStateUnit;
import org.xith3d.render.states.units.ShaderProgramStateUnit;
import org.xith3d.render.states.units.TextureUnitStateUnit;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.ColoringAttributes;
import org.xith3d.scenegraph.RenderingAttributes;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.TexCoordGeneration;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.TextureAttributes;
import org.xith3d.scenegraph.TextureUnit;
import org.xith3d.scenegraph.TransparencyAttributes;
import org.xith3d.scenegraph._SG_PrivilegedAccess;

public class ShapeAtom
extends ShadowAtom {
    public static final int STATE_TYPE = 0;
    public static final Appearance DEFAULT_APPEARANCE = new Appearance();
    private static RenderingAttributes transparentRenderAttribs = null;
    private final StateUnit[] stateUnitCache = new StateUnit[17];
    private int numValidTUs = 0;
    public int lastComputedPolysCount = 0;

    public ShapeAtom(Shape3D shape, OpenGLCapabilities glCaps) {
        super(0, shape);
        int i;
        Appearance a = shape.getAppearance();
        if (a == null) {
            a = DEFAULT_APPEARANCE;
        }
        this.updateStateUnit(MaterialStateUnit.makeMaterialStateUnit(a.getMaterial(), this.stateUnitCache));
        this.getStateUnit(MaterialStateUnit.STATE_TYPE).updateCachedStateId();
        this.updateStateUnit(PolygonAttribsStateUnit.makePolygonAttribsStateUnit(a.getPolygonAttributes(), this.stateUnitCache));
        this.getStateUnit(PolygonAttribsStateUnit.STATE_TYPE).updateCachedStateId();
        this.updateStateUnit(LineAttribsStateUnit.makeLineAttribsStateUnit(a.getLineAttributes(), this.stateUnitCache));
        this.getStateUnit(LineAttribsStateUnit.STATE_TYPE).updateCachedStateId();
        this.updateStateUnit(PointAttribsStateUnit.makePointAttribsStateUnit(a.getPointAttributes(), this.stateUnitCache));
        this.getStateUnit(PointAttribsStateUnit.STATE_TYPE).updateCachedStateId();
        this.updateStateUnit(ColoringStateUnit.makeColoringStateUnit(a.getColoringAttributes(), a.getTransparencyAttributes(), this.stateUnitCache));
        this.getStateUnit(ColoringStateUnit.STATE_TYPE).updateCachedStateId();
        if (a.getRenderingAttributes() == null && a.getTransparencyAttributes() != null) {
            if (transparentRenderAttribs == null) {
                transparentRenderAttribs = new RenderingAttributes(true, true, 0.0f, RenderingAttributes.GREATER);
            }
            this.updateStateUnit(RenderingAttribsStateUnit.makeRenderingStateUnit(transparentRenderAttribs, this.stateUnitCache));
        } else {
            this.updateStateUnit(RenderingAttribsStateUnit.makeRenderingStateUnit(a.getRenderingAttributes(), this.stateUnitCache));
        }
        this.getStateUnit(RenderingAttribsStateUnit.STATE_TYPE).updateCachedStateId();
        this.updateStateUnit(ShaderProgramStateUnit.makeShaderProgramStateUnit(a.getShaderProgramContext(), this.stateUnitCache));
        this.getStateUnit(ShaderProgramStateUnit.STATE_TYPE).updateCachedStateId();
        this.numValidTUs = a.getTextureUnitsCount();
        for (i = 0; i < this.numValidTUs; ++i) {
            this.updateStateUnit(TextureUnitStateUnit.makeTextureUnitStateUnit(i, a.getTextureUnit(i), this.stateUnitCache));
            this.getStateUnit(TextureUnitStateUnit.STATE_TYPES[i]).updateCachedStateId();
        }
        for (i = this.numValidTUs; i < TextureUnitStateUnit.DEFAULT_UNIT.length; ++i) {
            this.updateStateUnit(TextureUnitStateUnit.DEFAULT_UNIT[i]);
            this.getStateUnit(TextureUnitStateUnit.STATE_TYPES[i]).updateCachedStateId();
        }
    }

    public void updateStateUnits(Appearance app, OpenGLCapabilities glCaps) {
        int i;
        this.updateLightsAndFogs();
        MaterialStateUnit materialShader = (MaterialStateUnit)this.getStateUnit(MaterialStateUnit.STATE_TYPE);
        if (materialShader.isDefault()) {
            if (app.getMaterial() != null) {
                this.updateStateUnit(MaterialStateUnit.makeMaterialStateUnit(app.getMaterial(), this.stateUnitCache));
                _SG_PrivilegedAccess.setChanged(app.getMaterial(), false);
            }
        } else if (app.getMaterial() == null) {
            this.updateStateUnit(MaterialStateUnit.makeMaterialStateUnit(null, null));
        } else if (app.getMaterial().isChanged()) {
            materialShader.update(app.getMaterial());
            this.updateStateMap(materialShader);
            _SG_PrivilegedAccess.setChanged(app.getMaterial(), false);
        }
        this.getStateUnit(MaterialStateUnit.STATE_TYPE).updateCachedStateId();
        PolygonAttribsStateUnit polygonAttrShader = (PolygonAttribsStateUnit)this.getStateUnit(PolygonAttribsStateUnit.STATE_TYPE);
        if (polygonAttrShader.isDefault()) {
            if (app.getPolygonAttributes() != null) {
                this.updateStateUnit(PolygonAttribsStateUnit.makePolygonAttribsStateUnit(app.getPolygonAttributes(), this.stateUnitCache));
                _SG_PrivilegedAccess.setChanged(app.getPolygonAttributes(), false);
            }
        } else if (app.getPolygonAttributes() == null) {
            this.updateStateUnit(PolygonAttribsStateUnit.makePolygonAttribsStateUnit(null, null));
        } else if (app.getPolygonAttributes().isChanged()) {
            polygonAttrShader.update(app.getPolygonAttributes());
            this.updateStateMap(polygonAttrShader);
            _SG_PrivilegedAccess.setChanged(app.getPolygonAttributes(), false);
        }
        this.getStateUnit(PolygonAttribsStateUnit.STATE_TYPE).updateCachedStateId();
        LineAttribsStateUnit lineAttrShader = (LineAttribsStateUnit)this.getStateUnit(LineAttribsStateUnit.STATE_TYPE);
        if (lineAttrShader.isDefault()) {
            if (app.getLineAttributes() != null) {
                this.updateStateUnit(LineAttribsStateUnit.makeLineAttribsStateUnit(app.getLineAttributes(), this.stateUnitCache));
                _SG_PrivilegedAccess.setChanged(app.getLineAttributes(), false);
            }
        } else if (app.getLineAttributes() == null) {
            this.updateStateUnit(LineAttribsStateUnit.makeLineAttribsStateUnit(null, null));
        } else if (app.getLineAttributes().isChanged()) {
            lineAttrShader.update(app.getLineAttributes());
            this.updateStateMap(lineAttrShader);
            _SG_PrivilegedAccess.setChanged(app.getLineAttributes(), false);
        }
        this.getStateUnit(LineAttribsStateUnit.STATE_TYPE).updateCachedStateId();
        PointAttribsStateUnit pointAttrShader = (PointAttribsStateUnit)this.getStateUnit(PointAttribsStateUnit.STATE_TYPE);
        if (pointAttrShader.isDefault()) {
            if (app.getPointAttributes() != null) {
                this.updateStateUnit(PointAttribsStateUnit.makePointAttribsStateUnit(app.getPointAttributes(), this.stateUnitCache));
                _SG_PrivilegedAccess.setChanged(app.getPointAttributes(), false);
            }
        } else if (app.getPointAttributes() == null) {
            this.updateStateUnit(PointAttribsStateUnit.makePointAttribsStateUnit(null, null));
        } else if (app.getPointAttributes().isChanged()) {
            pointAttrShader.update(app.getPointAttributes());
            this.updateStateMap(pointAttrShader);
            _SG_PrivilegedAccess.setChanged(app.getPointAttributes(), false);
        }
        this.getStateUnit(PointAttribsStateUnit.STATE_TYPE).updateCachedStateId();
        ColoringStateUnit colorShader = (ColoringStateUnit)this.getStateUnit(ColoringStateUnit.STATE_TYPE);
        if (ColoringStateUnit.isDefault(colorShader)) {
            if (app.getColoringAttributes() != null || app.getTransparencyAttributes() != null) {
                this.updateStateUnit(ColoringStateUnit.makeColoringStateUnit(app.getColoringAttributes(), app.getTransparencyAttributes(), this.stateUnitCache));
                if (app.getColoringAttributes() != null) {
                    _SG_PrivilegedAccess.setChanged(app.getColoringAttributes(), false);
                }
                if (app.getTransparencyAttributes() != null) {
                    _SG_PrivilegedAccess.setChanged(app.getTransparencyAttributes(), false);
                }
            }
        } else if (app.getColoringAttributes() == null && app.getTransparencyAttributes() == null) {
            this.updateStateUnit(ColoringStateUnit.makeColoringStateUnit(app.getColoringAttributes(), app.getTransparencyAttributes(), this.stateUnitCache));
        } else {
            boolean t2;
            boolean c2;
            ColoringAttributes colorAttribs = app.getColoringAttributes();
            boolean c1 = colorAttribs == null;
            boolean bl = c2 = colorShader.getColoringAttributes() == ColoringStateUnit.DEFAULT_COLOR_ATTR;
            boolean c = c1 ? !c2 : colorAttribs.isChanged();
            TransparencyAttributes transAttribs = app.getTransparencyAttributes();
            boolean t1 = transAttribs == null;
            boolean bl2 = t2 = colorShader.getTransparencyAttributes() == ColoringStateUnit.DEFAULT_TRANS_ATTR;
            boolean t = t1 ? !t2 : transAttribs.isChanged();
            if (c || t) {
                colorShader.update(app.getColoringAttributes(), app.getTransparencyAttributes());
                this.updateStateMap(colorShader);
                if (!c1) {
                    _SG_PrivilegedAccess.setChanged(app.getColoringAttributes(), false);
                }
                if (!t1) {
                    _SG_PrivilegedAccess.setChanged(app.getTransparencyAttributes(), false);
                }
            }
        }
        this.getStateUnit(ColoringStateUnit.STATE_TYPE).updateCachedStateId();
        RenderingAttribsStateUnit renderingAttrShader = (RenderingAttribsStateUnit)this.getStateUnit(RenderingAttribsStateUnit.STATE_TYPE);
        if (renderingAttrShader.isDefault()) {
            if (app.getRenderingAttributes() != null) {
                this.updateStateUnit(RenderingAttribsStateUnit.makeRenderingStateUnit(app.getRenderingAttributes(), this.stateUnitCache));
                _SG_PrivilegedAccess.setChanged(app.getRenderingAttributes(), false);
            }
        } else if (app.getRenderingAttributes() == null) {
            this.updateStateUnit(RenderingAttribsStateUnit.makeRenderingStateUnit(null, null));
        } else if (app.getRenderingAttributes().isChanged()) {
            renderingAttrShader.update(app.getRenderingAttributes());
            this.updateStateMap(renderingAttrShader);
            _SG_PrivilegedAccess.setChanged(app.getRenderingAttributes(), false);
        }
        this.getStateUnit(RenderingAttribsStateUnit.STATE_TYPE).updateCachedStateId();
        ShaderProgramStateUnit shaderProgramStateUnit = (ShaderProgramStateUnit)this.getStateUnit(ShaderProgramStateUnit.STATE_TYPE);
        if (shaderProgramStateUnit.isDefault()) {
            if (app.getShaderProgramContext() != null) {
                this.updateStateUnit(ShaderProgramStateUnit.makeShaderProgramStateUnit(app.getShaderProgramContext(), this.stateUnitCache));
                _SG_PrivilegedAccess.setChanged(app.getShaderProgramContext(), false);
            }
        } else if (app.getShaderProgramContext() == null) {
            this.updateStateUnit(ShaderProgramStateUnit.makeShaderProgramStateUnit(null, null));
        } else if (app.getShaderProgramContext().isChanged()) {
            shaderProgramStateUnit.update(app.getShaderProgramContext());
            this.updateStateMap(shaderProgramStateUnit);
            _SG_PrivilegedAccess.setChanged(app.getShaderProgramContext(), false);
        }
        this.getStateUnit(ShaderProgramStateUnit.STATE_TYPE).updateCachedStateId();
        int tuc = app.getTextureUnitsCount();
        for (i = 0; i < tuc; ++i) {
            TexCoordGeneration texCoordGen;
            TextureUnitStateUnit texShader = (TextureUnitStateUnit)this.getStateUnit(TextureUnitStateUnit.STATE_TYPES[i]);
            TextureUnit tu = app.getTextureUnit(i);
            Texture texture = tu == null ? null : tu.getTexture();
            TextureAttributes texAttribs = tu == null ? null : tu.getTextureAttributes();
            TexCoordGeneration texCoordGeneration = texCoordGen = tu == null ? null : tu.getTexCoordGeneration();
            if (texShader.isDefault()) {
                if (texture != null || texAttribs != null || texCoordGen != null) {
                    this.updateStateUnit(TextureUnitStateUnit.makeTextureUnitStateUnit(i, tu, this.stateUnitCache));
                }
            } else if (tu == null || texture == null && texAttribs == null && texCoordGen == null) {
                this.updateStateUnit(TextureUnitStateUnit.makeTextureUnitStateUnit(i, null, null));
            } else if (texture != null && texture.isChanged() || texAttribs != null && texAttribs.isChanged() || texCoordGen != null && texCoordGen.isChanged()) {
                texShader.update(texture, texAttribs, texCoordGen);
                this.updateStateMap(texShader);
            }
            this.getStateUnit(TextureUnitStateUnit.STATE_TYPES[i]).updateCachedStateId();
        }
        if (tuc < this.numValidTUs) {
            for (i = tuc; i < this.numValidTUs; ++i) {
                this.updateStateUnit(TextureUnitStateUnit.DEFAULT_UNIT[i]);
                this.updateStateMap(TextureUnitStateUnit.DEFAULT_UNIT[i]);
                this.getStateUnit(TextureUnitStateUnit.STATE_TYPES[i]).updateCachedStateId();
            }
        }
        this.numValidTUs = tuc;
        if (app.isStatic()) {
            _SG_PrivilegedAccess.markStaticClean(app);
        }
    }

    public boolean isTranslucent() {
        return this.translucent;
    }
}

