/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render.preprocessing.sorting;

import java.util.Comparator;
import org.xith3d.render.preprocessing.RenderAtom;
import org.xith3d.render.preprocessing.RenderBin;
import org.xith3d.render.preprocessing.ShapeAtom;
import org.xith3d.render.preprocessing.sorting.RenderBinSorter;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph._SG_PrivilegedAccess;
import org.xith3d.utility.comparator.Sorter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackToFrontRenderBinSorter
extends RenderBinSorter
implements Comparator<RenderAtom<?>> {
    @Override
    public int compare(RenderAtom<?> atom1, RenderAtom<?> atom2) {
        if (atom1.getSquaredDistanceToView() > atom2.getSquaredDistanceToView()) {
            return -1;
        }
        if (atom1.getSquaredDistanceToView() < atom2.getSquaredDistanceToView()) {
            return 1;
        }
        if (atom1 instanceof ShapeAtom && atom2 instanceof ShapeAtom) {
            int p2;
            int p1 = _SG_PrivilegedAccess.getPassId((Shape3D)atom1.getNode());
            if (p1 < (p2 = _SG_PrivilegedAccess.getPassId((Shape3D)atom2.getNode()))) {
                return -1;
            }
            if (p1 > p2) {
                return 1;
            }
        }
        return 0;
    }

    @Override
    public boolean equals(Object o) {
        return false;
    }

    @Override
    public void sortRenderBin(RenderBin renderBin, Transform3D viewTransform) {
        this.updateDistancesToView(renderBin, null);
        RenderBin.DynamicAtomArray buckets = renderBin.getAtoms();
        Sorter.quickSort(buckets.getRawArray(), 0, buckets.size() - 1, this);
    }
}

