/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render.states.units;

import org.jagatoo.opengl.enums.BlendMode;
import org.xith3d.render.states.StateMap;
import org.xith3d.render.states.StateUnit;
import org.xith3d.scenegraph.ColoringAttributes;
import org.xith3d.scenegraph.TransparencyAttributes;

public class ColoringStateUnit
extends StateUnit {
    public static final int STATE_TYPE = StateMap.newStateType();
    public static final StateMap coloringStateMap = new StateMap();
    public static final StateMap transparencyStateMap = new StateMap();
    public static final ColoringAttributes DEFAULT_COLOR_ATTR = new ColoringAttributes();
    public static final TransparencyAttributes DEFAULT_TRANS_ATTR = new TransparencyAttributes(BlendMode.NONE, 0.0f);
    private ColoringAttributes coloringAttribs;
    private TransparencyAttributes transparencyAttribs;

    public final ColoringAttributes getColoringAttributes() {
        return this.coloringAttribs;
    }

    public final TransparencyAttributes getTransparencyAttributes() {
        return this.transparencyAttribs;
    }

    public static boolean isDefault(ColoringStateUnit cs) {
        return cs.coloringAttribs == DEFAULT_COLOR_ATTR && cs.transparencyAttribs == DEFAULT_TRANS_ATTR;
    }

    public ColoringAttributes getNodeComponent() {
        return this.coloringAttribs;
    }

    public final boolean isTranslucent() {
        if (!this.transparencyAttribs.isSortEnabled()) {
            return false;
        }
        return this.transparencyAttribs.getMode() == TransparencyAttributes.BLENDED;
    }

    public final long getStateId() {
        return this.transparencyAttribs.getStateId() << 20 | this.coloringAttribs.getStateId();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "( state-type: " + this.getStateType() + ", " + "state-ID: " + this.getStateId() + " )";
    }

    public final void update(ColoringAttributes ca, TransparencyAttributes ta) {
        this.coloringAttribs = ca != null ? ca : DEFAULT_COLOR_ATTR;
        this.transparencyAttribs = ta != null ? ta : DEFAULT_TRANS_ATTR;
        coloringStateMap.assignState(this.coloringAttribs);
        transparencyStateMap.assignState(this.transparencyAttribs);
    }

    private ColoringStateUnit(ColoringAttributes ca, TransparencyAttributes ta) {
        super(STATE_TYPE, false);
        this.update(ca, ta);
    }

    public static ColoringStateUnit makeColoringStateUnit(ColoringAttributes ca, TransparencyAttributes ta, StateUnit[] cache) {
        if (cache[STATE_TYPE] != null) {
            ColoringStateUnit stateUnit = (ColoringStateUnit)cache[STATE_TYPE];
            stateUnit.update(ca, ta);
            return stateUnit;
        }
        ColoringStateUnit stateUnit = new ColoringStateUnit(ca, ta);
        cache[ColoringStateUnit.STATE_TYPE] = stateUnit;
        return stateUnit;
    }
}

