/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render.states.units;

import org.xith3d.render.states.StateMap;
import org.xith3d.render.states.StateUnit;
import org.xith3d.scenegraph.InheritedNodeAttributes;
import org.xith3d.scenegraph.Light;
import org.xith3d.scenegraph.NodeComponent;

public class LightingStateUnit
extends StateUnit {
    public static final int STATE_TYPE = StateMap.newStateType();
    private final InheritedNodeAttributes inheritedNodeAttribs;

    public NodeComponent getNodeComponent() {
        return null;
    }

    public final boolean isTranslucent() {
        return false;
    }

    public final int numLights() {
        return this.inheritedNodeAttribs.getLightsCount();
    }

    public final Light getLight(int index) {
        return this.inheritedNodeAttribs.getLight(index);
    }

    public final long getStateId() {
        long stateId = 0L;
        for (int i = 0; i < this.inheritedNodeAttribs.getEffectiveLightsCount(); ++i) {
            stateId |= (long)(this.inheritedNodeAttribs.getLight(i).getLightID() << i * 8);
        }
        return stateId;
    }

    public String toString() {
        String s = "LightingStateUnit: ";
        for (int i = 0; i < this.numLights(); ++i) {
            s = s + this.getLight(i).getName() + " ";
        }
        return s;
    }

    private final void update(boolean forced) {
        if (this.inheritedNodeAttribs.getLightsDirty() || forced) {
            this.updateCachedStateId();
            this.inheritedNodeAttribs.setLightsClean();
        }
    }

    public final void update() {
        this.update(false);
    }

    private LightingStateUnit(InheritedNodeAttributes inheritedNodeAttribs) {
        super(STATE_TYPE, false);
        this.inheritedNodeAttribs = inheritedNodeAttribs;
    }

    public static LightingStateUnit makeLightingStateUnit(InheritedNodeAttributes inheritedNodeAttribs) {
        LightingStateUnit stateUnit = new LightingStateUnit(inheritedNodeAttribs);
        stateUnit.update(true);
        return stateUnit;
    }
}

