/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render.states.units;

import org.xith3d.render.states.StateMap;
import org.xith3d.render.states.StateUnit;
import org.xith3d.scenegraph.PointAttributes;

public class PointAttribsStateUnit
extends StateUnit {
    public static final int STATE_TYPE = StateMap.newStateType();
    private static final StateMap POINT_STATE_MAP = new StateMap();
    private static final PointAttribsStateUnit DEFAULT_POINT = new PointAttribsStateUnit(new PointAttributes(), true);
    private PointAttributes pointAttribs;

    public final PointAttributes getPointAttibutes() {
        return this.pointAttribs;
    }

    public PointAttributes getNodeComponent() {
        return this.pointAttribs;
    }

    public final boolean isTranslucent() {
        if (this.pointAttribs == null) {
            return false;
        }
        if (!this.pointAttribs.isSortEnabled()) {
            return false;
        }
        return this.pointAttribs.isPointAntialiasingEnabled();
    }

    public final long getStateId() {
        return this.pointAttribs.getStateId();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "( state-type: " + this.getStateType() + ", " + "state-ID: " + this.getStateId() + " )";
    }

    public final void update(PointAttributes pa) {
        this.pointAttribs = pa;
        POINT_STATE_MAP.assignState(pa);
    }

    private PointAttribsStateUnit(PointAttributes pa, boolean isDefault) {
        super(STATE_TYPE, isDefault);
        this.update(pa);
    }

    public static PointAttribsStateUnit makePointAttribsStateUnit(PointAttributes pa, StateUnit[] cache) {
        if (pa == null) {
            return DEFAULT_POINT;
        }
        if (cache[STATE_TYPE] != null) {
            PointAttribsStateUnit stateUnit = (PointAttribsStateUnit)cache[STATE_TYPE];
            stateUnit.update(pa);
            return stateUnit;
        }
        PointAttribsStateUnit stateUnit = new PointAttribsStateUnit(pa, false);
        cache[PointAttribsStateUnit.STATE_TYPE] = stateUnit;
        return stateUnit;
    }
}

