/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render.states.units;

import org.xith3d.render.states.StateMap;
import org.xith3d.render.states.StateUnit;
import org.xith3d.scenegraph.PolygonAttributes;

public class PolygonAttribsStateUnit
extends StateUnit {
    public static final int STATE_TYPE = StateMap.newStateType();
    private static final StateMap POLYGON_STATE_MAP = new StateMap();
    private static final PolygonAttribsStateUnit DEFAULT_POLYGON = new PolygonAttribsStateUnit(new PolygonAttributes(), true);
    private PolygonAttributes polyAttribs;

    public final PolygonAttributes getPolygonAttributes() {
        return this.polyAttribs;
    }

    public PolygonAttributes getNodeComponent() {
        return this.polyAttribs;
    }

    public final boolean isTranslucent() {
        if (this.polyAttribs == null) {
            return false;
        }
        if (!this.polyAttribs.isSortEnabled()) {
            return false;
        }
        return this.polyAttribs.isPolygonAntialiasingEnabled();
    }

    public final long getStateId() {
        return this.polyAttribs.getStateId();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "( state-type: " + this.getStateType() + ", " + "state-ID: " + this.getStateId() + " )";
    }

    public final void update(PolygonAttributes pa) {
        this.polyAttribs = pa;
        POLYGON_STATE_MAP.assignState(pa);
    }

    private PolygonAttribsStateUnit(PolygonAttributes a, boolean isDefault) {
        super(STATE_TYPE, isDefault);
        this.update(a);
    }

    public static PolygonAttribsStateUnit makePolygonAttribsStateUnit(PolygonAttributes pa, StateUnit[] cache) {
        if (pa == null) {
            return DEFAULT_POLYGON;
        }
        if (cache[STATE_TYPE] != null) {
            PolygonAttribsStateUnit stateUnit = (PolygonAttribsStateUnit)cache[STATE_TYPE];
            stateUnit.update(pa);
            return stateUnit;
        }
        PolygonAttribsStateUnit stateUnit = new PolygonAttribsStateUnit(pa, false);
        cache[PolygonAttribsStateUnit.STATE_TYPE] = stateUnit;
        return stateUnit;
    }
}

