/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.resources;

import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.loop.opscheduler.impl.ScheduledOperationImpl;
import org.xith3d.resources.LoadingScreenUpdater;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.Texture2D;

public class DelayedLoadingScreenUpdater
extends ScheduledOperationImpl
implements LoadingScreenUpdater {
    private final LoadingScreenUpdater loadingScreenUpdater;
    private int init_maxValue = 0;
    private String init_caption = null;
    private Texture2D init_backgroundTexture = null;
    private boolean initRequested = false;
    private int update_incValue = 0;
    private String update_caption = null;
    private Texture2D update_backgroundTexture = null;
    private boolean updateRequested = false;
    private final Object mutex = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(int maxValue, String caption, Texture2D backgroundTexture) {
        Object object = this.mutex;
        synchronized (object) {
            this.init_maxValue = maxValue;
            this.init_caption = caption;
            this.init_backgroundTexture = backgroundTexture;
            this.initRequested = true;
        }
    }

    public final void init(int maxValue, String caption, String backgroundTexture) {
        this.init(maxValue, caption, TextureLoader.getInstance().getTextureOrNull(backgroundTexture, Texture.MipmapMode.BASE_LEVEL));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(int incValue, String caption, Texture2D backgroundTexture) {
        Object object = this.mutex;
        synchronized (object) {
            this.update_incValue += incValue;
            this.update_caption = caption;
            this.update_backgroundTexture = backgroundTexture;
            this.updateRequested = true;
        }
    }

    public final void update(int incValue, Texture2D backgroundTexture) {
        this.update(incValue, (String)null, backgroundTexture);
    }

    public final void update(Texture2D backgroundTexture) {
        this.update(1, (String)null, backgroundTexture);
    }

    public final void updateOnly(Texture2D backgroundTexture) {
        this.update(0, (String)null, backgroundTexture);
    }

    public final void update(int incValue, String caption, String backgroundTexture) {
        this.update(incValue, caption, TextureLoader.getInstance().getTexture(backgroundTexture, Texture.MipmapMode.BASE_LEVEL));
    }

    public final void update(int incValue, String caption) {
        this.update(incValue, caption, (Texture2D)null);
    }

    public final void update(int incValue) {
        this.update(incValue, (String)null, (Texture2D)null);
    }

    public final void updateOnly(String caption) {
        this.update(0, caption, (Texture2D)null);
    }

    public final void update(String caption) {
        this.update(1, caption, (Texture2D)null);
    }

    public final void update() {
        this.update(1, (String)null, (Texture2D)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        if (this.initRequested || this.updateRequested) {
            Object object = this.mutex;
            synchronized (object) {
                if (this.initRequested) {
                    this.loadingScreenUpdater.init(this.init_maxValue, this.init_caption, this.init_backgroundTexture);
                    this.init_maxValue = 0;
                    this.init_caption = null;
                    this.init_backgroundTexture = null;
                    this.initRequested = false;
                }
                if (this.updateRequested) {
                    this.loadingScreenUpdater.update(this.update_incValue, this.update_caption, this.update_backgroundTexture);
                    this.update_incValue = 0;
                    this.update_caption = null;
                    this.update_backgroundTexture = null;
                    this.updateRequested = false;
                }
            }
        }
    }

    public DelayedLoadingScreenUpdater(LoadingScreenUpdater loadingScreenUpdater) {
        super(true);
        this.loadingScreenUpdater = loadingScreenUpdater;
    }
}

