/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.resources;

import org.xith3d.loop.RenderLoop;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.loop.opscheduler.impl.ScheduledOperationImpl;
import org.xith3d.resources.DelayedLoadingScreenUpdater;
import org.xith3d.resources.LoadingScreenUpdater;
import org.xith3d.resources.ResourceBag;
import org.xith3d.resources.ResourceBagReceiver;
import org.xith3d.resources.ResourceLoader;

public abstract class LoadingPhaseController
extends ScheduledOperationImpl {
    private int stage = 0;
    private final RenderLoop renderLoop;
    private final float reducedMaxFPS;
    private float oldMaxFPS = 0.0f;
    private final ResourceLoader resLoader;
    private final DelayedLoadingScreenUpdater loadingScreenUpdater;
    private ResourceBag resBag = null;
    private final ResourceBagReceiver resBagReceiver;

    protected float reduceMaxFPS(float reducedMaxFPS, RenderLoop renderLoop) {
        float oldMaxFPS = renderLoop.getMaxFPS();
        renderLoop.setMaxFPS(reducedMaxFPS);
        return oldMaxFPS;
    }

    protected void restoreMaxFPS(float oldMaxFPS, RenderLoop renderLoop) {
        renderLoop.setMaxFPS(oldMaxFPS);
    }

    protected abstract ResourceBag load(ResourceLoader var1, LoadingScreenUpdater var2);

    private void initialize() {
        this.oldMaxFPS = this.reduceMaxFPS(this.reducedMaxFPS, this.renderLoop);
        new Thread(){

            public void run() {
                LoadingPhaseController.this.resBag = null;
                LoadingPhaseController.this.resBag = LoadingPhaseController.this.load(LoadingPhaseController.this.resLoader, LoadingPhaseController.this.loadingScreenUpdater);
            }
        }.start();
    }

    protected void destroy() {
        this.restoreMaxFPS(this.oldMaxFPS, this.renderLoop);
        this.setAlive(false);
    }

    public void update(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        switch (this.stage) {
            case 0: {
                this.initialize();
                this.stage = 1;
                break;
            }
            case 1: {
                if (this.resBag == null) break;
                this.destroy();
                this.resBagReceiver.setResourceBag(this.resBag);
                this.stage = 2;
            }
        }
        this.loadingScreenUpdater.update(gameTime, frameTime, timingMode);
    }

    public LoadingPhaseController(RenderLoop renderLoop, float reducedMaxFPS, ResourceLoader resLoader, LoadingScreenUpdater loadingScreenUpdater, ResourceBagReceiver resBagReceiver) {
        super(true);
        this.renderLoop = renderLoop;
        this.reducedMaxFPS = reducedMaxFPS;
        this.resLoader = resLoader;
        this.loadingScreenUpdater = new DelayedLoadingScreenUpdater(loadingScreenUpdater);
        this.resBagReceiver = resBagReceiver;
    }
}

