/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.resources;

import org.jagatoo.loaders.textures.locators.TextureStreamLocator;
import org.jagatoo.opengl.enums.TextureFormat;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.resources.ResourceBag;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.resources.ResourceRequest;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.Texture2D;

public class TextureResourceRequest
implements ResourceRequest {
    private final String name;
    private final String bagName;
    private final TextureFormat format;
    private final boolean flipped;
    private final Texture.MipmapMode mipmapMode;
    private final boolean fallbackTextureAccepted;
    private final TextureStreamLocator tsl;

    public final String getName() {
        return this.name;
    }

    public final String getBagName() {
        return this.bagName;
    }

    public final boolean flipped() {
        return this.flipped;
    }

    public final TextureFormat format() {
        return this.format;
    }

    public final Texture.MipmapMode mipmapMode() {
        return this.mipmapMode;
    }

    public final boolean fallbackTextureAccepted() {
        return this.fallbackTextureAccepted;
    }

    public final TextureStreamLocator getTSL() {
        return this.tsl;
    }

    public Object loadResource(ResourceLocator resLoc, ResourceBag resBag) {
        Texture2D tex;
        if (this.getTSL() != null) {
            TextureLoader.getInstance().addTextureStreamLocator(this.getTSL());
        }
        if ((tex = TextureLoader.getInstance().getTexture(this.getName(), this.flipped() ? TextureLoader.FlipMode.FLIPPED_VERTICALLY : TextureLoader.FlipMode.NOT_FLIPPED, this.format(), this.mipmapMode())) == TextureLoader.getFallbackTexture() && !this.fallbackTextureAccepted()) {
            tex = null;
        }
        if (this.getTSL() != null) {
            TextureLoader.getInstance().removeTextureStreamLocator(this.getTSL());
        }
        resBag.addTexture(this.getBagName(), tex);
        return tex;
    }

    public TextureResourceRequest(String name, String bagName, TextureFormat format, Texture.MipmapMode mipmapMode, boolean flipped, boolean fallbackTextureAccepted, TextureStreamLocator tsl) {
        this.name = name;
        this.bagName = bagName;
        this.format = format;
        this.flipped = flipped;
        this.mipmapMode = mipmapMode;
        this.fallbackTextureAccepted = fallbackTextureAccepted;
        this.tsl = tsl;
    }

    public TextureResourceRequest(String name, String bagName, TextureFormat format, Texture.MipmapMode mipmapMode, boolean flipped, TextureStreamLocator tsl) {
        this(name, bagName, format, mipmapMode, flipped, true, tsl);
    }

    public TextureResourceRequest(String name, String bagName, TextureFormat format, Texture.MipmapMode mipmapMode, TextureStreamLocator tsl) {
        this(name, bagName, format, mipmapMode, true, true, tsl);
    }

    public TextureResourceRequest(String name, String bagName, TextureFormat format, TextureStreamLocator tsl) {
        this(name, bagName, format, Texture.MipmapMode.MULTI_LEVEL_MIPMAP, true, true, tsl);
    }

    public TextureResourceRequest(String name, String bagName, TextureStreamLocator tsl) {
        this(name, bagName, null, Texture.MipmapMode.MULTI_LEVEL_MIPMAP, true, true, tsl);
    }

    public TextureResourceRequest(String name, String bagName, TextureFormat format, Texture.MipmapMode mipmapMode, boolean flipped, boolean fallbackTextureAccepted) {
        this(name, bagName, format, mipmapMode, flipped, true, null);
    }

    public TextureResourceRequest(String name, String bagName, TextureFormat format, Texture.MipmapMode mipmapMode, boolean flipped) {
        this(name, bagName, format, mipmapMode, flipped, true, null);
    }

    public TextureResourceRequest(String name, String bagName, TextureFormat format, Texture.MipmapMode mipmapMode) {
        this(name, bagName, format, mipmapMode, true, true, null);
    }

    public TextureResourceRequest(String name, String bagName, TextureFormat format) {
        this(name, bagName, format, Texture.MipmapMode.MULTI_LEVEL_MIPMAP, true, true, null);
    }

    public TextureResourceRequest(String name, String bagName) {
        this(name, bagName, null, Texture.MipmapMode.MULTI_LEVEL_MIPMAP, true, true, null);
    }
}

