/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph;

import org.xith3d.scenegraph.AssemblyFragmentShader;
import org.xith3d.scenegraph.AssemblyShader;
import org.xith3d.scenegraph.AssemblyVertexShader;
import org.xith3d.scenegraph.NodeComponent;
import org.xith3d.scenegraph.ShaderProgram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssemblyShaderProgram
extends ShaderProgram<AssemblyShader> {
    @Override
    public boolean equals(Object o) {
        int i;
        if (this == o) {
            return true;
        }
        if (!(o instanceof AssemblyShaderProgram)) {
            return false;
        }
        AssemblyShaderProgram lo = (AssemblyShaderProgram)o;
        if (this.isEnabled() != lo.isEnabled()) {
            return false;
        }
        if (this.getNumVertexShaders() != lo.getNumVertexShaders()) {
            return false;
        }
        if (this.getNumFragmentShaders() != lo.getNumFragmentShaders()) {
            return false;
        }
        for (i = 0; i < this.getNumVertexShaders(); ++i) {
            if (((AssemblyShader)this.getVertexShader(i)).equals(lo.getVertexShader(i))) continue;
            return false;
        }
        for (i = 0; i < this.getNumFragmentShaders(); ++i) {
            if (((AssemblyShader)this.getFragmentShader(i)).equals(lo.getFragmentShader(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(ShaderProgram<AssemblyShader> o) {
        int i;
        if (this == o) {
            return 0;
        }
        if (this.getNumVertexShaders() > o.getNumVertexShaders()) {
            return 1;
        }
        if (this.getNumVertexShaders() < o.getNumVertexShaders()) {
            return -1;
        }
        if (this.getNumFragmentShaders() > o.getNumFragmentShaders()) {
            return 1;
        }
        if (this.getNumFragmentShaders() < o.getNumFragmentShaders()) {
            return -1;
        }
        int result = 0;
        for (i = 0; i < this.getNumVertexShaders(); ++i) {
            result += ((AssemblyShader)this.getVertexShader(i)).compareTo(o.getVertexShader(i));
        }
        for (i = 0; i < this.getNumFragmentShaders(); ++i) {
            result += ((AssemblyShader)this.getFragmentShader(i)).compareTo(o.getFragmentShader(i));
        }
        if (result > 0) {
            return 1;
        }
        if (result < 0) {
            return -1;
        }
        return 0;
    }

    @Override
    protected void duplicateNodeComponent(NodeComponent original, boolean forceDuplicate) {
        super.duplicateNodeComponent(original, forceDuplicate);
        AssemblyShaderProgram o = (AssemblyShaderProgram)original;
        this.removeAllShaders();
        if (forceDuplicate) {
            AssemblyShader s2;
            AssemblyShader shader;
            int i;
            for (i = 0; i < o.getNumVertexShaders(); ++i) {
                shader = (AssemblyShader)o.getVertexShader(i);
                s2 = new AssemblyVertexShader(shader.getShaderCode(), shader.shaderProgramParameters, shader.isEnabled());
                this.addShader(s2);
            }
            for (i = 0; i < o.getNumFragmentShaders(); ++i) {
                shader = (AssemblyShader)o.getFragmentShader(i);
                s2 = new AssemblyFragmentShader(shader.getShaderCode(), shader.shaderProgramParameters, shader.isEnabled());
                this.addShader(s2);
            }
        } else {
            int i;
            for (i = 0; i < o.getNumVertexShaders(); ++i) {
                this.addShader(o.getVertexShader(i));
            }
            for (i = 0; i < o.getNumFragmentShaders(); ++i) {
                this.addShader(o.getFragmentShader(i));
            }
        }
    }

    @Override
    public AssemblyShaderProgram cloneNodeComponent(boolean forceDuplicate) {
        AssemblyShaderProgram clone = new AssemblyShaderProgram(this.isEnabled());
        clone.duplicateNodeComponent(this, forceDuplicate);
        return clone;
    }

    @Override
    public AssemblyShaderProgram getCopy() {
        return this.cloneNodeComponent(true);
    }

    public AssemblyShaderProgram(boolean enabled) {
        super(enabled);
    }

    public AssemblyShaderProgram() {
        this(true);
    }

    public AssemblyShaderProgram(AssemblyVertexShader vertexShader, AssemblyFragmentShader fragmentShader, boolean enabled) {
        this(enabled);
        if (vertexShader != null) {
            this.addShader(vertexShader);
        }
        if (fragmentShader != null) {
            this.addShader(fragmentShader);
        }
    }

    public AssemblyShaderProgram(AssemblyVertexShader vertexShader, AssemblyFragmentShader fragmentShader) {
        this(vertexShader, fragmentShader, true);
    }
}

