/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph;

import java.util.ArrayList;
import java.util.HashMap;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Matrix3f;
import org.openmali.vecmath2.Matrix4f;
import org.openmali.vecmath2.TexCoordf;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.TupleNi;
import org.xith3d.render.CanvasPeer;
import org.xith3d.scenegraph.NodeComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GLSLParameters
extends NodeComponent {
    private final HashMap<String, Object> uniformVars = new HashMap();
    private final ArrayList<String> floatUniformVarNames = new ArrayList();
    private final ArrayList<String> intUniformVarNames = new ArrayList();
    private final ArrayList<Integer> floatUniformVarBaseSizes = new ArrayList();
    private final ArrayList<Integer> intUniformVarBaseSizes = new ArrayList();

    public final int getNumUniformVarsFloat() {
        return this.floatUniformVarNames.size();
    }

    public final int getNumUniformVarsInt() {
        return this.intUniformVarNames.size();
    }

    public final boolean hasUniformVars() {
        return this.floatUniformVarNames.size() > 0 || this.intUniformVarNames.size() > 0;
    }

    public final int getUniformVarBaseSizeFloat(int i) {
        return this.floatUniformVarBaseSizes.get(i);
    }

    public final int getUniformVarBaseSizeInt(int i) {
        return this.intUniformVarBaseSizes.get(i);
    }

    public final String getFloatUniformVarName(int i) {
        return this.floatUniformVarNames.get(i);
    }

    public final String getIntUniformVarName(int i) {
        return this.intUniformVarNames.get(i);
    }

    public final float[] getUniformVarValueFloat(String varName) {
        return (float[])this.uniformVars.get(varName);
    }

    public final int[] getUniformVarValueInt(String varName) {
        return (int[])this.uniformVars.get(varName);
    }

    public final float[] getUniformVarValueFloat(int i) {
        return (float[])this.uniformVars.get(this.floatUniformVarNames.get(i));
    }

    public final int[] getUniformVarValueInt(int i) {
        return (int[])this.uniformVars.get(this.intUniformVarNames.get(i));
    }

    public final void setUniformVar(String name, float[] values) {
        Object oldValueObj = this.uniformVars.get(name);
        if (oldValueObj == null) {
            float[] newValue = new float[values.length];
            System.arraycopy(values, 0, newValue, 0, values.length);
            this.floatUniformVarNames.add(name);
            this.floatUniformVarBaseSizes.add(1);
            this.uniformVars.put(name, newValue);
        } else if (!(oldValueObj instanceof float[])) {
            int intIndex = this.intUniformVarNames.indexOf(name);
            if (intIndex >= 0) {
                this.intUniformVarNames.remove(intIndex);
                this.intUniformVarBaseSizes.remove(intIndex);
            }
            float[] newValue = new float[values.length];
            System.arraycopy(values, 0, newValue, 0, values.length);
            this.floatUniformVarNames.add(name);
            this.floatUniformVarBaseSizes.add(1);
            this.uniformVars.put(name, newValue);
        } else if (((float[])oldValueObj).length != values.length) {
            float[] newValue = new float[values.length];
            System.arraycopy(values, 0, newValue, 0, values.length);
            this.uniformVars.put(name, newValue);
            int floatIndex = this.floatUniformVarNames.indexOf(name);
            this.floatUniformVarBaseSizes.set(floatIndex, 1);
        } else {
            float[] newValue = (float[])oldValueObj;
            System.arraycopy(values, 0, newValue, 0, values.length);
        }
    }

    public final void setUniformVar(String name, float value) {
        Object oldValueObj = this.uniformVars.get(name);
        if (oldValueObj == null) {
            float[] newValue = new float[]{value};
            this.floatUniformVarNames.add(name);
            this.floatUniformVarBaseSizes.add(1);
            this.uniformVars.put(name, newValue);
        } else if (!(oldValueObj instanceof float[])) {
            int intIndex = this.intUniformVarNames.indexOf(name);
            if (intIndex >= 0) {
                this.intUniformVarNames.remove(intIndex);
                this.intUniformVarBaseSizes.remove(intIndex);
            }
            float[] newValue = new float[]{value};
            this.floatUniformVarNames.add(name);
            this.floatUniformVarBaseSizes.add(1);
            this.uniformVars.put(name, newValue);
        } else if (((float[])oldValueObj).length != 1) {
            float[] newValue = new float[]{value};
            this.uniformVars.put(name, newValue);
            int floatIndex = this.floatUniformVarNames.indexOf(name);
            this.floatUniformVarBaseSizes.set(floatIndex, 1);
        } else {
            float[] newValue = (float[])oldValueObj;
            newValue[0] = value;
        }
    }

    public final void setUniformVar(String name, int[] values) {
        Object oldValueObj = this.uniformVars.get(name);
        if (oldValueObj == null) {
            int[] newValue = new int[values.length];
            System.arraycopy(values, 0, newValue, 0, values.length);
            this.intUniformVarNames.add(name);
            this.intUniformVarBaseSizes.add(1);
            this.uniformVars.put(name, newValue);
        } else if (!(oldValueObj instanceof int[])) {
            int floatIndex = this.floatUniformVarNames.indexOf(name);
            if (floatIndex >= 0) {
                this.floatUniformVarNames.remove(floatIndex);
                this.floatUniformVarBaseSizes.remove(floatIndex);
            }
            int[] newValue = new int[values.length];
            System.arraycopy(values, 0, newValue, 0, values.length);
            this.intUniformVarNames.add(name);
            this.intUniformVarBaseSizes.add(1);
            this.uniformVars.put(name, newValue);
        } else if (((int[])oldValueObj).length != values.length) {
            int[] newValue = new int[values.length];
            System.arraycopy(values, 0, newValue, 0, values.length);
            this.uniformVars.put(name, newValue);
            int intIndex = this.intUniformVarNames.indexOf(name);
            this.intUniformVarBaseSizes.set(intIndex, 1);
        } else {
            int[] newValue = (int[])oldValueObj;
            System.arraycopy(values, 0, newValue, 0, values.length);
        }
    }

    public final void setUniformVar(String name, int value) {
        Object oldValueObj = this.uniformVars.get(name);
        if (oldValueObj == null) {
            int[] newValue = new int[]{value};
            this.intUniformVarNames.add(name);
            this.intUniformVarBaseSizes.add(1);
            this.uniformVars.put(name, newValue);
        } else if (!(oldValueObj instanceof int[])) {
            int floatIndex = this.floatUniformVarNames.indexOf(name);
            if (floatIndex >= 0) {
                this.floatUniformVarNames.remove(floatIndex);
                this.floatUniformVarBaseSizes.remove(floatIndex);
            }
            int[] newValue = new int[]{value};
            this.intUniformVarNames.add(name);
            this.intUniformVarBaseSizes.add(1);
            this.uniformVars.put(name, newValue);
        } else if (((int[])oldValueObj).length != 1) {
            int[] newValue = new int[]{value};
            this.uniformVars.put(name, newValue);
            int intIndex = this.intUniformVarNames.indexOf(name);
            this.intUniformVarBaseSizes.set(intIndex, 1);
        } else {
            int[] newValue = (int[])oldValueObj;
            newValue[0] = value;
        }
    }

    private static final void copyMatricesToArray(Matrix3f[] mats, float[] target) {
        int offset = 0;
        for (int i = 0; i < mats.length; ++i) {
            mats[i].getColumnMajor(target, offset);
            offset += 9;
        }
    }

    public final void setUniformVar(String name, Matrix3f[] values) {
        Object oldValueObj = this.uniformVars.get(name);
        if (oldValueObj == null) {
            float[] newValue = new float[values.length * 9];
            GLSLParameters.copyMatricesToArray(values, newValue);
            this.floatUniformVarNames.add(name);
            this.floatUniformVarBaseSizes.add(9);
            this.uniformVars.put(name, newValue);
        } else if (!(oldValueObj instanceof float[])) {
            int intIndex = this.intUniformVarNames.indexOf(name);
            if (intIndex >= 0) {
                this.intUniformVarNames.remove(intIndex);
                this.intUniformVarBaseSizes.remove(intIndex);
            }
            float[] newValue = new float[values.length * 9];
            GLSLParameters.copyMatricesToArray(values, newValue);
            this.floatUniformVarNames.add(name);
            this.floatUniformVarBaseSizes.add(9);
            this.uniformVars.put(name, newValue);
        } else if (((float[])oldValueObj).length != values.length * 9) {
            float[] newValue = new float[values.length * 9];
            GLSLParameters.copyMatricesToArray(values, newValue);
            this.uniformVars.put(name, newValue);
            int floatIndex = this.floatUniformVarNames.indexOf(name);
            this.floatUniformVarBaseSizes.set(floatIndex, 9);
        } else {
            float[] newValue = (float[])oldValueObj;
            GLSLParameters.copyMatricesToArray(values, newValue);
        }
    }

    public final void setUniformVar(String name, Matrix3f value) {
        this.setUniformVar(name, new Matrix3f[]{value});
    }

    private static final void copyMatricesToArray(Matrix4f[] mats, float[] target) {
        int offset = 0;
        for (int i = 0; i < mats.length; ++i) {
            mats[i].getColumnMajor(target, offset);
            offset += 16;
        }
    }

    public final void setUniformVar(String name, Matrix4f[] values) {
        Object oldValueObj = this.uniformVars.get(name);
        if (oldValueObj == null) {
            float[] newValue = new float[values.length * 16];
            GLSLParameters.copyMatricesToArray(values, newValue);
            this.floatUniformVarNames.add(name);
            this.floatUniformVarBaseSizes.add(16);
            this.uniformVars.put(name, newValue);
        } else if (!(oldValueObj instanceof float[])) {
            int intIndex = this.intUniformVarNames.indexOf(name);
            if (intIndex >= 0) {
                this.intUniformVarNames.remove(intIndex);
                this.intUniformVarBaseSizes.remove(intIndex);
            }
            float[] newValue = new float[values.length * 16];
            GLSLParameters.copyMatricesToArray(values, newValue);
            this.floatUniformVarNames.add(name);
            this.floatUniformVarBaseSizes.add(16);
            this.uniformVars.put(name, newValue);
        } else if (((float[])oldValueObj).length != values.length * 16) {
            float[] newValue = new float[values.length * 16];
            GLSLParameters.copyMatricesToArray(values, newValue);
            this.uniformVars.put(name, newValue);
            int floatIndex = this.floatUniformVarNames.indexOf(name);
            this.floatUniformVarBaseSizes.set(floatIndex, 16);
        } else {
            float[] newValue = (float[])oldValueObj;
            GLSLParameters.copyMatricesToArray(values, newValue);
        }
    }

    public final void setUniformVar(String name, Matrix4f value) {
        this.setUniformVar(name, new Matrix4f[]{value});
    }

    private static final void copyTuplesToArray(TupleNf<?>[] tuples, float[] target) {
        int offset = 0;
        for (int i = 0; i < tuples.length; ++i) {
            tuples[i].get(target, offset);
            offset += tuples[i].getSize();
        }
    }

    public final void setUniformVar(String name, TupleNf<?>[] values) {
        int size = values[0].getSize();
        Object oldValueObj = this.uniformVars.get(name);
        if (oldValueObj == null) {
            float[] newValue = new float[values.length * size];
            GLSLParameters.copyTuplesToArray(values, newValue);
            this.floatUniformVarNames.add(name);
            this.floatUniformVarBaseSizes.add(size);
            this.uniformVars.put(name, newValue);
        } else if (!(oldValueObj instanceof float[])) {
            int intIndex = this.intUniformVarNames.indexOf(name);
            if (intIndex >= 0) {
                this.intUniformVarNames.remove(intIndex);
                this.intUniformVarBaseSizes.remove(intIndex);
            }
            float[] newValue = new float[values.length * size];
            GLSLParameters.copyTuplesToArray(values, newValue);
            this.floatUniformVarNames.add(name);
            this.floatUniformVarBaseSizes.add(size);
            this.uniformVars.put(name, newValue);
        } else if (((float[])oldValueObj).length != values.length * size) {
            float[] newValue = new float[values.length * size];
            GLSLParameters.copyTuplesToArray(values, newValue);
            this.uniformVars.put(name, newValue);
            int floatIndex = this.floatUniformVarNames.indexOf(name);
            this.floatUniformVarBaseSizes.set(floatIndex, size);
        } else {
            float[] newValue = (float[])oldValueObj;
            GLSLParameters.copyTuplesToArray(values, newValue);
        }
    }

    public final void setUniformVar(String name, TupleNf<?> value) {
        this.setUniformVar(name, new TupleNf[]{value});
    }

    public final void setUniformVar(String name, int baseSize, float ... values) {
        int size = values.length - values.length % baseSize;
        Object oldValueObj = this.uniformVars.get(name);
        if (oldValueObj == null) {
            float[] newValue = new float[size];
            System.arraycopy(values, 0, newValue, 0, size);
            this.floatUniformVarNames.add(name);
            this.floatUniformVarBaseSizes.add(baseSize);
            this.uniformVars.put(name, newValue);
        } else if (!(oldValueObj instanceof float[])) {
            int intIndex = this.intUniformVarNames.indexOf(name);
            if (intIndex >= 0) {
                this.intUniformVarNames.remove(intIndex);
                this.intUniformVarBaseSizes.remove(intIndex);
            }
            float[] newValue = new float[size];
            System.arraycopy(values, 0, newValue, 0, size);
            this.floatUniformVarNames.add(name);
            this.floatUniformVarBaseSizes.add(baseSize);
            this.uniformVars.put(name, newValue);
        } else if (((float[])oldValueObj).length != size) {
            float[] newValue = new float[size];
            System.arraycopy(values, 0, newValue, 0, size);
            this.uniformVars.put(name, newValue);
            int floatIndex = this.floatUniformVarNames.indexOf(name);
            this.floatUniformVarBaseSizes.set(floatIndex, baseSize);
        } else {
            float[] newValue = (float[])oldValueObj;
            System.arraycopy(values, 0, newValue, 0, size);
        }
    }

    public final void setUniformVar(String name, int baseSize, int ... values) {
        int size = values.length - values.length % baseSize;
        Object oldValueObj = this.uniformVars.get(name);
        if (oldValueObj == null) {
            int[] newValue = new int[size];
            System.arraycopy(values, 0, newValue, 0, size);
            this.intUniformVarNames.add(name);
            this.intUniformVarBaseSizes.add(baseSize);
            this.uniformVars.put(name, newValue);
        } else if (!(oldValueObj instanceof int[])) {
            int floatIndex = this.floatUniformVarNames.indexOf(name);
            if (floatIndex >= 0) {
                this.floatUniformVarNames.remove(floatIndex);
                this.floatUniformVarBaseSizes.remove(floatIndex);
            }
            int[] newValue = new int[size];
            System.arraycopy(values, 0, newValue, 0, size);
            this.intUniformVarNames.add(name);
            this.intUniformVarBaseSizes.add(baseSize);
            this.uniformVars.put(name, newValue);
        } else if (((int[])oldValueObj).length != size) {
            int[] newValue = new int[size];
            System.arraycopy(values, 0, newValue, 0, size);
            this.uniformVars.put(name, newValue);
            int intIndex = this.intUniformVarNames.indexOf(name);
            this.intUniformVarBaseSizes.set(intIndex, baseSize);
        } else {
            int[] newValue = (int[])oldValueObj;
            System.arraycopy(values, 0, newValue, 0, size);
        }
    }

    private static final void copyColorsToArray(Colorf[] colors, float[] target) {
        int offset = 0;
        for (int i = 0; i < colors.length; ++i) {
            colors[i].get(target, offset);
            offset += colors[i].getSize();
        }
    }

    public final void setUniformVar(String name, Colorf[] values) {
        int size = values[0].hasAlpha() ? 4 : 3;
        Object oldValueObj = this.uniformVars.get(name);
        if (oldValueObj == null) {
            float[] newValue = new float[values.length * size];
            GLSLParameters.copyColorsToArray(values, newValue);
            this.floatUniformVarNames.add(name);
            this.floatUniformVarBaseSizes.add(size);
            this.uniformVars.put(name, newValue);
        } else if (!(oldValueObj instanceof float[])) {
            int intIndex = this.intUniformVarNames.indexOf(name);
            if (intIndex >= 0) {
                this.intUniformVarNames.remove(intIndex);
                this.intUniformVarBaseSizes.remove(intIndex);
            }
            float[] newValue = new float[values.length * size];
            GLSLParameters.copyColorsToArray(values, newValue);
            this.floatUniformVarNames.add(name);
            this.floatUniformVarBaseSizes.add(size);
            this.uniformVars.put(name, newValue);
        } else if (((float[])oldValueObj).length != values.length * size) {
            float[] newValue = new float[values.length * size];
            GLSLParameters.copyColorsToArray(values, newValue);
            this.uniformVars.put(name, newValue);
            int floatIndex = this.floatUniformVarNames.indexOf(name);
            this.floatUniformVarBaseSizes.set(floatIndex, size);
        } else {
            float[] newValue = (float[])oldValueObj;
            GLSLParameters.copyColorsToArray(values, newValue);
        }
    }

    public final void setUniformVar(String name, Colorf value) {
        this.setUniformVar(name, new Colorf[]{value});
    }

    private static final void copyTexCoordsToArray(TexCoordf<?>[] texCoords, float[] target) {
        int offset = 0;
        for (int i = 0; i < texCoords.length; ++i) {
            texCoords[i].get(target, offset);
            offset += texCoords[i].getSize();
        }
    }

    public final void setUniformVar(String name, TexCoordf<?>[] values) {
        int size = values[0].getSize();
        Object oldValueObj = this.uniformVars.get(name);
        if (oldValueObj == null) {
            float[] newValue = new float[values.length * size];
            GLSLParameters.copyTexCoordsToArray(values, newValue);
            this.floatUniformVarNames.add(name);
            this.floatUniformVarBaseSizes.add(size);
            this.uniformVars.put(name, newValue);
        } else if (!(oldValueObj instanceof float[])) {
            int intIndex = this.intUniformVarNames.indexOf(name);
            if (intIndex >= 0) {
                this.intUniformVarNames.remove(intIndex);
                this.intUniformVarBaseSizes.remove(intIndex);
            }
            float[] newValue = new float[values.length * size];
            GLSLParameters.copyTexCoordsToArray(values, newValue);
            this.floatUniformVarNames.add(name);
            this.floatUniformVarBaseSizes.add(size);
            this.uniformVars.put(name, newValue);
        } else if (((float[])oldValueObj).length != values.length * size) {
            float[] newValue = new float[values.length * size];
            GLSLParameters.copyTexCoordsToArray(values, newValue);
            this.uniformVars.put(name, newValue);
            int floatIndex = this.floatUniformVarNames.indexOf(name);
            this.floatUniformVarBaseSizes.set(floatIndex, size);
        } else {
            float[] newValue = (float[])oldValueObj;
            GLSLParameters.copyTexCoordsToArray(values, newValue);
        }
    }

    public final void setUniformVar(String name, TexCoordf<?> value) {
        this.setUniformVar(name, new TexCoordf[]{value});
    }

    private static final void copyTuplesToArray(TupleNi<?>[] tuples, int[] target) {
        int offset = 0;
        for (int i = 0; i < tuples.length; ++i) {
            tuples[i].get(target, offset);
            offset += tuples[i].getSize();
        }
    }

    public final void setUniformVar(String name, TupleNi<?>[] values) {
        int size = values[0].getSize();
        Object oldValueObj = this.uniformVars.get(name);
        if (oldValueObj == null) {
            int[] newValue = new int[values.length * size];
            GLSLParameters.copyTuplesToArray(values, newValue);
            this.intUniformVarNames.add(name);
            this.intUniformVarBaseSizes.add(size);
            this.uniformVars.put(name, newValue);
        } else if (!(oldValueObj instanceof int[])) {
            int floatIndex = this.floatUniformVarNames.indexOf(name);
            if (floatIndex >= 0) {
                this.floatUniformVarNames.remove(floatIndex);
                this.floatUniformVarBaseSizes.remove(floatIndex);
            }
            int[] newValue = new int[values.length * size];
            GLSLParameters.copyTuplesToArray(values, newValue);
            this.intUniformVarNames.add(name);
            this.intUniformVarBaseSizes.add(size);
            this.uniformVars.put(name, newValue);
        } else if (((int[])oldValueObj).length != values.length * size) {
            int[] newValue = new int[values.length * size];
            GLSLParameters.copyTuplesToArray(values, newValue);
            this.uniformVars.put(name, newValue);
            int intIndex = this.intUniformVarNames.indexOf(name);
            this.intUniformVarBaseSizes.set(intIndex, size);
        } else {
            int[] newValue = (int[])oldValueObj;
            GLSLParameters.copyTuplesToArray(values, newValue);
        }
    }

    public final void setUniformVar(String name, TupleNi<?> value) {
        this.setUniformVar(name, new TupleNi[]{value});
    }

    public final void removeUniformVar(String name) {
        int index = this.floatUniformVarNames.indexOf(name);
        if (index >= 0) {
            this.floatUniformVarNames.remove(index);
            this.floatUniformVarBaseSizes.remove(index);
            this.uniformVars.remove(name);
            return;
        }
        index = this.intUniformVarNames.indexOf(name);
        if (index >= 0) {
            this.intUniformVarNames.remove(index);
            this.intUniformVarBaseSizes.remove(index);
            this.uniformVars.remove(name);
            return;
        }
    }

    public GLSLParameters getCopy() {
        return this.cloneNodeComponent(true);
    }

    @Override
    protected void duplicateNodeComponent(NodeComponent original, boolean forceDuplicate) {
        GLSLParameters orgParams = (GLSLParameters)original;
        this.uniformVars.clear();
        this.floatUniformVarNames.clear();
        this.intUniformVarNames.clear();
        this.floatUniformVarBaseSizes.clear();
        this.intUniformVarBaseSizes.clear();
        this.uniformVars.putAll(orgParams.uniformVars);
        this.floatUniformVarNames.addAll(orgParams.floatUniformVarNames);
        this.intUniformVarNames.addAll(orgParams.intUniformVarNames);
        this.floatUniformVarBaseSizes.addAll(orgParams.floatUniformVarBaseSizes);
        this.intUniformVarBaseSizes.addAll(orgParams.intUniformVarBaseSizes);
    }

    @Override
    public GLSLParameters cloneNodeComponent(boolean forceDuplicate) {
        GLSLParameters clone = new GLSLParameters();
        clone.duplicateNodeComponent(this, forceDuplicate);
        return clone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GLSLParameters)) {
            return false;
        }
        return false;
    }

    @Override
    public void freeOpenGLResources(CanvasPeer canvasPeer) {
    }

    public GLSLParameters() {
        super(false);
    }
}

