/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph;

import org.xith3d.scenegraph.Shader;
import org.xith3d.utility.comparator.ComparatorHelper;

public abstract class GLSLShader
extends Shader {
    private boolean compilationError = false;

    protected GLSLShader(Shader.ShaderType type, String shaderCode) {
        super(type, shaderCode, true);
    }

    protected GLSLShader(Shader.ShaderType type) {
        this(type, null);
    }

    public void setCompilationError(boolean compilationError) {
        this.compilationError = compilationError;
    }

    public boolean hasCompilationError() {
        return this.compilationError;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GLSLShader)) {
            return false;
        }
        GLSLShader as = (GLSLShader)o;
        if (this.getType() != as.getType()) {
            return false;
        }
        if (this.isEnabled() != as.isEnabled()) {
            return false;
        }
        return ComparatorHelper.compare(this.getShaderCode(), as.getShaderCode()) == 0;
    }

    public int compareTo(Shader o) {
        if (this == o) {
            return 0;
        }
        if (!(o instanceof GLSLShader)) {
            return -1;
        }
        if (this.getType().ordinal() < o.getType().ordinal()) {
            return -1;
        }
        if (this.getType().ordinal() > o.getType().ordinal()) {
            return 1;
        }
        GLSLShader s2 = (GLSLShader)o;
        int val = ComparatorHelper.compareBoolean(this.isEnabled(), s2.isEnabled());
        if (val != 0) {
            return val;
        }
        val = ComparatorHelper.compare(this.getShaderCode(), s2.getShaderCode());
        if (val != 0) {
            return val;
        }
        return 0;
    }
}

