/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph;

import org.xith3d.scenegraph.GLSLShader;
import org.xith3d.scenegraph.Shader;

public class GLSLVertexShader
extends GLSLShader {
    private String[] vertexAttribsMap = null;
    private int[] vertexAttribIndices = null;

    private static final int findIndex(int[] array, int value) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != value) continue;
            return i;
        }
        return -1;
    }

    public void setVertexAttributeMapping(int index, String name) {
        if (name == null) {
            throw new NullPointerException("name must not be null");
        }
        if (this.vertexAttribIndices == null) {
            this.vertexAttribIndices = new int[]{index};
            this.vertexAttribsMap = new String[index + 1];
            this.vertexAttribsMap[index] = name;
        } else {
            int arrayIndex = GLSLVertexShader.findIndex(this.vertexAttribIndices, index);
            if (arrayIndex >= 0) {
                this.vertexAttribsMap[arrayIndex] = name;
            } else {
                if (index >= this.vertexAttribsMap.length) {
                    String[] vertexAttribsMap2 = new String[index + 1];
                    System.arraycopy(this.vertexAttribsMap, 0, vertexAttribsMap2, 0, this.vertexAttribsMap.length);
                    this.vertexAttribsMap = vertexAttribsMap2;
                }
                this.vertexAttribsMap[index] = name;
                int[] vertexAttribIndices2 = new int[this.vertexAttribIndices.length + 1];
                System.arraycopy(this.vertexAttribIndices, 0, vertexAttribIndices2, 0, this.vertexAttribIndices.length);
                this.vertexAttribIndices = vertexAttribIndices2;
                this.vertexAttribIndices[this.vertexAttribIndices.length - 1] = index;
            }
        }
    }

    public int getVertexAttributesCount() {
        if (this.vertexAttribIndices == null) {
            return 0;
        }
        return this.vertexAttribIndices.length;
    }

    public int getNthVertexAttributeIndex(int n) {
        return this.vertexAttribIndices[n];
    }

    public String getVertexAttributeMapping(int index) {
        return this.vertexAttribsMap[index];
    }

    public GLSLVertexShader(String source) {
        super(Shader.ShaderType.VERTEX, source);
    }

    public GLSLVertexShader() {
        this((String)null);
    }
}

