/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph;

import org.jagatoo.opengl.enums.GeometryArrayType;
import org.xith3d.scenegraph.GeomNioIntData;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.NodeComponent;

public abstract class IndexedGeometryArray
extends Geometry {
    private int[] index;
    private boolean indexDirty = true;

    public final int getIndexCount() {
        return this.getIndex().length;
    }

    public final void setValidIndexCount(int count) {
        this.dataContainer.setValidVertexCount(count);
        this.setChanged(true);
        this.setBoundsDirty();
    }

    public final int getValidIndexCount() {
        return this.dataContainer.getValidVertexCount();
    }

    public final void setInitialIndexIndex(int i) {
        this.dataContainer.setInitialIndex(i);
    }

    public final int getInitialIndexIndex() {
        return this.dataContainer.getInitialIndex();
    }

    public final void setIndex(int[] indices) {
        System.arraycopy(indices, 0, this.index, 0, indices.length);
        this.indexDirty = true;
    }

    public final void setIndex(int i, int idx) {
        this.index[i] = idx;
        this.indexDirty = true;
    }

    public final int getIndex(int i) {
        return this.index[i];
    }

    public final int[] getIndex() {
        return this.index;
    }

    public final GeomNioIntData getIndexData() {
        if (this.indexDirty) {
            this.dataContainer.getIndexData().set(this.getInitialIndexIndex(), this.index, this.getInitialIndexIndex(), this.getValidIndexCount());
            this.indexDirty = false;
        }
        return (GeomNioIntData)this.dataContainer.getIndexData();
    }

    protected void duplicateNodeComponent(NodeComponent original, boolean forceDuplicate) {
        super.duplicateNodeComponent(original, forceDuplicate);
        IndexedGeometryArray o = (IndexedGeometryArray)original;
        this.index = new int[o.getIndexCount()];
        this.setIndex(o.getIndex());
    }

    public IndexedGeometryArray(GeometryArrayType type, int coordsSize, int vertexCount, int[] stripVertexCounts, int indexCount) {
        super(type, true, coordsSize, vertexCount, stripVertexCounts, indexCount);
        this.index = new int[indexCount];
    }
}

