/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph;

import org.jagatoo.opengl.enums.GeometryArrayType;
import org.openmali.spatial.LineContainer;
import org.openmali.vecmath2.Tuple3f;
import org.xith3d.scenegraph.IndexedGeometryStripArray;
import org.xith3d.scenegraph.NodeComponent;

public class IndexedLineStripArray
extends IndexedGeometryStripArray
implements LineContainer {
    public final boolean isTriangulatable() {
        return false;
    }

    public final boolean isTriangulated() {
        return false;
    }

    public final int getLinesCount() {
        int lc = 0;
        for (int i = 0; i < this.getNumStrips(); ++i) {
            lc += this.getStripVertexCounts()[i];
        }
        return lc;
    }

    public final boolean getLineCoordinates(int i, Tuple3f start, Tuple3f end) {
        int[] stripLengths = this.getStripVertexCounts();
        int offset = 0;
        for (int j = 0; j < stripLengths.length; ++j) {
            int stripLineCount = stripLengths[j] - 1;
            if (i < offset + stripLineCount) {
                int idx0 = i + j * 1;
                this.getCoordinate(this.getIndex(idx0), start);
                this.getCoordinate(this.getIndex(idx0 + 1), end);
                return true;
            }
            offset += stripLineCount;
        }
        return false;
    }

    protected void duplicateNodeComponent(NodeComponent original, boolean forceDuplicate) {
        super.duplicateNodeComponent(original, forceDuplicate);
    }

    public IndexedLineStripArray cloneNodeComponent(boolean forceDuplicate) {
        IndexedLineStripArray ilsa = new IndexedLineStripArray(this.getCoordinatesSize(), this.getVertexCount(), this.getIndexCount(), this.getStripVertexCounts());
        ilsa.duplicateNodeComponent(this, forceDuplicate);
        return ilsa;
    }

    public IndexedLineStripArray(int coordsSize, int vertexCount, int indexCount, int[] stripIndexCounts) {
        super(GeometryArrayType.LINE_STRIP, coordsSize, vertexCount, indexCount, stripIndexCounts);
    }

    public IndexedLineStripArray(int vertexCount, int indexCount, int[] stripIndexCounts) {
        this(3, vertexCount, indexCount, stripIndexCounts);
    }

    public IndexedLineStripArray(int coordsSize, int vertexCount, int indexCount) {
        this(coordsSize, vertexCount, indexCount, new int[]{indexCount});
    }

    public IndexedLineStripArray(int vertexCount, int indexCount) {
        this(vertexCount, indexCount, new int[]{indexCount});
    }
}

