/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph;

import org.jagatoo.util.arrays.ArrayUtils;
import org.xith3d.scenegraph.AbstractLODShape3D;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.utils.CopyListener;

public class LODShape3D
extends AbstractLODShape3D {
    private Geometry[] lodGeoms = new Geometry[16];
    private Appearance[] lodApps = new Appearance[16];

    protected void onLODChanged(int oldLOD, int newLOD, String name) {
        this.setGeometry(this.lodGeoms[newLOD]);
        this.setAppearance(this.lodApps[newLOD]);
    }

    public int addLOD(String name, float minDist, float maxDist, Geometry geom, Appearance app) {
        int oldNumLODs = this.getNumLODs();
        int level = super.addLOD(name, minDist, maxDist);
        if (oldNumLODs > 0) {
            this.lodGeoms = (Geometry[])ArrayUtils.ensureCapacity((Object[])this.lodGeoms, Geometry.class, (int)(this.getNumLODs() + 1));
            this.lodApps = (Appearance[])ArrayUtils.ensureCapacity((Object[])this.lodApps, Appearance.class, (int)(this.getNumLODs() + 1));
            if (level < oldNumLODs) {
                System.arraycopy(this.lodGeoms, level, this.lodGeoms, level + 1, oldNumLODs - level);
                System.arraycopy(this.lodApps, level, this.lodApps, level + 1, oldNumLODs - level);
            }
        }
        this.lodGeoms[level] = geom;
        this.lodApps[level] = app;
        return level;
    }

    public int addLOD(float minDist, float maxDist, Geometry geom, Appearance app) {
        return this.addLOD(null, minDist, maxDist, geom, app);
    }

    protected LODShape3D newInstance() {
        boolean gib = Node.globalIgnoreBounds;
        Node.globalIgnoreBounds = this.isIgnoreBounds();
        LODShape3D newShape = new LODShape3D();
        Node.globalIgnoreBounds = gib;
        return newShape;
    }

    protected void copy(Shape3D dst) {
        super.copy(dst);
        LODShape3D newShape = (LODShape3D)dst;
        if (newShape.lodGeoms.length != this.lodGeoms.length) {
            newShape.lodGeoms = new Geometry[this.lodGeoms.length];
        }
        System.arraycopy(this.lodGeoms, 0, newShape.lodGeoms, 0, this.lodGeoms.length);
        if (newShape.lodApps.length != this.lodApps.length) {
            newShape.lodApps = new Appearance[this.lodApps.length];
        }
        System.arraycopy(this.lodApps, 0, newShape.lodApps, 0, this.lodApps.length);
    }

    public LODShape3D sharedCopy(CopyListener listener) {
        return (LODShape3D)super.sharedCopy(listener);
    }
}

