/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph;

import org.jagatoo.opengl.enums.GeometryArrayType;
import org.openmali.spatial.LineContainer;
import org.openmali.vecmath2.Tuple3f;
import org.xith3d.scenegraph.GeometryStripArray;
import org.xith3d.scenegraph.NodeComponent;

public class LineStripArray
extends GeometryStripArray
implements LineContainer {
    public final boolean isTriangulatable() {
        return false;
    }

    public final boolean isTriangulated() {
        return false;
    }

    public final int getLinesCount() {
        int lc = 0;
        for (int i = 0; i < this.getNumStrips(); ++i) {
            lc += this.getStripVertexCounts()[i];
        }
        return lc;
    }

    public final boolean getLineCoordinates(int i, Tuple3f start, Tuple3f end) {
        int[] stripLengths = this.getStripVertexCounts();
        int offset = 0;
        for (int j = 0; j < stripLengths.length; ++j) {
            int stripLineCount = stripLengths[j] - 1;
            if (i < offset + stripLineCount) {
                int idx0 = i + j * 1;
                this.getCoordinate(idx0, start);
                this.getCoordinate(idx0 + 1, end);
                return true;
            }
            offset += stripLineCount;
        }
        return false;
    }

    protected void duplicateNodeComponent(NodeComponent original, boolean forceDuplicate) {
        super.duplicateNodeComponent(original, forceDuplicate);
    }

    public LineStripArray cloneNodeComponent(boolean forceDuplicate) {
        LineStripArray lsa = new LineStripArray(this.getCoordinatesSize(), this.getVertexCount(), this.getStripVertexCounts());
        lsa.duplicateNodeComponent(this, forceDuplicate);
        return lsa;
    }

    public LineStripArray(int coordsSize, int vertexCount, int[] stripVertexCounts) {
        super(GeometryArrayType.LINE_STRIP, coordsSize, vertexCount, stripVertexCounts);
    }

    public LineStripArray(int vertexCount, int[] stripVertexCounts) {
        this(3, vertexCount, stripVertexCounts);
    }

    public LineStripArray(int coordsSize, int vertexCount) {
        this(coordsSize, vertexCount, new int[]{vertexCount});
    }

    public LineStripArray(int vertexCount) {
        this(3, vertexCount, new int[]{vertexCount});
    }
}

