/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph;

import org.xith3d.render.Canvas3D;
import org.xith3d.render.CanvasPeer;
import org.xith3d.scenegraph.GlobalOptions;
import org.xith3d.scenegraph.SceneGraphObject;
import org.xith3d.scenegraph.modifications.ScenegraphModificationsListener;

public abstract class NodeComponent
extends SceneGraphObject {
    private boolean duplicateOnCloneTree = false;
    private boolean changed = true;
    private final boolean isGlobalOptionsRelevant;
    private short lastKnownGlobalOptionsChangeID = (short)(GlobalOptions.getInstance().getChangeID() - 1);
    private ScenegraphModificationsListener modListener = null;

    public void setModListener(ScenegraphModificationsListener modListener) {
        this.modListener = modListener;
    }

    public final ScenegraphModificationsListener getModListener() {
        return this.modListener;
    }

    protected void setChanged(boolean changed) {
        if (!changed) {
            this.lastKnownGlobalOptionsChangeID = GlobalOptions.getInstance().getChangeID();
        }
        if (changed == this.changed) {
            return;
        }
        this.changed = changed;
        if (changed && this.modListener != null) {
            this.modListener.onNodeComponentChanged(this);
        }
    }

    public boolean isChanged() {
        return this.changed;
    }

    public boolean isChanged2() {
        return this.changed || this.isGlobalOptionsRelevant && this.lastKnownGlobalOptionsChangeID < GlobalOptions.getInstance().getChangeID();
    }

    public final void setDuplicateOnCloneTree(boolean b) {
        this.duplicateOnCloneTree = b;
    }

    public final boolean getDuplicateOnCloneTree() {
        return this.duplicateOnCloneTree;
    }

    protected void duplicateNodeComponent(NodeComponent original, boolean forceDuplicate) {
        this.duplicateOnCloneTree = original.getDuplicateOnCloneTree();
        this.setName(original.getName());
        this.setUserData(original.getUserData());
    }

    public abstract NodeComponent cloneNodeComponent(boolean var1);

    public abstract void freeOpenGLResources(CanvasPeer var1);

    public final void freeOpenGLResources(Canvas3D canvas) {
        if (canvas.getPeer() == null) {
            throw new Error("The given Canvas3D is not linked to a CanvasPeer.");
        }
        this.freeOpenGLResources(canvas.getPeer());
    }

    public NodeComponent(boolean isGlobalOptionsRelevant) {
        this.isGlobalOptionsRelevant = isGlobalOptionsRelevant;
    }
}

