/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph;

import org.openmali.spatial.SpatialNode;
import org.openmali.spatial.bodies.Classifier;
import org.openmali.spatial.bodies.Frustum;
import org.openmali.spatial.bounds.BoundingBox;
import org.openmali.spatial.bounds.Bounds;
import org.openmali.spatial.octree.OcCell;
import org.openmali.spatial.octree.OcTree;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple3f;
import org.xith3d.picking.PickRay;
import org.xith3d.render.OpenGLCapabilities;
import org.xith3d.render.preprocessing.FrustumCuller;
import org.xith3d.render.preprocessing.RenderBinProvider;
import org.xith3d.scenegraph.Group;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.SpecialCullingNode;
import org.xith3d.scenegraph.View;
import org.xith3d.scenegraph._SG_PrivilegedAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OcTreeGroup
extends Group
implements SpecialCullingNode<OcTreeGroup> {
    private final OcTree<Node> ocTree;
    private static final byte B0 = 0;
    private static final byte B1 = 1;
    private static final byte B2 = 2;
    private static final byte B3 = 4;
    private static final byte B4 = 8;
    private static final byte B5 = 16;
    private static final byte B6 = 32;
    private static final byte B7 = 64;
    private static final byte B8 = -128;

    final OcTree<Node> getOcTree() {
        return this.ocTree;
    }

    public void setMinNodesBeforeSplit(int minNodesBeforeSplit) {
        this.ocTree.setMinNodesBeforeSplit(minNodesBeforeSplit);
    }

    public final int getMinNodesBeforeSplit() {
        return this.ocTree.getMinNodesBeforeSplit();
    }

    public void setMaxLevelForExtendedCells(int maxLevelForExtendedCells) {
        this.ocTree.setMaxLevelForExtendedCells(maxLevelForExtendedCells);
    }

    public final int getMaxLevelForExtendedCells() {
        return this.ocTree.getMaxLevelForExtendedCells();
    }

    public final int getMaxOcTreeLevel() {
        return this.ocTree.getMaxLevel();
    }

    @Override
    public void addChild(Node child, int index) {
        super.addChild(child, index);
        this.ocTree.insertNode((SpatialNode)child);
    }

    @Override
    public Node removeChild(int index) {
        Node node = super.removeChild(index);
        this.ocTree.removeNode((SpatialNode)node);
        return node;
    }

    @Override
    public void removeAllChildren() {
        super.removeAllChildren();
        this.ocTree.clear();
    }

    public final void updateNodePosition(Node node) {
        if (node.getParent() != this) {
            throw new Error("The given Node is not in this group.");
        }
        this.ocTree.updateNodePosition((SpatialNode)node);
    }

    @Override
    public final void dump() {
        this.ocTree.dump();
    }

    private final void cullOcTreeAtoms(Classifier.Classification parentClassify, OcCell<Node> cell, boolean cullingSuppressed, View view, Point3f viewPosition, Frustum frustum, RenderBinProvider binProvider, OpenGLCapabilities glCaps, long frameId, long nanoTime, long nanoStep, PickRay pickRay, boolean isShadowPass, FrustumCuller frustumCuller) {
        Classifier.Classification classify = parentClassify;
        if (!cullingSuppressed && classify != Classifier.Classification.INSIDE) {
            classify = Classifier.classifyFrustumBox((Frustum)frustum, cell);
            if (classify == Classifier.Classification.OUTSIDE) {
                return;
            }
        } else {
            classify = parentClassify;
            cullingSuppressed = true;
        }
        for (int i = 0; i < cell.getNumNodes(); ++i) {
            frustumCuller.cullNodeAtoms((Node)cell.getNode(i), classify, cullingSuppressed, view, viewPosition, frustum, binProvider, glCaps, frameId, nanoTime, nanoStep, pickRay, isShadowPass);
        }
        if (cell.hasChildCells()) {
            if (cell.getCellOcLowerBackLeft() != null) {
                this.cullOcTreeAtoms(classify, (OcCell<Node>)cell.getCellOcLowerBackLeft(), cullingSuppressed, view, viewPosition, frustum, binProvider, glCaps, frameId, nanoTime, nanoStep, pickRay, isShadowPass, frustumCuller);
            }
            if (cell.getCellOcLowerBackRight() != null) {
                this.cullOcTreeAtoms(classify, (OcCell<Node>)cell.getCellOcLowerBackRight(), cullingSuppressed, view, viewPosition, frustum, binProvider, glCaps, frameId, nanoTime, nanoStep, pickRay, isShadowPass, frustumCuller);
            }
            if (cell.getCellOcLowerFrontLeft() != null) {
                this.cullOcTreeAtoms(classify, (OcCell<Node>)cell.getCellOcLowerFrontLeft(), cullingSuppressed, view, viewPosition, frustum, binProvider, glCaps, frameId, nanoTime, nanoStep, pickRay, isShadowPass, frustumCuller);
            }
            if (cell.getCellOcLowerFrontRight() != null) {
                this.cullOcTreeAtoms(classify, (OcCell<Node>)cell.getCellOcLowerFrontRight(), cullingSuppressed, view, viewPosition, frustum, binProvider, glCaps, frameId, nanoTime, nanoStep, pickRay, isShadowPass, frustumCuller);
            }
            if (cell.getCellOcUpperBackLeft() != null) {
                this.cullOcTreeAtoms(classify, (OcCell<Node>)cell.getCellOcUpperBackLeft(), cullingSuppressed, view, viewPosition, frustum, binProvider, glCaps, frameId, nanoTime, nanoStep, pickRay, isShadowPass, frustumCuller);
            }
            if (cell.getCellOcUpperBackRight() != null) {
                this.cullOcTreeAtoms(classify, (OcCell<Node>)cell.getCellOcUpperBackRight(), cullingSuppressed, view, viewPosition, frustum, binProvider, glCaps, frameId, nanoTime, nanoStep, pickRay, isShadowPass, frustumCuller);
            }
            if (cell.getCellOcUpperFrontLeft() != null) {
                this.cullOcTreeAtoms(classify, (OcCell<Node>)cell.getCellOcUpperFrontLeft(), cullingSuppressed, view, viewPosition, frustum, binProvider, glCaps, frameId, nanoTime, nanoStep, pickRay, isShadowPass, frustumCuller);
            }
            if (cell.getCellOcUpperFrontRight() != null) {
                this.cullOcTreeAtoms(classify, (OcCell<Node>)cell.getCellOcUpperFrontRight(), cullingSuppressed, view, viewPosition, frustum, binProvider, glCaps, frameId, nanoTime, nanoStep, pickRay, isShadowPass, frustumCuller);
            }
        }
    }

    private final byte cullOcTreeAtomsExt(byte result, Classifier.Classification parentClassify, OcCell<Node> cell, boolean cullingSuppressed, View view, Point3f viewPosition, Frustum frustum, RenderBinProvider binProvider, OpenGLCapabilities glCaps, long frameId, long nanoTime, long nanoStep, PickRay pickRay, boolean isShadowPass, FrustumCuller frustumCuller) {
        Classifier.Classification classify;
        if (!cullingSuppressed && parentClassify != Classifier.Classification.INSIDE) {
            classify = Classifier.classifyFrustumBox((Frustum)frustum, cell);
            if (classify == Classifier.Classification.OUTSIDE) {
                return result;
            }
        } else {
            classify = parentClassify;
            cullingSuppressed = true;
        }
        int culled = 0;
        boolean cs = cullingSuppressed;
        for (int i = 0; i < cell.getNumNodes(); ++i) {
            frustumCuller.cullNodeAtoms((Node)cell.getNode(i), classify, cs, view, viewPosition, frustum, binProvider, glCaps, frameId, nanoTime, nanoStep, pickRay, isShadowPass);
        }
        if (cell.hasChildCells()) {
            if (cell.usesExtendedCells()) {
                if (cell.getCellQuUpperBack() != null) {
                    culled = (byte)(culled | this.cullOcTreeAtomsExt((byte)48, classify, (OcCell<Node>)cell.getCellQuUpperBack(), cullingSuppressed, view, viewPosition, frustum, binProvider, glCaps, frameId, nanoTime, nanoStep, pickRay, isShadowPass, frustumCuller));
                }
                if (cell.getCellQuUpperFront() != null) {
                    culled = (byte)(culled | this.cullOcTreeAtomsExt((byte)-64, classify, (OcCell<Node>)cell.getCellQuUpperFront(), cullingSuppressed, view, viewPosition, frustum, binProvider, glCaps, frameId, nanoTime, nanoStep, pickRay, isShadowPass, frustumCuller));
                }
                if (cell.getCellQuUpperLeft() != null) {
                    culled = (byte)(culled | this.cullOcTreeAtomsExt((byte)80, classify, (OcCell<Node>)cell.getCellQuUpperLeft(), cullingSuppressed, view, viewPosition, frustum, binProvider, glCaps, frameId, nanoTime, nanoStep, pickRay, isShadowPass, frustumCuller));
                }
                if (cell.getCellQuUpperRight() != null) {
                    culled = (byte)(culled | this.cullOcTreeAtomsExt((byte)-96, classify, (OcCell<Node>)cell.getCellQuUpperRight(), cullingSuppressed, view, viewPosition, frustum, binProvider, glCaps, frameId, nanoTime, nanoStep, pickRay, isShadowPass, frustumCuller));
                }
                if (cell.getCellQuLowerBack() != null) {
                    culled = (byte)(culled | this.cullOcTreeAtomsExt((byte)3, classify, (OcCell<Node>)cell.getCellQuLowerBack(), cullingSuppressed, view, viewPosition, frustum, binProvider, glCaps, frameId, nanoTime, nanoStep, pickRay, isShadowPass, frustumCuller));
                }
                if (cell.getCellQuLowerFront() != null) {
                    culled = (byte)(culled | this.cullOcTreeAtomsExt((byte)12, classify, (OcCell<Node>)cell.getCellQuLowerFront(), cullingSuppressed, view, viewPosition, frustum, binProvider, glCaps, frameId, nanoTime, nanoStep, pickRay, isShadowPass, frustumCuller));
                }
                if (cell.getCellQuLowerLeft() != null) {
                    culled = (byte)(culled | this.cullOcTreeAtomsExt((byte)5, classify, (OcCell<Node>)cell.getCellQuLowerLeft(), cullingSuppressed, view, viewPosition, frustum, binProvider, glCaps, frameId, nanoTime, nanoStep, pickRay, isShadowPass, frustumCuller));
                }
                if (cell.getCellQuLowerRight() != null) {
                    culled = (byte)(culled | this.cullOcTreeAtomsExt((byte)10, classify, (OcCell<Node>)cell.getCellQuLowerRight(), cullingSuppressed, view, viewPosition, frustum, binProvider, glCaps, frameId, nanoTime, nanoStep, pickRay, isShadowPass, frustumCuller));
                }
                if (cell.getCellQuBackLeft() != null) {
                    culled = (byte)(culled | this.cullOcTreeAtomsExt((byte)17, classify, (OcCell<Node>)cell.getCellQuBackLeft(), cullingSuppressed, view, viewPosition, frustum, binProvider, glCaps, frameId, nanoTime, nanoStep, pickRay, isShadowPass, frustumCuller));
                }
                if (cell.getCellQuBackRight() != null) {
                    culled = (byte)(culled | this.cullOcTreeAtomsExt((byte)34, classify, (OcCell<Node>)cell.getCellQuBackRight(), cullingSuppressed, view, viewPosition, frustum, binProvider, glCaps, frameId, nanoTime, nanoStep, pickRay, isShadowPass, frustumCuller));
                }
                if (cell.getCellQuFrontLeft() != null) {
                    culled = (byte)(culled | this.cullOcTreeAtomsExt((byte)68, classify, (OcCell<Node>)cell.getCellQuFrontLeft(), cullingSuppressed, view, viewPosition, frustum, binProvider, glCaps, frameId, nanoTime, nanoStep, pickRay, isShadowPass, frustumCuller));
                }
                if (cell.getCellQuFrontRight() != null) {
                    culled = (byte)(culled | this.cullOcTreeAtomsExt((byte)-120, classify, (OcCell<Node>)cell.getCellQuFrontRight(), cullingSuppressed, view, viewPosition, frustum, binProvider, glCaps, frameId, nanoTime, nanoStep, pickRay, isShadowPass, frustumCuller));
                }
                if (cell.getCellHUpper() != null) {
                    culled = (byte)(culled | this.cullOcTreeAtomsExt((byte)-16, classify, (OcCell<Node>)cell.getCellHUpper(), cullingSuppressed, view, viewPosition, frustum, binProvider, glCaps, frameId, nanoTime, nanoStep, pickRay, isShadowPass, frustumCuller));
                }
                if (cell.getCellHLower() != null) {
                    culled = (byte)(culled | this.cullOcTreeAtomsExt((byte)15, classify, (OcCell<Node>)cell.getCellHLower(), cullingSuppressed, view, viewPosition, frustum, binProvider, glCaps, frameId, nanoTime, nanoStep, pickRay, isShadowPass, frustumCuller));
                }
                if (cell.getCellHLeft() != null) {
                    culled = (byte)(culled | this.cullOcTreeAtomsExt((byte)85, classify, (OcCell<Node>)cell.getCellHLeft(), cullingSuppressed, view, viewPosition, frustum, binProvider, glCaps, frameId, nanoTime, nanoStep, pickRay, isShadowPass, frustumCuller));
                }
                if (cell.getCellHRight() != null) {
                    culled = (byte)(culled | this.cullOcTreeAtomsExt((byte)-86, classify, (OcCell<Node>)cell.getCellHRight(), cullingSuppressed, view, viewPosition, frustum, binProvider, glCaps, frameId, nanoTime, nanoStep, pickRay, isShadowPass, frustumCuller));
                }
                if (cell.getCellHBack() != null) {
                    culled = (byte)(culled | this.cullOcTreeAtomsExt((byte)51, classify, (OcCell<Node>)cell.getCellHBack(), cullingSuppressed, view, viewPosition, frustum, binProvider, glCaps, frameId, nanoTime, nanoStep, pickRay, isShadowPass, frustumCuller));
                }
                if (cell.getCellHFront() != null) {
                    culled = (byte)(culled | this.cullOcTreeAtomsExt((byte)-52, classify, (OcCell<Node>)cell.getCellHFront(), cullingSuppressed, view, viewPosition, frustum, binProvider, glCaps, frameId, nanoTime, nanoStep, pickRay, isShadowPass, frustumCuller));
                }
            }
            if ((byte)(culled & 1) == 0 && cell.getCellOcLowerBackLeft() != null) {
                this.cullOcTreeAtomsExt((byte)0, classify, (OcCell<Node>)cell.getCellOcLowerBackLeft(), cullingSuppressed, view, viewPosition, frustum, binProvider, glCaps, frameId, nanoTime, nanoStep, pickRay, isShadowPass, frustumCuller);
            }
            if ((byte)(culled & 2) == 0 && cell.getCellOcLowerBackRight() != null) {
                this.cullOcTreeAtomsExt((byte)0, classify, (OcCell<Node>)cell.getCellOcLowerBackRight(), cullingSuppressed, view, viewPosition, frustum, binProvider, glCaps, frameId, nanoTime, nanoStep, pickRay, isShadowPass, frustumCuller);
            }
            if ((byte)(culled & 4) == 0 && cell.getCellOcLowerFrontLeft() != null) {
                this.cullOcTreeAtomsExt((byte)0, classify, (OcCell<Node>)cell.getCellOcLowerFrontLeft(), cullingSuppressed, view, viewPosition, frustum, binProvider, glCaps, frameId, nanoTime, nanoStep, pickRay, isShadowPass, frustumCuller);
            }
            if ((byte)(culled & 8) == 0 && cell.getCellOcLowerFrontRight() != null) {
                this.cullOcTreeAtomsExt((byte)0, classify, (OcCell<Node>)cell.getCellOcLowerFrontRight(), cullingSuppressed, view, viewPosition, frustum, binProvider, glCaps, frameId, nanoTime, nanoStep, pickRay, isShadowPass, frustumCuller);
            }
            if ((byte)(culled & 0x10) == 0 && cell.getCellOcUpperBackLeft() != null) {
                this.cullOcTreeAtomsExt((byte)0, classify, (OcCell<Node>)cell.getCellOcUpperBackLeft(), cullingSuppressed, view, viewPosition, frustum, binProvider, glCaps, frameId, nanoTime, nanoStep, pickRay, isShadowPass, frustumCuller);
            }
            if ((byte)(culled & 0x20) == 0 && cell.getCellOcUpperBackRight() != null) {
                this.cullOcTreeAtomsExt((byte)0, classify, (OcCell<Node>)cell.getCellOcUpperBackRight(), cullingSuppressed, view, viewPosition, frustum, binProvider, glCaps, frameId, nanoTime, nanoStep, pickRay, isShadowPass, frustumCuller);
            }
            if ((byte)(culled & 0x40) == 0 && cell.getCellOcUpperFrontLeft() != null) {
                this.cullOcTreeAtomsExt((byte)0, classify, (OcCell<Node>)cell.getCellOcUpperFrontLeft(), cullingSuppressed, view, viewPosition, frustum, binProvider, glCaps, frameId, nanoTime, nanoStep, pickRay, isShadowPass, frustumCuller);
            }
            if ((byte)(culled & 0xFFFFFF80) == 0 && cell.getCellOcUpperFrontRight() != null) {
                this.cullOcTreeAtomsExt((byte)0, classify, (OcCell<Node>)cell.getCellOcUpperFrontRight(), cullingSuppressed, view, viewPosition, frustum, binProvider, glCaps, frameId, nanoTime, nanoStep, pickRay, isShadowPass, frustumCuller);
            }
        }
        return 0;
    }

    private final void cullOcTreeAtoms(OcTreeGroup ocTreeGroup, boolean cullingSuppressed, View view, Point3f viewPosition, Frustum frustum, RenderBinProvider binProvider, OpenGLCapabilities glCaps, long frameId, long nanoTime, long nanoStep, PickRay pickRay, boolean isShadowPass, FrustumCuller frustumCuller) {
        if (ocTreeGroup.getTransformGroup() != null) {
            throw new Error("An OcTreeGroup must not be nested into a parent TransformGroup!");
        }
        OcCell rootCell = _SG_PrivilegedAccess.getOcTree(ocTreeGroup).getRootCell();
        if (rootCell.usesExtendedCells()) {
            this.cullOcTreeAtomsExt((byte)0, null, (OcCell<Node>)rootCell, cullingSuppressed, view, viewPosition, frustum, binProvider, glCaps, frameId, nanoTime, nanoStep, pickRay, isShadowPass, frustumCuller);
        } else {
            this.cullOcTreeAtoms(null, (OcCell<Node>)rootCell, cullingSuppressed, view, viewPosition, frustum, binProvider, glCaps, frameId, nanoTime, nanoStep, pickRay, isShadowPass, frustumCuller);
        }
    }

    @Override
    public void cullSpecialNode(OcTreeGroup node, boolean cullingSuppressed, View view, Point3f viewPosition, Frustum frustum, RenderBinProvider binProvider, OpenGLCapabilities glCaps, long frameId, long nanoTime, long nanoStep, PickRay pickRay, boolean isShadowPass, FrustumCuller frustumCuller) {
        this.cullOcTreeAtoms(node, cullingSuppressed, view, viewPosition, frustum, binProvider, glCaps, frameId, nanoTime, nanoStep, pickRay, isShadowPass, frustumCuller);
    }

    public OcTreeGroup(float centerX, float centerY, float centerZ, float sizeX, float sizeY, float sizeZ, boolean useExtendedCells) {
        this.ocTree = new OcTree(centerX, centerY, centerZ, sizeX, sizeY, sizeZ, useExtendedCells);
        BoundingBox bb = new BoundingBox();
        this.setBounds((Bounds)bb);
    }

    public OcTreeGroup(Tuple3f center, float sizeX, float sizeY, float sizeZ, boolean useExtendedCells) {
        this(center.getX(), center.getY(), center.getZ(), sizeX, sizeY, sizeZ, useExtendedCells);
    }

    public OcTreeGroup(float centerX, float centerY, float centerZ, float size, boolean useExtendedCells) {
        this(centerX, centerY, centerZ, size, size, size, useExtendedCells);
    }

    public OcTreeGroup(Tuple3f center, float size, boolean useExtendedCells) {
        this(center.getX(), center.getY(), center.getZ(), size, useExtendedCells);
    }
}

