/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph;

import org.jagatoo.opengl.enums.GeometryArrayType;
import org.openmali.spatial.WriteableTriangleContainer;
import org.openmali.spatial.polygons.Triangle;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.NodeComponent;

public class QuadArray
extends Geometry
implements WriteableTriangleContainer {
    public final boolean isTriangulatable() {
        return true;
    }

    public final boolean isTriangulated() {
        return false;
    }

    public int getTriangleCount() {
        return this.getValidVertexCount() / 4 * 2;
    }

    public boolean setTriangle(int i, Triangle triangle) {
        int idx0 = i % 2 == 0 ? i / 2 * 4 + 0 : i / 2 * 4 + 1;
        return this.setTriangle(idx0 + 0, idx0 + 1, idx0 + 2, triangle);
    }

    public boolean getTriangle(int i, Triangle triangle) {
        int idx0 = i % 2 == 0 ? i / 2 * 4 + 0 : i / 2 * 4 + 1;
        return this.getTriangle(idx0 + 0, idx0 + 1, idx0 + 2, triangle);
    }

    protected void duplicateNodeComponent(NodeComponent original, boolean forceDuplicate) {
        super.duplicateNodeComponent(original, forceDuplicate);
    }

    public QuadArray cloneNodeComponent(boolean forceDuplicate) {
        QuadArray qa = new QuadArray(this.getCoordinatesSize(), this.getVertexCount());
        qa.duplicateNodeComponent(this, forceDuplicate);
        return qa;
    }

    public QuadArray(int coordsSize, int vertexCount) {
        super(GeometryArrayType.QUADS, false, coordsSize, vertexCount, null, 0);
    }

    public QuadArray(int vertexCount) {
        this(3, vertexCount);
    }
}

