/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph;

import org.openmali.spatial.AxisIndicator;
import org.openmali.spatial.PlaneIndicator;
import org.openmali.spatial.SpatialNode;
import org.openmali.spatial.bodies.Classifier;
import org.openmali.spatial.bodies.Frustum;
import org.openmali.spatial.bounds.BoundingBox;
import org.openmali.spatial.bounds.Bounds;
import org.openmali.spatial.quadtree.QuadCell;
import org.openmali.spatial.quadtree.QuadTree;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple3f;
import org.xith3d.picking.PickRay;
import org.xith3d.render.OpenGLCapabilities;
import org.xith3d.render.preprocessing.FrustumCuller;
import org.xith3d.render.preprocessing.RenderBinProvider;
import org.xith3d.scenegraph.Group;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.SpecialCullingNode;
import org.xith3d.scenegraph.View;
import org.xith3d.scenegraph._SG_PrivilegedAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuadTreeGroup
extends Group
implements SpecialCullingNode<QuadTreeGroup> {
    public static final PlaneIndicator DEFAULT_PLANE = QuadTree.DEFAULT_PLANE;
    private final QuadTree<Node> quadTree;
    private static final byte B0 = 0;
    private static final byte B1 = 1;
    private static final byte B2 = 2;
    private static final byte B3 = 4;
    private static final byte B4 = 8;

    final QuadTree<Node> getQuadTree() {
        return this.quadTree;
    }

    public void setMinNodesBeforeSplit(int minNodesBeforeSplit) {
        this.quadTree.setMinNodesBeforeSplit(minNodesBeforeSplit);
    }

    public final int getMinNodesBeforeSplit() {
        return this.quadTree.getMinNodesBeforeSplit();
    }

    public void setMaxLevelForExtendedCells(int maxLevelForExtendedCells) {
        this.quadTree.setMaxLevelForExtendedCells(maxLevelForExtendedCells);
    }

    public final int getMaxLevelForExtendedCells() {
        return this.quadTree.getMaxLevelForExtendedCells();
    }

    public final int getMaxOcTreeLevel() {
        return this.quadTree.getMaxLevel();
    }

    @Override
    public void addChild(Node child, int index) {
        super.addChild(child, index);
        this.quadTree.insertNode((SpatialNode)child);
    }

    @Override
    public Node removeChild(int index) {
        Node node = super.removeChild(index);
        this.quadTree.removeNode((SpatialNode)node);
        return node;
    }

    @Override
    public void removeAllChildren() {
        super.removeAllChildren();
        this.quadTree.clear();
    }

    public final void updateNodePosition(Node node) {
        if (node.getParent() != this) {
            throw new Error("The given Node is not in this group.");
        }
        this.quadTree.updateNodePosition((SpatialNode)node);
    }

    @Override
    public final void dump() {
        this.quadTree.dump();
    }

    private final byte cullQuadTreeAtomsExt(byte result, Classifier.Classification parentClassify, QuadCell<Node> cell, boolean cullingSuppressed, View view, Point3f viewPosition, Frustum frustum, RenderBinProvider binProvider, OpenGLCapabilities glCaps, long frameId, long nanoTime, long nanoStep, PickRay pickRay, boolean isShadowPass, FrustumCuller frustumCuller) {
        Classifier.Classification classify;
        if (!cullingSuppressed && parentClassify != Classifier.Classification.INSIDE) {
            classify = Classifier.classifyFrustumBox((Frustum)frustum, cell);
            if (classify == Classifier.Classification.OUTSIDE) {
                return result;
            }
        } else {
            classify = parentClassify;
            cullingSuppressed = true;
        }
        int culled = 0;
        boolean cs = cullingSuppressed;
        for (int i = 0; i < cell.getNumNodes(); ++i) {
            frustumCuller.cullNodeAtoms((Node)cell.getNode(i), classify, cs, view, viewPosition, frustum, binProvider, glCaps, frameId, nanoTime, nanoStep, pickRay, isShadowPass);
        }
        if (cell.hasChildCells()) {
            if (cell.usesExtendedCells()) {
                if (cell.getCellHLeft() != null) {
                    culled = (byte)(culled | this.cullQuadTreeAtomsExt((byte)5, classify, (QuadCell<Node>)cell.getCellHLeft(), cullingSuppressed, view, viewPosition, frustum, binProvider, glCaps, frameId, nanoTime, nanoStep, pickRay, isShadowPass, frustumCuller));
                }
                if (cell.getCellHRight() != null) {
                    culled = (byte)(culled | this.cullQuadTreeAtomsExt((byte)10, classify, (QuadCell<Node>)cell.getCellHRight(), cullingSuppressed, view, viewPosition, frustum, binProvider, glCaps, frameId, nanoTime, nanoStep, pickRay, isShadowPass, frustumCuller));
                }
                if (cell.getCellHBack() != null) {
                    culled = (byte)(culled | this.cullQuadTreeAtomsExt((byte)3, classify, (QuadCell<Node>)cell.getCellHBack(), cullingSuppressed, view, viewPosition, frustum, binProvider, glCaps, frameId, nanoTime, nanoStep, pickRay, isShadowPass, frustumCuller));
                }
                if (cell.getCellHFront() != null) {
                    culled = (byte)(culled | this.cullQuadTreeAtomsExt((byte)12, classify, (QuadCell<Node>)cell.getCellHFront(), cullingSuppressed, view, viewPosition, frustum, binProvider, glCaps, frameId, nanoTime, nanoStep, pickRay, isShadowPass, frustumCuller));
                }
            }
            if ((byte)(culled & 1) == 0 && cell.getCellQuBackLeft() != null) {
                this.cullQuadTreeAtomsExt((byte)0, classify, (QuadCell<Node>)cell.getCellQuBackLeft(), cullingSuppressed, view, viewPosition, frustum, binProvider, glCaps, frameId, nanoTime, nanoStep, pickRay, isShadowPass, frustumCuller);
            }
            if ((byte)(culled & 2) == 0 && cell.getCellQuBackRight() != null) {
                this.cullQuadTreeAtomsExt((byte)0, classify, (QuadCell<Node>)cell.getCellQuBackRight(), cullingSuppressed, view, viewPosition, frustum, binProvider, glCaps, frameId, nanoTime, nanoStep, pickRay, isShadowPass, frustumCuller);
            }
            if ((byte)(culled & 4) == 0 && cell.getCellQuFrontLeft() != null) {
                this.cullQuadTreeAtomsExt((byte)0, classify, (QuadCell<Node>)cell.getCellQuFrontLeft(), cullingSuppressed, view, viewPosition, frustum, binProvider, glCaps, frameId, nanoTime, nanoStep, pickRay, isShadowPass, frustumCuller);
            }
            if ((byte)(culled & 8) == 0 && cell.getCellQuFrontRight() != null) {
                this.cullQuadTreeAtomsExt((byte)0, classify, (QuadCell<Node>)cell.getCellQuFrontRight(), cullingSuppressed, view, viewPosition, frustum, binProvider, glCaps, frameId, nanoTime, nanoStep, pickRay, isShadowPass, frustumCuller);
            }
        }
        return 0;
    }

    private final void cullQuadTreeAtoms(QuadTreeGroup quadTreeGroup, boolean cullingSuppressed, View view, Point3f viewPosition, Frustum frustum, RenderBinProvider binProvider, OpenGLCapabilities glCaps, long frameId, long nanoTime, long nanoStep, PickRay pickRay, boolean isShadowPass, FrustumCuller frustumCuller) {
        if (quadTreeGroup.getTransformGroup() != null) {
            throw new Error("A QuadTreeGroup must not be nested into a parent TransformGroup!");
        }
        QuadCell rootCell = _SG_PrivilegedAccess.getQuadTree(quadTreeGroup).getRootCell();
        this.cullQuadTreeAtomsExt((byte)0, null, (QuadCell<Node>)rootCell, cullingSuppressed, view, viewPosition, frustum, binProvider, glCaps, frameId, nanoTime, nanoStep, pickRay, isShadowPass, frustumCuller);
    }

    @Override
    public void cullSpecialNode(QuadTreeGroup node, boolean cullingSuppressed, View view, Point3f viewPosition, Frustum frustum, RenderBinProvider binProvider, OpenGLCapabilities glCaps, long frameId, long nanoTime, long nanoStep, PickRay pickRay, boolean isShadowPass, FrustumCuller frustumCuller) {
        this.cullQuadTreeAtoms(node, cullingSuppressed, view, viewPosition, frustum, binProvider, glCaps, frameId, nanoTime, nanoStep, pickRay, isShadowPass, frustumCuller);
    }

    public QuadTreeGroup(float centerX, float centerY, float centerZ, PlaneIndicator plane, float width, float depth, float height, boolean useExtendedCells) {
        this.quadTree = new QuadTree(centerX, centerY, centerZ, plane, width, depth, height, useExtendedCells);
        BoundingBox bb = new BoundingBox();
        this.setBounds((Bounds)bb);
    }

    public QuadTreeGroup(Tuple3f center, PlaneIndicator plane, float width, float depth, float height, boolean useExtendedCells) {
        this(center.getX(), center.getY(), center.getZ(), plane, width, depth, height, useExtendedCells);
    }

    public QuadTreeGroup(float centerX, float centerY, float centerZ, PlaneIndicator plane, float size, float height, boolean useExtendedCells) {
        this(centerX, centerY, centerZ, plane, size, size, height, useExtendedCells);
    }

    public QuadTreeGroup(Tuple3f center, PlaneIndicator plane, float size, float height, boolean useExtendedCells) {
        this(center.getX(), center.getY(), center.getZ(), plane, size, height, useExtendedCells);
    }

    private static final PlaneIndicator getPlane(AxisIndicator upAxis) {
        switch (upAxis) {
            case POSITIVE_Y_AXIS: {
                return PlaneIndicator.X_Z_PLANE;
            }
            case POSITIVE_Z_AXIS: {
                return PlaneIndicator.X_Y_PLANE;
            }
            case NEGATIVE_X_AXIS: {
                return PlaneIndicator.Z_Y_PLANE;
            }
        }
        throw new IllegalArgumentException("upAxis");
    }

    public QuadTreeGroup(Tuple3f center, AxisIndicator upAxis, float width, float depth, float height, boolean useExtendedCells) {
        this(center.getX(), center.getY(), center.getZ(), QuadTreeGroup.getPlane(upAxis), width, depth, height, useExtendedCells);
    }

    public QuadTreeGroup(float centerX, float centerY, float centerZ, AxisIndicator upAxis, float size, float height, boolean useExtendedCells) {
        this(centerX, centerY, centerZ, QuadTreeGroup.getPlane(upAxis), size, size, height, useExtendedCells);
    }

    public QuadTreeGroup(Tuple3f center, AxisIndicator upAxis, float size, float height, boolean useExtendedCells) {
        this(center.getX(), center.getY(), center.getZ(), QuadTreeGroup.getPlane(upAxis), size, height, useExtendedCells);
    }

    public QuadTreeGroup(float centerX, float centerY, float centerZ, float width, float depth, float height, boolean useExtendedCells) {
        this(centerX, centerY, centerZ, DEFAULT_PLANE, width, depth, height, useExtendedCells);
    }

    public QuadTreeGroup(Tuple3f center, float width, float depth, float height, boolean useExtendedCells) {
        this(center.getX(), center.getY(), center.getZ(), width, depth, height, useExtendedCells);
    }

    public QuadTreeGroup(float centerX, float centerY, float centerZ, float size, float height, boolean useExtendedCells) {
        this(centerX, centerY, centerZ, size, size, height, useExtendedCells);
    }

    public QuadTreeGroup(Tuple3f center, float size, float height, boolean useExtendedCells) {
        this(center.getX(), center.getY(), center.getZ(), size, height, useExtendedCells);
    }
}

