/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph;

import org.jagatoo.datatypes.Enableable;
import org.xith3d.render.CanvasPeer;
import org.xith3d.render.SceneGraphOpenGLReferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Shader
implements Comparable<Shader>,
Enableable {
    private final ShaderType shadertype;
    private boolean enabled;
    private boolean dirty;
    private String shaderCode;
    private final SceneGraphOpenGLReferences openGLReferences = new SceneGraphOpenGLReferences(1);

    public final SceneGraphOpenGLReferences getOpenGLReferences() {
        return this.openGLReferences;
    }

    protected void finalize() {
        this.openGLReferences.prepareObjectForDestroy();
    }

    public void freeOpenGLResources(CanvasPeer canvasPeer) {
        if (this.openGLReferences.referenceExists(canvasPeer)) {
            this.openGLReferences.prepareObjectForDestroy(canvasPeer);
        }
    }

    public final ShaderType getType() {
        return this.shadertype;
    }

    public final void setEnabled(boolean programState) {
        this.enabled = programState;
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    final void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    final boolean isDirty() {
        return this.dirty;
    }

    public final void setShaderCode(String shaderCode) {
        if (this.shaderCode != null && this.shaderCode.equals(shaderCode)) {
            return;
        }
        this.shaderCode = shaderCode;
        this.dirty = true;
    }

    public final String getShaderCode() {
        return this.shaderCode;
    }

    @Override
    public abstract int compareTo(Shader var1);

    public abstract boolean equals(Object var1);

    public Shader(ShaderType type, String shaderCode, boolean enabled) {
        this.shadertype = type;
        this.shaderCode = shaderCode;
        this.enabled = enabled;
        this.dirty = true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ShaderType {
        VERTEX,
        FRAGMENT;

    }
}

