/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph;

import java.io.IOException;
import org.openmali.spatial.VertexContainer;
import org.openmali.spatial.bounds.BoundingBox;
import org.openmali.spatial.bounds.BoundingSphere;
import org.openmali.spatial.bounds.Bounds;
import org.xith3d.effects.EffectFactory;
import org.xith3d.effects.bumpmapping.BumpMappingFactory;
import org.xith3d.effects.shadows.ShadowFactory;
import org.xith3d.render.CanvasPeer;
import org.xith3d.render.OpenGLCapabilities;
import org.xith3d.render.preprocessing.ShapeAtom;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.Leaf;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.modifications.ScenegraphModificationsListener;
import org.xith3d.scenegraph.traversal.DetailedTraversalCallback;
import org.xith3d.scenegraph.utils.CopyListener;

public class Shape3D
extends Leaf {
    private ShapeAtom atom = null;
    private Geometry geometry = null;
    private Appearance appearance = null;
    private Comparable customComparable = null;
    private boolean visible = true;
    private long appChangeID = -1L;
    private boolean bumpMappingEnabled = false;
    private boolean isShadowReceiver = false;
    private int passId = 0;

    public void setModListener(ScenegraphModificationsListener modListener) {
        super.setModListener(modListener);
        if (this.appearance != null) {
            this.appearance.setModListener(this.getModListener());
        }
        if (this.geometry != null) {
            this.geometry.setModListener(this.getModListener());
        }
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public final boolean isVisible() {
        return this.visible;
    }

    public final void setBounds(Bounds bounds) {
        if (this.getGeometry() != null) {
            this.getGeometry().setBoundsDirty();
        }
        super.setBounds(bounds);
    }

    protected void updateBoundsCheap(boolean onlyDirty, boolean childrenToo, boolean parentToo, boolean onlyWorld) {
        Geometry geom;
        if (this.isIgnoreBounds() || !this.boundsDirty && onlyDirty) {
            return;
        }
        if (this.boundsAutoCompute && !onlyWorld && (geom = this.getGeometry()) != null) {
            if (geom.isBoundsDirty() || !onlyDirty) {
                Bounds b = geom.getCachedBounds();
                Object newBounds = b == null || b.getType() != this.untransformedBounds.getType() ? (this.bounds instanceof BoundingBox ? new BoundingBox() : new BoundingSphere()) : b;
                newBounds.compute((VertexContainer)geom);
                geom.setCachedBounds((Bounds)newBounds);
            }
            this.untransformedBounds.set(geom.getCachedBounds());
            this.bounds.set(geom.getCachedBounds());
        }
        super.updateBoundsCheap(onlyDirty, childrenToo, parentToo, onlyWorld);
    }

    public void updateBounds(boolean onlyDirty) {
        this.updateBoundsCheap(onlyDirty, false, true, false);
    }

    public final void updateWorldTransform() {
        super.updateWorldTransform();
    }

    final void setPassId(int passId) {
        this.passId = passId;
    }

    final int getPassId() {
        return this.passId;
    }

    public void setGeometry(Geometry geometry) {
        boolean hasChanged;
        boolean bl = hasChanged = this.geometry != geometry;
        if (geometry == null && this.geometry != null) {
            this.geometry.setModListener(null);
        }
        this.geometry = geometry;
        if (geometry != null) {
            geometry.setModListener(this.getModListener());
        }
        if (hasChanged || geometry != null && geometry.isBoundsDirty()) {
            this.setBoundsDirty();
            this.updateBounds(true);
        }
    }

    public Geometry getGeometry() {
        return this.geometry;
    }

    public final void setAppearance(Appearance appearance) {
        if (appearance == this.appearance) {
            return;
        }
        if (appearance == null && this.appearance != null) {
            this.appearance.setModListener(null);
        }
        this.appearance = appearance;
        if (appearance != null) {
            this.appearance.setChangedRecursive(true);
        }
        if (appearance != null) {
            appearance.setModListener(this.getModListener());
        }
    }

    public final Appearance getAppearance() {
        return this.appearance;
    }

    public Appearance getAppearance(boolean forceExistance) {
        if (this.getAppearance() == null && forceExistance) {
            this.setAppearance(new Appearance());
        }
        return this.getAppearance();
    }

    public Appearance newAppearance() {
        this.setAppearance(new Appearance());
        return this.getAppearance();
    }

    public final boolean verifyAppChange(OpenGLCapabilities glCaps) {
        if (this.appearance != null) {
            long change_id = this.appearance.verifyChange(this, glCaps);
            if (change_id != this.appChangeID) {
                this.appChangeID = change_id;
                return true;
            }
        } else if (this.appChangeID != -1L) {
            this.appChangeID = -1L;
            return true;
        }
        return false;
    }

    public void setCustomComparable(Comparable customComparable) {
        this.customComparable = customComparable;
    }

    public final Comparable getCustomComparable() {
        return this.customComparable;
    }

    public final void setBumpMappingEnabled(boolean enabled, Texture normalMapTex) {
        this.bumpMappingEnabled = enabled;
        if (enabled && (this.getGeometry() == null || this.getAppearance() == null)) {
            System.err.println("Warning: BumpMapping will fail, if this Shape doesn't have a Geometry AND an Appearance.");
        } else if (enabled && this.getGeometry() != null && this.getAppearance() != null) {
            BumpMappingFactory bumpFactory = EffectFactory.getInstance().getBumpMappingFactory();
            if (bumpFactory != null) {
                try {
                    bumpFactory.prepareForBumpMapping(this, normalMapTex);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                System.err.println("ERROR: Cannot apply BumpMapping, while no BumpMappingFactory is registered at the EffectFactory!");
            }
        }
    }

    public final void setBumpMappingEnabled(boolean enabled, String normalMapTex) {
        BumpMappingFactory bumpFactory = EffectFactory.getInstance().getBumpMappingFactory();
        if (bumpFactory != null) {
            this.setBumpMappingEnabled(enabled, BumpMappingFactory.loadNormalMap(normalMapTex));
        } else {
            System.err.println("ERROR: Cannot apply BumpMapping, while no BumpMappingFactory is registered at the EffectFactory!");
        }
    }

    public final boolean isBumpMappingEnabled() {
        return this.bumpMappingEnabled;
    }

    public final void setIsShadowReceiver(boolean isSR) {
        ShadowFactory shadowFact;
        EffectFactory effFact;
        boolean changed = this.isShadowReceiver != isSR;
        this.isShadowReceiver = isSR;
        if (changed && (effFact = EffectFactory.getInstance()) != null && (shadowFact = effFact.getShadowFactory()) != null) {
            shadowFact.onShadowReceiverStateChanged(this, this.isShadowReceiver);
        }
    }

    public final boolean isShadowReceiver() {
        return this.isShadowReceiver;
    }

    final void setAtom(ShapeAtom atom) {
        this.atom = atom;
    }

    final ShapeAtom getAtom() {
        return this.atom;
    }

    protected void copy(Shape3D dest) {
        dest.setGeometry(this.getGeometry());
        dest.setAppearance(this.getAppearance());
        dest.setBoundsAutoCompute(false);
        dest.setBounds(this.getBounds());
        dest.boundsDirty = true;
        dest.updateBounds(false);
        dest.setPickable(this.isPickable());
        dest.setRenderable(this.isRenderable());
        dest.setName(this.getName());
    }

    protected Shape3D newInstance() {
        boolean gib = Node.globalIgnoreBounds;
        Node.globalIgnoreBounds = this.isIgnoreBounds();
        Shape3D newShape = new Shape3D();
        Node.globalIgnoreBounds = gib;
        return newShape;
    }

    public Shape3D sharedCopy(CopyListener listener) {
        Shape3D newShape = this.newInstance();
        this.copy(newShape);
        if (listener != null) {
            listener.onNodeCopied(this, newShape, true);
        }
        return newShape;
    }

    public Shape3D sharedCopy() {
        return (Shape3D)super.sharedCopy();
    }

    public void absorbDetails(Node node) {
        ((Shape3D)node).copy(this);
    }

    public void freeOpenGLResources(CanvasPeer canvasPeer) {
        if (this.getAppearance() != null) {
            this.getAppearance().freeOpenGLResources(canvasPeer);
        }
        if (this.getGeometry() != null) {
            this.getGeometry().freeOpenGLResources(canvasPeer);
        }
    }

    public boolean traverse(DetailedTraversalCallback callback) {
        return callback.traversalOperationCommon(this) && callback.traversalOperation(this) && callback.traversalOperationAfter(this) && callback.traversalOperationCommonAfter(this);
    }

    public Shape3D() {
        this(null, null);
    }

    public Shape3D(Geometry geometry) {
        this(geometry, null);
    }

    public Shape3D(Geometry geometry, Appearance appearance) {
        this.setGeometry(geometry);
        this.setAppearance(appearance);
    }
}

