/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph;

import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.Map;
import org.jagatoo.util.arrays.ArrayUtils;
import org.openmali.types.twodee.Rect2i;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Tuple2i;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.TextureImage2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Texture2DCanvas
extends Graphics2D {
    private final Texture2D texture;
    private final TextureImage2D texImg;
    private int imgWidth;
    private int imgHeight;
    private Graphics2D graphics;
    private final AffineTransform baseAffineTransform;
    private Rect2i currentUpdateRect = null;
    private int currentlyAppliedUpdateRects = 0;
    private DrawCallback2D[] callbacks = new DrawCallback2D[0];
    private int numCallbacks = 0;

    public final Texture2D getTexture() {
        return this.texture;
    }

    public final TextureImage2D getImage() {
        return this.texImg;
    }

    public void addDrawCallback(DrawCallback2D callback) {
        this.callbacks = (DrawCallback2D[])ArrayUtils.ensureCapacity((Object[])this.callbacks, DrawCallback2D.class, (int)(this.callbacks.length + 1));
        this.callbacks[this.numCallbacks++] = callback;
    }

    public void removeDrawCallback(DrawCallback2D callback) {
        int index = ArrayUtils.indexOf((Object[])this.callbacks, (Object)callback, (boolean)false);
        this.callbacks[index] = null;
        System.arraycopy(this.callbacks, index + 1, this.callbacks, index, this.numCallbacks - index - 1);
        --this.numCallbacks;
    }

    final boolean notifyDrawCallbacks(long nanoTime) {
        if (this.numCallbacks == 0) {
            return false;
        }
        for (int i = 0; i < this.numCallbacks; ++i) {
            DrawCallback2D callback = this.callbacks[i];
            if (!callback.needsRedraw(nanoTime)) continue;
            callback.drawTexture(this, this.imgWidth, this.imgHeight);
        }
        return this.texture.hasUpdateList();
    }

    private final void markDirty(int x, int y, int width, int height) {
        if (this.currentUpdateRect != null && x >= this.currentUpdateRect.getLeft() && y >= this.currentUpdateRect.getTop() && x + width <= this.currentUpdateRect.getLeft() + this.currentUpdateRect.getWidth() && y + height <= this.currentUpdateRect.getTop() + this.currentUpdateRect.getHeight()) {
            return;
        }
        Rect2i clip = this.getImage().getEffectiveClipRect();
        int clipX = clip.getLeft();
        int clipY = clip.getTop();
        int clipW = clip.getWidth();
        int clipH = clip.getHeight();
        x = Math.max(clipX, x);
        y = Math.max(clipY, y);
        x = Math.min(x, clipX + clipW - 1);
        y = Math.min(y, clipY + clipH - 1);
        width = Math.min(width, clipX + clipW - x);
        height = Math.min(height, clipY + clipH - y);
        if (width > 0 && height > 0) {
            if (this.texImg != null) {
                this.texImg.update(x, this.imgHeight - height - y, width, height);
            }
            if (this.texture != null) {
                this.texture.setHasUpdateList(true);
            }
        }
    }

    private final void markDirty() {
        this.markDirty(0, 0, this.imgWidth, this.imgHeight);
    }

    public final void beginUpdateRegion(int x, int y, int width, int height) {
        if (this.currentUpdateRect != null) {
            this.currentUpdateRect.combine(x, y, width, height);
        } else {
            this.currentUpdateRect = Rect2i.fromPool((int)x, (int)y, (int)width, (int)height);
        }
        ++this.currentlyAppliedUpdateRects;
    }

    public final void beginUpdateRegionComplete() {
        this.beginUpdateRegion(0, 0, this.imgWidth, this.imgHeight);
    }

    public final void finishUpdateRegion() {
        if (this.currentUpdateRect == null) {
            return;
        }
        --this.currentlyAppliedUpdateRects;
        if (this.currentlyAppliedUpdateRects == 0) {
            int l = this.currentUpdateRect.getLeft();
            int t = this.currentUpdateRect.getTop();
            int w = this.currentUpdateRect.getWidth();
            int h = this.currentUpdateRect.getHeight();
            Rect2i.toPool((Rect2i)this.currentUpdateRect);
            this.currentUpdateRect = null;
            this.markDirty(l, t, w, h);
        }
    }

    public final AffineTransform getBaseAffineTransform() {
        return this.baseAffineTransform;
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return this.graphics.getDeviceConfiguration();
    }

    @Override
    public final void clearRect(int x, int y, int width, int height) {
        this.graphics.clearRect(x, y, width, height);
        this.markDirty(x, y, width, height);
    }

    public final void clearRect(Rect2i rect) {
        this.clearRect(rect.getLeft(), rect.getTop(), rect.getWidth(), rect.getHeight());
    }

    @Override
    public void clipRect(int x, int y, int width, int height) {
        this.graphics.clipRect(x, y, width, height);
    }

    public final void clip(Rect2i rect) {
        this.clipRect(rect.getLeft(), rect.getTop(), rect.getWidth(), rect.getHeight());
    }

    @Override
    public final void clip(Shape shape) {
        this.graphics.clip(shape);
    }

    @Override
    public final void copyArea(int x, int y, int width, int height, int dx, int dy) {
        this.graphics.copyArea(x, y, width, height, dx, dy);
        this.markDirty(dx, dy, width, height);
    }

    public final void copyArea(Rect2i rect, int dx, int dy) {
        this.copyArea(rect.getLeft(), rect.getTop(), rect.getWidth(), rect.getHeight(), dx, dy);
    }

    @Override
    public final void draw(Shape shape) {
        this.graphics.draw(shape);
        Rectangle rect = shape.getBounds();
        this.markDirty(rect.x, rect.y, rect.width, rect.height);
    }

    @Override
    public final void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.graphics.drawArc(x, y, width, height, startAngle, arcAngle);
        this.markDirty(x, y, width, height);
    }

    public final void drawCircle(int x, int y, int radius) {
        this.drawArc(x - radius, y - radius, radius + radius, radius + radius, 0, 360);
    }

    @Override
    public final void drawBytes(byte[] data, int offset, int length, int x, int y) {
        this.graphics.drawBytes(data, offset, length, x, y);
        this.markDirty(x, y, this.imgWidth - x, this.imgHeight - y);
    }

    @Override
    public final void drawChars(char[] data, int offset, int length, int x, int y) {
        this.graphics.drawChars(data, offset, length, x, y);
        this.markDirty(x, y, this.imgWidth - x, this.imgHeight - y);
    }

    @Override
    public final void drawGlyphVector(GlyphVector g, float x, float y) {
        this.graphics.drawGlyphVector(g, x, y);
        this.markDirty((int)x, (int)y, this.imgWidth - (int)x, this.imgHeight - (int)y);
    }

    @Override
    public final boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver imgOb) {
        boolean result = this.graphics.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, imgOb);
        this.markDirty(dx1, dy1, dx2 - dx1 + 1, dy2 - dy1 + 1);
        return result;
    }

    public final void drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2) {
        this.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, (ImageObserver)null);
    }

    @Override
    public final boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgColor, ImageObserver imgOb) {
        boolean result = this.graphics.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, bgColor, imgOb);
        this.markDirty(dx1, dy1, dx2 - dx1 + 1, dy2 - dy1 + 1);
        return result;
    }

    public final void drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Colorf bgColor) {
        this.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, bgColor.getAWTColor(), null);
    }

    @Override
    public final boolean drawImage(Image img, AffineTransform xform, ImageObserver imgOb) {
        boolean result = this.graphics.drawImage(img, xform, imgOb);
        this.markDirty();
        return result;
    }

    @Override
    public final void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
        this.graphics.drawImage(img, op, x, y);
        this.markDirty(x, y, img.getWidth() - x, img.getHeight() - y);
    }

    @Override
    public final boolean drawImage(Image img, int x, int y, ImageObserver imgOb) {
        boolean result = this.graphics.drawImage(img, x, y, imgOb);
        this.markDirty(x, y, img.getWidth(null) - x, img.getHeight(null) - y);
        return result;
    }

    public final void drawImage(Image img, int x, int y) {
        this.drawImage(img, x, y, (ImageObserver)null);
    }

    @Override
    public final boolean drawImage(Image img, int x, int y, Color bgColor, ImageObserver imgOb) {
        boolean result = this.graphics.drawImage(img, x, y, bgColor, imgOb);
        this.markDirty(x, y, img.getWidth(null) - x, img.getHeight(null) - y);
        return result;
    }

    public final void drawImage(Image img, int x, int y, Colorf bgColor) {
        this.drawImage(img, x, y, bgColor.getAWTColor(), null);
    }

    @Override
    public final boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver imgOb) {
        boolean result = this.graphics.drawImage(img, x, y, width, height, null);
        this.markDirty(x, y, width, height);
        return result;
    }

    public final void drawImage(Image img, int x, int y, int width, int height) {
        this.drawImage(img, x, y, width, height, (ImageObserver)null);
    }

    @Override
    public final boolean drawImage(Image img, int x, int y, int width, int height, Color bgColor, ImageObserver imgOb) {
        boolean result = this.graphics.drawImage(img, x, y, width, height, bgColor, imgOb);
        this.markDirty(x, y, width, height);
        return result;
    }

    public final void drawImage(Image img, int x, int y, int width, int height, Colorf bgColor) {
        this.drawImage(img, x, y, width, height, bgColor.getAWTColor(), null);
    }

    @Override
    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        this.graphics.drawRenderableImage(img, xform);
        this.markDirty();
    }

    @Override
    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        this.graphics.drawRenderedImage(img, xform);
        this.markDirty();
    }

    @Override
    public final void drawLine(int x1, int y1, int x2, int y2) {
        this.graphics.drawLine(x1, y1, x2, y2);
        this.markDirty(x1, y1, x2 - x1, y2 - y1);
    }

    public final void drawLineOffset(int x, int y, int dx, int dy) {
        this.drawLine(x, y, x + dx, y + dy);
    }

    @Override
    public final void drawOval(int x, int y, int width, int height) {
        this.graphics.drawOval(x, y, width, height);
        this.markDirty(x, y, width, height);
    }

    @Override
    public final void drawPolygon(Polygon polygon) {
        this.graphics.drawPolygon(polygon);
        Rectangle rect = polygon.getBounds();
        this.markDirty(rect.x, rect.y, rect.width, rect.height);
    }

    @Override
    public final void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        int i;
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        for (i = 0; i < nPoints; ++i) {
            if (xPoints[i] < minX) {
                minX = xPoints[i];
            }
            if (xPoints[i] <= maxX) continue;
            maxX = xPoints[i];
        }
        for (i = 0; i < nPoints; ++i) {
            if (yPoints[i] < minY) {
                minY = yPoints[i];
            }
            if (yPoints[i] <= maxY) continue;
            maxY = yPoints[i];
        }
        int width = maxX - minX + 1;
        int height = maxY - minY + 1;
        if (width > 0 && height > 0) {
            this.graphics.drawPolygon(xPoints, yPoints, nPoints);
            this.markDirty(minX, minY, width, height);
        }
    }

    @Override
    public final void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        int i;
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        for (i = 0; i < nPoints; ++i) {
            if (xPoints[i] < minX) {
                minX = xPoints[i];
            }
            if (xPoints[i] <= maxX) continue;
            maxX = xPoints[i];
        }
        for (i = 0; i < nPoints; ++i) {
            if (yPoints[i] < minY) {
                minY = yPoints[i];
            }
            if (yPoints[i] <= maxY) continue;
            maxY = yPoints[i];
        }
        int width = maxX - minX + 1;
        int height = maxY - minY + 1;
        if (width > 0 && height > 0) {
            this.graphics.drawPolyline(xPoints, yPoints, nPoints);
            this.markDirty(minX, minY, width, height);
        }
    }

    public final void drawPolygon(Tuple2i[] points) {
        int nPoints = points.length;
        if (nPoints == 0) {
            return;
        }
        int[] xPoints = new int[nPoints];
        int[] yPoints = new int[nPoints];
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        for (int i = 0; i < nPoints; ++i) {
            xPoints[i] = points[i].getX();
            yPoints[i] = points[i].getY();
            if (xPoints[i] < minX) {
                minX = xPoints[i];
            }
            if (xPoints[i] > maxX) {
                maxX = xPoints[i];
            }
            if (yPoints[i] < minY) {
                minY = yPoints[i];
            }
            if (yPoints[i] <= maxY) continue;
            maxY = yPoints[i];
        }
        int width = maxX - minX + 1;
        int height = maxY - minY + 1;
        if (width > 0 && height > 0) {
            this.graphics.drawPolygon(xPoints, yPoints, nPoints);
            this.markDirty(minX, minY, width, height);
        }
    }

    public final void drawPolyline(Tuple2i[] points) {
        int nPoints = points.length;
        if (nPoints == 0) {
            return;
        }
        int[] xPoints = new int[nPoints];
        int[] yPoints = new int[nPoints];
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        for (int i = 0; i < nPoints; ++i) {
            xPoints[i] = points[i].getX();
            yPoints[i] = points[i].getY();
            if (xPoints[i] < minX) {
                minX = xPoints[i];
            }
            if (xPoints[i] > maxX) {
                maxX = xPoints[i];
            }
            if (yPoints[i] < minY) {
                minY = yPoints[i];
            }
            if (yPoints[i] <= maxY) continue;
            maxY = yPoints[i];
        }
        int width = maxX - minX + 1;
        int height = maxY - minY + 1;
        if (width > 0 && height > 0) {
            this.graphics.drawPolyline(xPoints, yPoints, nPoints);
            this.markDirty(minX, minY, width, height);
        }
    }

    @Override
    public final void drawRect(int x, int y, int width, int height) {
        this.graphics.drawRect(x, y, width, height);
        this.markDirty(x, y, width, height);
    }

    public final void drawRect(Rect2i rect) {
        this.drawRect(rect.getLeft(), rect.getTop(), rect.getWidth(), rect.getHeight());
    }

    @Override
    public final void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.graphics.drawRoundRect(x, y, width, height, arcWidth, arcHeight);
        this.markDirty(x, y, width, height);
    }

    public final void drawRoundRect(Rect2i rect, int arcWidth, int arcHeight) {
        this.drawRoundRect(rect.getLeft(), rect.getTop(), rect.getWidth(), rect.getHeight(), arcWidth, arcHeight);
    }

    @Override
    public final void drawString(AttributedCharacterIterator iterator, float x, float y) {
        this.graphics.drawString(iterator, x, y);
        this.markDirty((int)x, (int)y, this.imgWidth - (int)x, this.imgHeight - (int)y);
    }

    @Override
    public final void drawString(AttributedCharacterIterator iterator, int x, int y) {
        this.graphics.drawString(iterator, x, y);
        this.markDirty(x, y, this.imgWidth - x, this.imgHeight - y);
    }

    @Override
    public final void drawString(String s, float x, float y) {
        this.graphics.drawString(s, x, y);
        this.markDirty((int)x, (int)y, this.imgWidth - (int)x, this.imgHeight - (int)y);
    }

    @Override
    public final void drawString(String s, int x, int y) {
        this.graphics.drawString(s, x, y);
        this.markDirty(x, y, this.imgWidth - x, this.imgHeight - y);
    }

    public final void drawString(String s, int x, int y, int boundsWidth, int boundsHeight) {
        this.graphics.drawString(s, x, y);
        this.markDirty(x, y - boundsHeight, boundsWidth, boundsHeight);
    }

    @Override
    public final void fill(Shape shape) {
        this.graphics.fill(shape);
        Rectangle rect = shape.getBounds();
        this.markDirty(rect.x, rect.y, rect.width, rect.height);
    }

    @Override
    public final void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.graphics.fillArc(x, y, width, height, startAngle, arcAngle);
        this.markDirty(x, y, width, height);
    }

    public final void fillCircle(int x, int y, int radius) {
        this.fillArc(x - radius, y - radius, radius + radius, radius + radius, 0, 360);
    }

    @Override
    public final void fillOval(int x, int y, int width, int height) {
        this.graphics.fillOval(x, y, width, height);
        this.markDirty(x, y, width, height);
    }

    @Override
    public final void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        int i;
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        for (i = 0; i < nPoints; ++i) {
            if (xPoints[i] < minX) {
                minX = xPoints[i];
            }
            if (xPoints[i] <= maxX) continue;
            maxX = xPoints[i];
        }
        for (i = 0; i < nPoints; ++i) {
            if (yPoints[i] < minY) {
                minY = yPoints[i];
            }
            if (yPoints[i] <= maxY) continue;
            maxY = yPoints[i];
        }
        int width = maxX - minX + 1;
        int height = maxY - minY + 1;
        if (width > 0 && height > 0) {
            this.graphics.fillPolygon(xPoints, yPoints, nPoints);
            this.markDirty(minX, minY, width, height);
        }
    }

    public final void fillPolygon(Tuple2i[] points) {
        int nPoints = points.length;
        if (nPoints == 0) {
            return;
        }
        int[] xPoints = new int[nPoints];
        int[] yPoints = new int[nPoints];
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        for (int i = 0; i < nPoints; ++i) {
            xPoints[i] = points[i].getX();
            yPoints[i] = points[i].getY();
            if (xPoints[i] < minX) {
                minX = xPoints[i];
            }
            if (xPoints[i] > maxX) {
                maxX = xPoints[i];
            }
            if (yPoints[i] < minY) {
                minY = yPoints[i];
            }
            if (yPoints[i] <= maxY) continue;
            maxY = yPoints[i];
        }
        int width = maxX - minX + 1;
        int height = maxY - minY + 1;
        if (width > 0 && height > 0) {
            this.graphics.fillPolygon(xPoints, yPoints, nPoints);
            this.markDirty(minX, minY, width, height);
        }
    }

    @Override
    public final void fillRect(int x, int y, int width, int height) {
        this.graphics.fillRect(x, y, width, height);
        this.markDirty(x + 1, y + 1, width - 2, height - 2);
    }

    public final void fillRect(Rect2i rect) {
        this.fillRect(rect.getLeft(), rect.getTop(), rect.getWidth(), rect.getHeight());
    }

    @Override
    public final void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.graphics.fillRoundRect(x, y, width, height, arcWidth, arcHeight);
        this.markDirty(x, y, width, height);
    }

    public final void fillRoundRect(Rect2i rect, int arcWidth, int arcHeight) {
        this.fillRoundRect(rect.getLeft(), rect.getTop(), rect.getWidth(), rect.getHeight(), arcWidth, arcHeight);
    }

    @Override
    public Color getBackground() {
        return this.graphics.getBackground();
    }

    public final Colorf getBackgroundColor() {
        return new Colorf(this.graphics.getBackground());
    }

    @Override
    public final Shape getClip() {
        return this.graphics.getClip();
    }

    public final Rect2i getClipRect2i() {
        Rectangle awtRect = this.graphics.getClipBounds();
        return new Rect2i(awtRect.x, awtRect.y, awtRect.width, awtRect.height);
    }

    @Override
    public final Rectangle getClipBounds() {
        return this.graphics.getClipBounds();
    }

    public final Rect2i getClipBounds(Rect2i rect) {
        Rectangle awtRect = new Rectangle(rect.getLeft(), rect.getTop(), rect.getWidth(), rect.getHeight());
        this.graphics.getClipBounds(awtRect);
        return rect;
    }

    @Override
    public final Color getColor() {
        return this.graphics.getColor();
    }

    public final Colorf getColorf() {
        return new Colorf(this.graphics.getColor());
    }

    @Override
    public final Font getFont() {
        return this.graphics.getFont();
    }

    @Override
    public final FontMetrics getFontMetrics() {
        return this.graphics.getFontMetrics();
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        return this.graphics.getFontMetrics(font);
    }

    @Override
    public final FontRenderContext getFontRenderContext() {
        return this.graphics.getFontRenderContext();
    }

    @Override
    public final Paint getPaint() {
        return this.graphics.getPaint();
    }

    @Override
    public final Object getRenderingHint(RenderingHints.Key hintKey) {
        return this.graphics.getRenderingHint(hintKey);
    }

    @Override
    public final RenderingHints getRenderingHints() {
        return this.graphics.getRenderingHints();
    }

    @Override
    public final Stroke getStroke() {
        return this.graphics.getStroke();
    }

    @Override
    public final AffineTransform getTransform() {
        return this.graphics.getTransform();
    }

    @Override
    public final boolean hitClip(int x, int y, int width, int height) {
        return this.graphics.hitClip(x, y, width, height);
    }

    @Override
    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        return this.graphics.hit(rect, s, onStroke);
    }

    @Override
    public final void rotate(double theta) {
        this.graphics.rotate(theta);
    }

    @Override
    public final void rotate(double theta, double x, double y) {
        this.graphics.rotate(theta, x, y);
    }

    @Override
    public final void scale(double sx, double sy) {
        this.graphics.scale(sx, sy);
    }

    public final void setBackgroundColor(Colorf color) {
        this.graphics.setBackground(color.getAWTColor());
    }

    @Override
    public final void setBackground(Color color) {
        this.graphics.setBackground(color);
    }

    @Override
    public final void setClip(Shape clip) {
        this.graphics.setClip(clip);
    }

    @Override
    public final void setClip(int x, int y, int width, int height) {
        this.graphics.setClip(x, y, width, height);
        this.getImage().setClipRect(x, y, width, height);
    }

    public final void setClip(Rect2i rect) {
        if (rect == null) {
            this.setClip(0, 0, this.getImage().getWidth(), this.getImage().getHeight());
        } else {
            this.setClip(rect.getLeft(), rect.getTop(), rect.getWidth(), rect.getHeight());
        }
    }

    public final <Rect2i_ extends Rect2i> Rect2i_ getClip(Rect2i_ rect) {
        return this.getImage().getClipRect(rect);
    }

    @Override
    public void setColor(Color color) {
        this.graphics.setColor(color);
    }

    public final void setColor(Colorf color) {
        this.graphics.setColor(color.getAWTColor());
    }

    @Override
    public final void setFont(Font font) {
        this.graphics.setFont(font);
    }

    @Override
    public final void setPaint(Paint paint) {
        this.graphics.setPaint(paint);
    }

    @Override
    public final void setPaintMode() {
        this.graphics.setPaintMode();
    }

    @Override
    public final void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        this.graphics.setRenderingHint(hintKey, hintValue);
    }

    public final void setRenderingHints(RenderingHints hints) {
        this.graphics.setRenderingHints(hints);
    }

    @Override
    public void setRenderingHints(Map<?, ?> hints) {
        this.graphics.setRenderingHints(hints);
    }

    @Override
    public void addRenderingHints(Map<?, ?> hints) {
        this.graphics.addRenderingHints(hints);
    }

    public final void setAntialiazingEnabled(boolean enabled) {
        Object value = enabled ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF;
        this.graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, value);
    }

    public final boolean isAntialiazingEnabled() {
        Object value = this.graphics.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        return value == RenderingHints.VALUE_ANTIALIAS_ON;
    }

    @Override
    public final void setStroke(Stroke stroke) {
        this.graphics.setStroke(stroke);
    }

    @Override
    public final void setTransform(AffineTransform Tx) {
        this.graphics.setTransform(Tx);
    }

    @Override
    public final void setXORMode(Color color) {
        this.graphics.setXORMode(color);
    }

    @Override
    public final void shear(double shx, double shy) {
        this.graphics.shear(shx, shy);
    }

    @Override
    public final void transform(AffineTransform Tx) {
        this.graphics.transform(Tx);
    }

    @Override
    public final void translate(double tx, double ty) {
        this.graphics.translate(tx, ty);
    }

    @Override
    public final void translate(int tx, int ty) {
        this.graphics.translate(tx, ty);
    }

    protected void updateAffineTransform() {
        this.baseAffineTransform.setToIdentity();
        if (!this.texImg.getYUp()) {
            this.baseAffineTransform.concatenate(new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f));
            this.baseAffineTransform.concatenate(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, -this.imgHeight));
        }
        this.graphics.setTransform(this.baseAffineTransform);
    }

    public final void notifyImagesizeChanged(int imgWidth, int imgHeight, Graphics2D graphics) {
        this.imgWidth = imgWidth;
        this.imgHeight = imgHeight;
        if (graphics != null && graphics != this.graphics) {
            graphics.setBackground(this.graphics.getBackground());
            graphics.setClip(this.graphics.getClip());
            graphics.setColor(this.graphics.getColor());
            graphics.setComposite(this.graphics.getComposite());
            graphics.setFont(this.graphics.getFont());
            graphics.setPaint(this.graphics.getPaint());
            graphics.setRenderingHints(this.graphics.getRenderingHints());
            graphics.setStroke(this.graphics.getStroke());
            this.graphics = graphics;
        }
        this.updateAffineTransform();
    }

    @Override
    public void setComposite(Composite comp) {
        this.graphics.setComposite(comp);
    }

    @Override
    public Composite getComposite() {
        return this.graphics.getComposite();
    }

    @Override
    public Graphics create() {
        throw new Error("create() is not supported for this kind of Graphics2D.");
    }

    @Override
    public void dispose() {
        this.graphics.dispose();
    }

    public Texture2DCanvas(Texture2D texture, TextureImage2D ti, int imgWidth, int imgHeight, Graphics2D graphics) {
        if (graphics == null) {
            throw new IllegalArgumentException("graphics must not be null.");
        }
        this.texture = texture;
        this.texImg = ti;
        this.imgWidth = imgWidth;
        this.imgHeight = imgHeight;
        this.graphics = graphics;
        this.baseAffineTransform = new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        this.updateAffineTransform();
    }

    public Texture2DCanvas(Texture2D texture, TextureImage2D ti, int imgWidth, int imgHeight) {
        this(texture, ti, imgWidth, imgHeight, ti.createGraphics2D());
    }

    public Texture2DCanvas(int imgWidth, int imgHeight, Graphics2D graphics) {
        this(null, null, imgWidth, imgHeight, graphics);
    }

    public static abstract class DrawCallback2D {
        private boolean dirty = true;

        public void setDirty(boolean dirty) {
            this.dirty = dirty;
        }

        public boolean needsRedraw(long nanoTime) {
            boolean result = this.dirty;
            this.dirty = false;
            return result;
        }

        public abstract void drawTexture(Texture2DCanvas var1, int var2, int var3);
    }
}

