/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph;

import org.jagatoo.opengl.enums.TextureBoundaryMode;
import org.jagatoo.opengl.enums.TextureFormat;
import org.jagatoo.opengl.enums.TextureType;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.scenegraph.NodeComponent;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.TextureImage;
import org.xith3d.utility.texturing.CubeTextureSet;

public class TextureCubeMap
extends Texture {
    public static final int POSITIVE_X = 0;
    public static final int NEGATIVE_X = 1;
    public static final int POSITIVE_Y = 2;
    public static final int NEGATIVE_Y = 3;
    public static final int POSITIVE_Z = 4;
    public static final int NEGATIVE_Z = 5;
    private TextureImage[][] images = new TextureImage[6][1];

    protected void checkImageType(TextureImage image) {
    }

    public void setImage(int level, int face, TextureImage image) {
        if (face == 0) {
            super.setImage(level, image);
        }
        if (this.images[face] == null) {
            this.images[face] = new TextureImage[level + 1];
            this.images[face][level] = image;
        } else if (this.images[face].length - 1 >= level) {
            this.images[face][level] = image;
        } else {
            TextureImage[] temp = new TextureImage[level + 1];
            for (int loop = 0; loop < this.images[face].length; ++loop) {
                temp[loop] = this.images[face][loop];
            }
            temp[level] = image;
            this.images[face] = temp;
        }
        this.setDirty(true);
    }

    public void setImage(int level, int face, String textureName) {
        Texture2D tex = TextureLoader.getInstance().getTexture(textureName, this.getFormat(), Texture.MipmapMode.BASE_LEVEL);
        this.setImage(level, face, tex.getImage(level));
    }

    public void setImages(int face, TextureImage[] images) {
        if (face == 0) {
            for (int i = 0; i < images.length; ++i) {
                super.setImage(i, images[i]);
            }
        }
        this.images[face] = images;
    }

    public void setImages(int face, String[] images) {
        for (int i = 0; i < images.length; ++i) {
            this.setImage(face, i, images[i]);
        }
    }

    public TextureImage getImage(int mipmap, int face) {
        return this.images[face][mipmap];
    }

    protected void duplicateNodeComponent(NodeComponent original, boolean forceDuplicate) {
        super.duplicateNodeComponent(original, forceDuplicate);
        assert (original instanceof TextureCubeMap);
        TextureCubeMap tcmOrig = (TextureCubeMap)original;
        for (int i = 0; i < this.images.length; ++i) {
            for (int j = 0; j < this.images[i].length; ++j) {
                this.setImages(i, tcmOrig.images[i]);
            }
        }
    }

    public TextureCubeMap cloneNodeComponent(boolean forceDuplicate) {
        TextureCubeMap tcm = new TextureCubeMap(this.getFormat());
        tcm.duplicateNodeComponent(this, forceDuplicate);
        return tcm;
    }

    private TextureCubeMap(TextureFormat format) {
        super(TextureType.TEXTURE_CUBE_MAP, format);
    }

    public TextureCubeMap(TextureFormat format, int face, String[] textureNames) {
        super(TextureType.TEXTURE_CUBE_MAP, format);
        this.setImages(face, textureNames);
    }

    public TextureCubeMap(TextureFormat format, int face, CubeTextureSet textureSet) {
        super(TextureType.TEXTURE_CUBE_MAP, format);
        this.setImage(face, 0, textureSet.getRight());
        this.setImage(face, 1, textureSet.getLeft());
        this.setImage(face, 2, textureSet.getTop());
        this.setImage(face, 3, textureSet.getBottom());
        this.setImage(face, 4, textureSet.getFront());
        this.setImage(face, 5, textureSet.getBack());
        this.setBoundaryModeS(TextureBoundaryMode.CLAMP_TO_EDGE);
        this.setBoundaryModeT(TextureBoundaryMode.CLAMP_TO_EDGE);
    }
}

