/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph;

import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import org.jagatoo.loaders.textures.pixelprocessing.PixelProcessor;
import org.jagatoo.opengl.enums.TextureImageFormat;
import org.xith3d.scenegraph.NodeComponent;
import org.xith3d.scenegraph.TextureImage;
import org.xith3d.scenegraph.TextureImage2D;

public class TextureImage3D
extends TextureImage {
    private final int depth;
    private ByteBuffer dataBuffer = null;

    public final int getDepth() {
        return this.depth;
    }

    public final ByteBuffer getDataBuffer() {
        return this.dataBuffer;
    }

    public final int getPixelSize() {
        return this.getDataBuffer().limit() / (this.getWidth() * this.getHeight() * this.getDepth());
    }

    public int initImageData() {
        int imageSize = this.calculateNeededImageSize();
        if (this.dataBuffer == null) {
            this.dataBuffer = ByteBuffer.allocateDirect(imageSize * this.depth);
        }
        return imageSize;
    }

    public final void setImageData(byte[][] data) {
        int imageSize = this.initImageData();
        for (int loop = 0; loop < data.length; ++loop) {
            this.dataBuffer.put(data[loop], 0, imageSize);
        }
        this.dataBuffer.flip();
    }

    public void setImageData(BufferedImage[] images) {
        this.initImageData();
        PixelProcessor pp = PixelProcessor.selectPixelProcessor((TextureImageFormat)this.getFormat());
        int dataOffset = 0;
        for (int i = 0; i < images.length; ++i) {
            dataOffset += pp.readImageData(images[i], 0, 0, this.getWidth(), this.getHeight(), this.dataBuffer, dataOffset, false);
        }
    }

    public void setImageData(TextureImage2D[] images) {
        this.initImageData();
        byte[] bytes = null;
        for (int i = 0; i < images.length; ++i) {
            ByteBuffer srcBuffer = images[i].getDataBuffer();
            if (srcBuffer == null) {
                if (bytes == null) {
                    bytes = new byte[images[i].getDataSize()];
                }
                images[i].getData(bytes);
                this.dataBuffer.put(bytes);
                continue;
            }
            int pos = srcBuffer.position();
            srcBuffer.position(0);
            this.dataBuffer.put(images[i].getDataBuffer());
            srcBuffer.position(pos);
        }
        this.dataBuffer.flip();
    }

    protected void duplicateNodeComponent(NodeComponent original, boolean forceDuplicate) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public TextureImage3D cloneNodeComponent(boolean forceDuplicate) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public TextureImage3D(TextureImageFormat format, int width, int height, int depth) {
        super(format, width, height, width, height);
        this.depth = depth;
    }

    public TextureImage3D(TextureImageFormat format, int width, int height, int depth, byte[][] data) {
        this(format, width, height, depth);
        this.setImageData(data);
    }

    public TextureImage3D(TextureImageFormat format, int width, int height, int depth, BufferedImage[] image) {
        this(format, width, height, depth);
        this.setImageData(image);
    }

    public TextureImage3D(TextureImageFormat format, int width, int height, int depth, TextureImage2D[] image) {
        this(format, width, height, depth);
        this.setImageData(image);
    }
}

