/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph;

import org.openmali.vecmath2.Matrix4f;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple3f;
import org.xith3d.scenegraph.Group;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.Transformable;
import org.xith3d.scenegraph.traversal.DetailedTraversalCallback;

public class TransformGroup
extends Group
implements Transformable {
    private final Transform3D worldTransform = new Transform3D();
    private final Transform3D transform = new Transform3D();
    private final Point3f position = new Point3f();

    protected final void onTransformChanged() {
        if (this.getModListener() != null) {
            this.getModListener().onTransformChanged(this, this.transform);
        }
    }

    public final void setTransform(Transform3D t) {
        if (this.transform != t && t != null) {
            this.transform.set(t);
        }
        this.updateWorldTransform();
        this.boundsDirty = true;
        if (this.getParent() != null || this.numChildren() > 0) {
            this.updateBoundsCheap(false, true, true, true);
        }
        if (this.transform != null) {
            this.transform.transformGroup = this;
        }
        if (this.getModListener() != null) {
            this.getModListener().onTransformChanged(this, this.transform);
        }
    }

    public final void updateTransform() {
        this.setTransform(this.getTransform());
    }

    public final void setLocalTransform(Transform3D t) {
        this.setTransform(t);
    }

    public final Transform3D getTransform() {
        return this.transform;
    }

    public final Transform3D getLocalTransform() {
        return this.transform;
    }

    public final void getTransform(Transform3D t) {
        t.set(this.transform.getMatrix4f());
    }

    public final void getLocalTransform(Transform3D t) {
        t.set(this.transform.getMatrix4f());
    }

    public void setPosition(float posX, float posY, float posZ) {
        this.transform.setTranslation(posX, posY, posZ);
    }

    public void setPosition(Tuple3f position) {
        this.setPosition(position.getX(), position.getY(), position.getZ());
    }

    public final void getPosition(Tuple3f position) {
        this.transform.getTranslation(position);
    }

    public final Point3f getPosition() {
        this.transform.getTranslation(this.position);
        return this.position;
    }

    final Transform3D getInlinedWorldTransform() {
        return this.worldTransform;
    }

    public final Transform3D getWorldTransform() {
        return this.worldTransform;
    }

    protected TransformGroup newInstance() {
        boolean gib = Node.globalIgnoreBounds;
        Node.globalIgnoreBounds = this.isIgnoreBounds();
        TransformGroup newTG = new TransformGroup();
        Node.globalIgnoreBounds = gib;
        newTG.setTransform(this.transform);
        return newTG;
    }

    public final boolean traverse(DetailedTraversalCallback callback) {
        if (!callback.traversalOperationCommon(this)) {
            return false;
        }
        if (!callback.traversalOperation(this)) {
            return false;
        }
        if (callback.traversalCheckGroupCommon(this) && callback.traversalCheckGroup(this)) {
            int numChildren = this.numChildren();
            for (int i = 0; i < numChildren; ++i) {
                if (this.getChild(i).traverse(callback)) continue;
                return false;
            }
        }
        return callback.traversalOperationCommonAfter(this) && callback.traversalOperationAfter(this);
    }

    public TransformGroup(Transform3D t) {
        this.setTransform(t);
    }

    public TransformGroup(Matrix4f transform) {
        this.getTransform().set(transform);
    }

    public TransformGroup() {
        this((Transform3D)null);
    }

    public TransformGroup(float translationX, float translationY, float translationZ) {
        this();
        this.getTransform().setTranslation(translationX, translationY, translationZ);
        this.updateTransform();
    }

    public TransformGroup(Tuple3f translation) {
        this(translation.getX(), translation.getY(), translation.getZ());
    }
}

