/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph;

import org.jagatoo.opengl.enums.GeometryArrayType;
import org.openmali.spatial.WriteableTriangleContainer;
import org.openmali.spatial.polygons.Triangle;
import org.xith3d.scenegraph.GeometryStripArray;
import org.xith3d.scenegraph.NodeComponent;

public class TriangleStripArray
extends GeometryStripArray
implements WriteableTriangleContainer {
    private final int triangleCount;

    public final boolean isTriangulatable() {
        return true;
    }

    public final boolean isTriangulated() {
        return true;
    }

    public int getTriangleCount() {
        return this.triangleCount;
    }

    public boolean setTriangle(int i, Triangle triangle) {
        int[] stripLengths = this.getStripVertexCounts();
        int offset = 0;
        for (int j = 0; j < stripLengths.length; ++j) {
            int stripTriangCount = stripLengths[j] - 2;
            if (i < offset + stripTriangCount) {
                int idx0 = i + j * 2;
                int idx1 = idx0 + 1;
                int idx2 = idx0 + 2;
                return this.setTriangle(idx0, idx1, idx2, triangle);
            }
            offset += stripTriangCount;
        }
        return false;
    }

    public boolean getTriangle(int i, Triangle triangle) {
        int[] stripLengths = this.getStripVertexCounts();
        int offset = 0;
        for (int j = 0; j < stripLengths.length; ++j) {
            int stripTriangCount = stripLengths[j] - 2;
            if (i < offset + stripTriangCount) {
                int idx0 = i + j * 2;
                int idx1 = idx0 + 1;
                int idx2 = idx0 + 2;
                return this.getTriangle(idx0, idx1, idx2, triangle);
            }
            offset += stripTriangCount;
        }
        return false;
    }

    protected void duplicateNodeComponent(NodeComponent original, boolean forceDuplicate) {
        super.duplicateNodeComponent(original, forceDuplicate);
    }

    public TriangleStripArray cloneNodeComponent(boolean forceDuplicate) {
        TriangleStripArray tsa = new TriangleStripArray(this.getCoordinatesSize(), this.getVertexCount(), this.getStripVertexCounts());
        tsa.duplicateNodeComponent(this, forceDuplicate);
        return tsa;
    }

    private int computeTriangleCount(int[] stripVertexCounts) {
        if (stripVertexCounts != null) {
            int triangleCount = 0;
            for (int i = 0; i < stripVertexCounts.length; ++i) {
                triangleCount += stripVertexCounts[i] - 2;
            }
            return triangleCount;
        }
        return this.getValidVertexCount();
    }

    public TriangleStripArray(int coordsSize, int vertexCount, int[] stripVertexCounts) {
        super(GeometryArrayType.TRIANGLE_STRIP, coordsSize, vertexCount, stripVertexCounts);
        this.triangleCount = this.computeTriangleCount(stripVertexCounts);
    }

    public TriangleStripArray(int vertexCount, int[] stripVertexCounts) {
        this(3, vertexCount, stripVertexCounts);
    }

    public TriangleStripArray(int coordsSize, int vertexCount) {
        this(coordsSize, vertexCount, new int[]{vertexCount});
    }

    public TriangleStripArray(int vertexCount) {
        this(3, vertexCount, new int[]{vertexCount});
    }
}

