/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph.particles.jops;

import java.util.ArrayList;
import java.util.List;
import org.openmali.spatial.bodies.Frustum;
import org.openmali.vecmath2.Vector3f;
import org.softmed.jops.Generator;
import org.softmed.jops.ParticleSystem;
import org.xith3d.scenegraph.Group;
import org.xith3d.scenegraph.GroupNode;
import org.xith3d.scenegraph.UpdatableNode;
import org.xith3d.scenegraph.View;
import org.xith3d.scenegraph.particles.jops.GeneratorAndPointMassVisualizer;
import org.xith3d.scenegraph.particles.jops.GeneratorShape3D;
import org.xith3d.scenegraph.particles.jops.ShutdownThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ParticleSystemNode
extends Group
implements UpdatableNode {
    protected GroupNode node;
    protected boolean showGeneratorsAndPointMasses = false;
    protected GeneratorAndPointMassVisualizer visualizer;
    protected ArrayList<GeneratorShape3D> generatorShapes = new ArrayList();
    protected ParticleSystem particleSystem;

    protected abstract void customSetup();

    protected abstract void customUpdate(Vector3f var1, Vector3f var2);

    protected void setup() {
        if (this.node != null) {
            this.clearShapes();
        }
        this.customSetup();
    }

    protected void clearShapes() {
        for (int i = 0; i < this.generatorShapes.size(); ++i) {
            GeneratorShape3D generatorShape = this.generatorShapes.get(i);
            generatorShape.dispose();
        }
        this.generatorShapes.clear();
        this.showGeneratorsAndPointMasses = false;
        if (this.visualizer != null) {
            this.visualizer.dispose();
        }
    }

    protected void updateGeneratorShapes(Vector3f up, Vector3f right) {
        for (int i = 0; i < this.generatorShapes.size(); ++i) {
            GeneratorShape3D generatorShape = this.generatorShapes.get(i);
            generatorShape.update(up, right);
            generatorShape.updateBounds(false);
        }
    }

    protected void update(Vector3f up, Vector3f right) {
        this.customUpdate(up, right);
        this.updateGeneratorShapes(up, right);
        if (!this.particleSystem.isAlive() && this.particleSystem.isRemove()) {
            this.setRenderable(false);
            this.node.setRenderable(false);
            for (int i = 0; i < this.generatorShapes.size(); ++i) {
                this.generatorShapes.get(i).setRenderable(false);
            }
            new ShutdownThread(this).cleanParticleSystemNode();
        }
    }

    public void shutdown() {
        this.detach();
        for (int i = 0; i < this.generatorShapes.size(); ++i) {
            this.generatorShapes.get(i).detach();
        }
        this.clearShapes();
    }

    protected void installGenerators(boolean relativeOrientation, GroupNode node) {
        this.node = node;
        List gens = this.particleSystem.getGenerators();
        GeneratorShape3D generatorShape3D = null;
        for (int i = 0; i < gens.size(); ++i) {
            Generator generator = (Generator)gens.get(i);
            generatorShape3D = new GeneratorShape3D(relativeOrientation, generator);
            this.generatorShapes.add(generatorShape3D);
            node.addChild(generatorShape3D);
        }
        this.updateVisualizer();
    }

    private void updateVisualizer() {
        if (this.showGeneratorsAndPointMasses) {
            this.visualizer = new GeneratorAndPointMassVisualizer();
            this.visualizer.showGeneratorsAndPointMasses(this.particleSystem, this.node);
        } else if (this.visualizer != null) {
            this.visualizer.removeGeneratorsAndPointMasses();
            this.visualizer = null;
        }
    }

    public void setParticleSystem(ParticleSystem ps) {
        this.particleSystem = ps;
        this.setup();
    }

    public ParticleSystem getParticleSystem() {
        return this.particleSystem;
    }

    @Override
    public boolean update(View view, Frustum frustrum, long nanoTime, long nanoStep) {
        this.update(view.getUpDirection(), view.getRightDirection());
        return true;
    }

    public boolean isShowGeneratorsAndPointMasses() {
        return this.showGeneratorsAndPointMasses;
    }

    public void setShowGeneratorsAndPointMasses(boolean showGeneratorsAndPointMasses) {
        this.showGeneratorsAndPointMasses = showGeneratorsAndPointMasses;
        this.updateVisualizer();
    }

    public final List<GeneratorShape3D> getGeneratorShapes() {
        return this.generatorShapes;
    }

    public ParticleSystemNode(ParticleSystem ps) {
        this.setParticleSystem(ps);
    }

    public ParticleSystemNode() {
    }
}

