/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph.primitives;

import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.render.BackgroundRenderPass;
import org.xith3d.render.BaseRenderPassConfig;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.View;
import org.xith3d.scenegraph.primitives.Rectangle;

public class BackgroundImage
extends BackgroundRenderPass {
    private Rectangle rect;

    public void setTexture(Texture texture) {
        this.rect.setTexture(texture);
    }

    public void setTexture(String texture) {
        this.rect.setTexture(TextureLoader.getInstance().getTextureOrNull(texture, Texture.MipmapMode.BASE_LEVEL));
    }

    public Texture getTexture() {
        return this.rect.getTexture();
    }

    public BackgroundImage(Texture texture, float aspectRatio) {
        super(new BaseRenderPassConfig(View.CameraMode.VIEW_FIXED));
        Rectangle rect = new Rectangle(2.0f, 2.0f / aspectRatio, -1.0f, texture);
        super.getBranchGroup().addChild(rect);
    }

    public BackgroundImage(String texture, float aspectRatio) {
        this(TextureLoader.getInstance().getTextureOrNull(texture, Texture.MipmapMode.BASE_LEVEL), aspectRatio);
    }
}

