/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph.primitives;

import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.TexCoord2f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.StaticTransform;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.TriangleArray;
import org.xith3d.scenegraph.primitives.Cylinder;
import org.xith3d.scenegraph.primitives.GeomFactory;
import org.xith3d.scenegraph.primitives.GeometryConstruct;
import org.xith3d.scenegraph.primitives.GeometryType;
import org.xith3d.scenegraph.primitives.Hemisphere;

public class Capsule
extends Shape3D {
    private static GeometryType geomConstructTypeHint = GeometryType.TRIANGLE_ARRAY;

    public static void setGeometryConstructionTypeHint(GeometryType hint) {
        switch (hint) {
            case TRIANGLE_ARRAY: {
                geomConstructTypeHint = hint;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Currently " + Cylinder.class.getSimpleName() + " does not support " + (Object)((Object)hint));
            }
        }
    }

    public static GeometryType getGeometryConstructionTypeHint() {
        return geomConstructTypeHint;
    }

    public static GeometryConstruct createGeometryConstructTA(int slices, int stacks, float radius, float length, int features, boolean colorAlpha, int texCoordsSize) {
        int i;
        GeometryConstruct gcCapTop = Hemisphere.createGeometryConstructTA(slices, stacks, features, colorAlpha, texCoordsSize);
        GeometryConstruct gcCapBottom = Hemisphere.createGeometryConstructTA(slices, stacks, features, colorAlpha, texCoordsSize);
        GeometryConstruct gcBody = Cylinder.createGeometryConstructTA(1.0f, 1.0f, 1.0f, false, slices, features, colorAlpha, texCoordsSize);
        if (radius != 1.0f) {
            StaticTransform.scale(gcCapTop.getCoordinates(), radius, radius, radius);
        }
        StaticTransform.translate(gcCapTop.getCoordinates(), 0.0f, length / 2.0f, 0.0f);
        if (radius != 1.0f || length != 1.0f) {
            StaticTransform.scale(gcBody.getCoordinates(), radius, length, radius);
        }
        if (radius != 1.0f) {
            StaticTransform.scale(gcCapBottom.getCoordinates(), radius, radius, radius);
        }
        StaticTransform.rotateX(gcCapBottom.getCoordinates(), (float)(-Math.PI));
        StaticTransform.rotateX((Tuple3f[])gcCapBottom.getNormals(), (float)(-Math.PI));
        StaticTransform.translate(gcCapBottom.getCoordinates(), 0.0f, -(length / 2.0f), 0.0f);
        if ((features & 8) != 0 && texCoordsSize == 2) {
            TexCoord2f tc;
            int i2;
            float relTopSize = 1.0f / (radius + radius + length) * radius;
            float relBodySize = 1.0f / (radius + radius + length) * length;
            float relBottomSize = 1.0f / (radius + radius + length) * radius;
            for (i2 = 0; i2 < gcCapTop.getTextureCoordinates2f().length; ++i2) {
                tc = gcCapTop.getTextureCoordinates2f()[i2];
                tc.mulT(relTopSize);
                tc.addT(relBottomSize + relBodySize);
            }
            for (i2 = 0; i2 < gcBody.getTextureCoordinates2f().length; ++i2) {
                tc = gcBody.getTextureCoordinates2f()[i2];
                tc.mulT(relBodySize);
                tc.addT(relBottomSize);
            }
            for (i2 = 0; i2 < gcCapBottom.getTextureCoordinates2f().length; ++i2) {
                tc = gcCapBottom.getTextureCoordinates2f()[i2];
                tc.mulT(relBottomSize);
                tc.addT(relBottomSize - tc.getT());
                tc.setS(1.0f - tc.getS());
            }
        }
        Tuple3f[] vertices = null;
        Vector3f[] normals = null;
        TexCoord2f[] texCoords = null;
        vertices = new Tuple3f[gcCapTop.numVertices() + gcBody.numVertices() + gcCapBottom.numVertices()];
        int j = 0;
        for (i = 0; i < gcCapTop.numVertices(); ++i) {
            vertices[j++] = gcCapTop.getCoordinates()[i];
        }
        for (i = 0; i < gcBody.numVertices(); ++i) {
            vertices[j++] = gcBody.getCoordinates()[i];
        }
        for (i = 0; i < gcCapBottom.numVertices(); ++i) {
            vertices[j++] = gcCapBottom.getCoordinates()[i];
        }
        if ((features & 2) > 0) {
            normals = new Vector3f[gcCapTop.numNormals() + gcBody.numNormals() + gcCapBottom.numNormals()];
            j = 0;
            for (i = 0; i < gcCapTop.numNormals(); ++i) {
                normals[j++] = gcCapTop.getNormals()[i];
            }
            for (i = 0; i < gcBody.numNormals(); ++i) {
                normals[j++] = gcBody.getNormals()[i];
            }
            for (i = 0; i < gcCapBottom.numNormals(); ++i) {
                normals[j++] = gcCapBottom.getNormals()[i];
            }
        }
        if ((features & 8) != 0 && texCoordsSize == 2) {
            texCoords = new TexCoord2f[gcCapTop.numTextureCoordinates2f() + gcBody.numTextureCoordinates2f() + gcCapBottom.numTextureCoordinates2f()];
            j = 0;
            for (i = 0; i < gcCapTop.numTextureCoordinates2f(); ++i) {
                texCoords[j++] = gcCapTop.getTextureCoordinates2f()[i];
            }
            for (i = 0; i < gcBody.numTextureCoordinates2f(); ++i) {
                texCoords[j++] = gcBody.getTextureCoordinates2f()[i];
            }
            for (i = 0; i < gcCapBottom.numTextureCoordinates2f(); ++i) {
                texCoords[j++] = gcCapBottom.getTextureCoordinates2f()[i];
            }
        }
        return new GeometryConstruct(GeometryType.TRIANGLE_ARRAY, vertices, normals, texCoords);
    }

    public static TriangleArray createGeometryTA(int slices, int stacks, float radius, float length, int features, boolean colorAlpha, int texCoordsSize) {
        GeometryConstruct data = Capsule.createGeometryConstructTA(slices, stacks, radius, length, features |= 1, colorAlpha, texCoordsSize);
        return GeomFactory.createTriangleArray(data);
    }

    public static Geometry createGeometry(int slices, int stacks, float radius, float length, int features, boolean colorAlpha, int texCoordsSize) {
        switch (Capsule.getGeometryConstructionTypeHint()) {
            case TRIANGLE_ARRAY: {
                return Capsule.createGeometryTA(slices, stacks, radius, length, features, colorAlpha, texCoordsSize);
            }
        }
        throw new Error(Capsule.getGeometryConstructionTypeHint().getCorrespondingClass().getSimpleName() + " creation is not yet implemented.");
    }

    public Capsule(int slices, int stacks, int features, boolean colorAlpha, int texCoordsSize) {
        super(Capsule.createGeometry(slices, stacks, 1.0f, 1.0f, features, colorAlpha, texCoordsSize));
    }

    public Capsule(float radius, float length, int slices, int stacks, int features, boolean colorAlpha, int texCoordsSize) {
        super(Capsule.createGeometry(slices, stacks, radius, length, features, colorAlpha, texCoordsSize));
    }

    public Capsule(float radius, float length, int slices, int stacks, Texture texture) {
        this(radius, length, slices, stacks, 11, false, 2);
        this.getAppearance(true).setTexture(texture);
    }

    public Capsule(int slices, int stacks, Texture texture) {
        this(slices, stacks, 11, false, 2);
        this.getAppearance(true).setTexture(texture);
    }

    public Capsule(float radius, float length, int slices, int stacks, String texture) {
        this(radius, length, slices, stacks, TextureLoader.getInstance().getTexture(texture));
    }

    public Capsule(int slices, int stacks, String texture) {
        this(slices, stacks, TextureLoader.getInstance().getTexture(texture));
    }

    public Capsule(float radius, float length, int slices, int stacks, Colorf color) {
        this(radius, length, slices, stacks, 3, false, 2);
        this.getAppearance(true).getColoringAttributes(true).setColor(color);
        if (color.hasAlpha()) {
            this.getAppearance(true).getTransparencyAttributes(true).setTransparency(color.getAlpha());
        }
    }

    public Capsule(int slices, int stacks, Colorf color) {
        this(1.0f, 1.0f, slices, stacks, color);
    }

    public Capsule(float radius, float length, int slices, int stacks, Appearance app) {
        this(radius, length, slices, stacks, 3 | GeomFactory.getFeaturesFromAppearance(app), false, GeomFactory.getTexCoordsSize(app));
        this.setAppearance(app);
    }

    public Capsule(int slices, int stacks, Appearance app) {
        this(1.0f, 1.0f, slices, stacks, app);
    }
}

