/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph.primitives;

import org.openmali.FastMath;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.TexCoord2f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.StaticTransform;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.TriangleArray;
import org.xith3d.scenegraph.primitives.GeomFactory;
import org.xith3d.scenegraph.primitives.GeometryConstruct;
import org.xith3d.scenegraph.primitives.GeometryType;

public class GeoSphere
extends Shape3D {
    private static GeometryType geomConstructTypeHint = GeometryType.TRIANGLE_ARRAY;

    public static void setGeometryConstructionTypeHint(GeometryType hint) {
        switch (hint) {
            case TRIANGLE_ARRAY: {
                geomConstructTypeHint = hint;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Currently " + GeoSphere.class.getSimpleName() + " does not support " + (Object)((Object)hint));
            }
        }
    }

    public static GeometryType getGeometryConstructionTypeHint() {
        return geomConstructTypeHint;
    }

    private static void geodesate(Vector3f a, Vector3f b, Vector3f c, int N, int offset, Vector3f[] vertices) {
        Vector3f[][] buffer = new Vector3f[2][N + 1];
        buffer[0][0] = new Vector3f((Tuple3f)a);
        for (int i = 0; i < N; ++i) {
            int top = i % 2;
            int bottom = (i + 1) % 2;
            buffer[bottom][0] = new Vector3f();
            buffer[bottom][0].setX((float)(N - i - 1) * a.getX() + (float)(i + 1) * b.getX());
            buffer[bottom][0].setY((float)(N - i - 1) * a.getY() + (float)(i + 1) * b.getY());
            buffer[bottom][0].setZ((float)(N - i - 1) * a.getZ() + (float)(i + 1) * b.getZ());
            buffer[bottom][0].normalize();
            for (int j = 0; j <= i; ++j) {
                buffer[bottom][j + 1] = new Vector3f();
                buffer[bottom][j + 1].setX((float)(N - i - 1) * a.getX() + (float)(i - j) * b.getX() + (float)(j + 1) * c.getX());
                buffer[bottom][j + 1].setY((float)(N - i - 1) * a.getY() + (float)(i - j) * b.getY() + (float)(j + 1) * c.getY());
                buffer[bottom][j + 1].setZ((float)(N - i - 1) * a.getZ() + (float)(i - j) * b.getZ() + (float)(j + 1) * c.getZ());
                buffer[bottom][j + 1].normalize();
                vertices[offset++] = buffer[top][j];
                vertices[offset++] = buffer[bottom][j];
                vertices[offset++] = buffer[bottom][j + 1];
                if (j >= i) continue;
                vertices[offset++] = buffer[top][j];
                vertices[offset++] = buffer[bottom][j + 1];
                vertices[offset++] = buffer[top][j + 1];
            }
        }
    }

    public static GeometryConstruct createGeometryConstructTA(int N, int features, boolean colorAlpha, int texcoordsSize, boolean hemisphere) {
        if (N < 0) {
            throw new IllegalArgumentException("require N>=0");
        }
        features |= 1;
        int strips = hemisphere ? 2 : 4;
        int triangles = strips * 5;
        Vector3f[] coords = new Vector3f[3 * triangles * N * N];
        for (int i = 0; i < 5; ++i) {
            Vector3f a = new Vector3f(0.0f, 0.0f, 1.0f);
            Vector3f b = new Vector3f();
            b.setX(FastMath.cos((float)((float)(i + 0) * ((float)Math.PI * 2) / 5.0f)) * FastMath.sin((float)1.0471976f));
            b.setY(FastMath.sin((float)((float)(i + 0) * ((float)Math.PI * 2) / 5.0f)) * FastMath.sin((float)1.0471976f));
            b.setZ(FastMath.cos((float)1.0471976f));
            Vector3f c = new Vector3f();
            c.setX(FastMath.cos((float)((float)(i + 1) * ((float)Math.PI * 2) / 5.0f)) * FastMath.sin((float)1.0471976f));
            c.setY(FastMath.sin((float)((float)(i + 1) * ((float)Math.PI * 2) / 5.0f)) * FastMath.sin((float)1.0471976f));
            c.setZ(FastMath.cos((float)1.0471976f));
            GeoSphere.geodesate(a, b, c, N, 3 * (strips * i + 0) * N * N, coords);
            a = new Vector3f();
            a.setX(FastMath.cos((float)((float)i * ((float)Math.PI * 2) / 5.0f)) * FastMath.sin((float)1.0471976f));
            a.setY(FastMath.sin((float)((float)i * ((float)Math.PI * 2) / 5.0f)) * FastMath.sin((float)1.0471976f));
            a.setZ(FastMath.cos((float)1.0471976f));
            b = new Vector3f();
            b.setX(FastMath.cos((float)((float)i * ((float)Math.PI * 2) / 5.0f + 0.62831855f)) * FastMath.sin((float)2.0943952f));
            b.setY(FastMath.sin((float)((float)i * ((float)Math.PI * 2) / 5.0f + 0.62831855f)) * FastMath.sin((float)2.0943952f));
            b.setZ(FastMath.cos((float)2.0943952f));
            c = new Vector3f();
            c.setX(FastMath.cos((float)((float)(i + 1) * ((float)Math.PI * 2) / 5.0f)) * FastMath.sin((float)1.0471976f));
            c.setY(FastMath.sin((float)((float)(i + 1) * ((float)Math.PI * 2) / 5.0f)) * FastMath.sin((float)1.0471976f));
            c.setZ(FastMath.cos((float)1.0471976f));
            GeoSphere.geodesate(a, b, c, N, 3 * (strips * i + 1) * N * N, coords);
            if (hemisphere) continue;
            a = new Vector3f();
            a.setX(FastMath.cos((float)((float)i * ((float)Math.PI * 2) / 5.0f + 0.62831855f)) * FastMath.sin((float)2.0943952f));
            a.setY(FastMath.sin((float)((float)i * ((float)Math.PI * 2) / 5.0f + 0.62831855f)) * FastMath.sin((float)2.0943952f));
            a.setZ(FastMath.cos((float)2.0943952f));
            b = new Vector3f();
            b.setX(FastMath.cos((float)((float)(i + 1) * ((float)Math.PI * 2) / 5.0f + 0.62831855f)) * FastMath.sin((float)2.0943952f));
            b.setY(FastMath.sin((float)((float)(i + 1) * ((float)Math.PI * 2) / 5.0f + 0.62831855f)) * FastMath.sin((float)2.0943952f));
            b.setZ(FastMath.cos((float)2.0943952f));
            c = new Vector3f();
            c.setX(FastMath.cos((float)((float)(i + 1) * ((float)Math.PI * 2) / 5.0f)) * FastMath.sin((float)1.0471976f));
            c.setY(FastMath.sin((float)((float)(i + 1) * ((float)Math.PI * 2) / 5.0f)) * FastMath.sin((float)1.0471976f));
            c.setZ(FastMath.cos((float)1.0471976f));
            GeoSphere.geodesate(a, b, c, N, 3 * (strips * i + 2) * N * N, coords);
            a = new Vector3f();
            a.setX(FastMath.cos((float)((float)i * ((float)Math.PI * 2) / 5.0f + 0.62831855f)) * FastMath.sin((float)2.0943952f));
            a.setY(FastMath.sin((float)((float)i * ((float)Math.PI * 2) / 5.0f + 0.62831855f)) * FastMath.sin((float)2.0943952f));
            a.setZ(FastMath.cos((float)2.0943952f));
            b = new Vector3f(0.0f, 0.0f, -1.0f);
            c = new Vector3f();
            c.setX(FastMath.cos((float)((float)(i + 1) * ((float)Math.PI * 2) / 5.0f + 0.62831855f)) * FastMath.sin((float)2.0943952f));
            c.setY(FastMath.sin((float)((float)(i + 1) * ((float)Math.PI * 2) / 5.0f + 0.62831855f)) * FastMath.sin((float)2.0943952f));
            c.setZ(FastMath.cos((float)2.0943952f));
            GeoSphere.geodesate(a, b, c, N, 3 * (strips * i + 3) * N * N, coords);
        }
        Point3f[] vertices = new Point3f[coords.length];
        for (int i = 0; i < coords.length; ++i) {
            vertices[i] = new Point3f((Tuple3f)coords[i]);
        }
        StaticTransform.rotateX((Tuple3f[])vertices, 1.5707964f);
        Vector3f[] normals = null;
        if ((features & 2) > 0) {
            normals = GeomFactory.generateNaiveNormals((Tuple3f[])vertices);
        }
        Colorf[] colors = null;
        if ((features & 4) != 0) {
            colors = new Colorf[vertices.length];
            for (int i = 0; i < vertices.length; ++i) {
                colors[i] = colorAlpha ? new Colorf(vertices[i].getX(), vertices[i].getY(), vertices[i].getZ(), 0.0f) : new Colorf(vertices[i].getX(), vertices[i].getY(), vertices[i].getZ());
                colors[i].mul(2.0f);
            }
        }
        TexCoord2f[] texCoords = null;
        if ((features & 8) != 0 && texcoordsSize == 2) {
            texCoords = GeomFactory.generateTexCoords2((Tuple3f[])vertices);
        }
        return new GeometryConstruct(GeometryType.TRIANGLE_ARRAY, (Tuple3f[])vertices, normals, texCoords, colors);
    }

    public static TriangleArray createGeometryTA(int N, int features, boolean colorAlpha, int texCoordsSize, boolean hemisphere) {
        GeometryConstruct gcTA = GeoSphere.createGeometryConstructTA(N, features |= 1, colorAlpha, texCoordsSize, hemisphere);
        return GeomFactory.createTriangleArray(gcTA);
    }

    public static Geometry createGeometry(int N, int features, boolean colorAlpha, int texCoordsSize, boolean hemisphere) {
        switch (GeoSphere.getGeometryConstructionTypeHint()) {
            case TRIANGLE_ARRAY: {
                return GeoSphere.createGeometryTA(N, features, colorAlpha, texCoordsSize, hemisphere);
            }
        }
        throw new Error(GeoSphere.getGeometryConstructionTypeHint().getCorrespondingClass().getSimpleName() + " creation is not yet implemented.");
    }

    public GeoSphere(int N, int features, boolean colorAlpha, int texCoordsSize, boolean hemisphere) {
        super(GeoSphere.createGeometry(N, features, colorAlpha, texCoordsSize, hemisphere));
    }

    public GeoSphere(float radius, int N, int features, boolean colorAlpha, int texCoordsSize, boolean hemisphere) {
        this(N, features, colorAlpha, texCoordsSize, hemisphere);
        StaticTransform.scale(this, radius);
    }

    public GeoSphere(int N, int features, boolean colorAlpha, int texCoordsSize) {
        this(N, features, colorAlpha, texCoordsSize, false);
    }

    public GeoSphere(float radius, int N, int features, boolean colorAlpha, int texCoordsSize) {
        this(radius, N, features, colorAlpha, texCoordsSize, false);
    }

    public GeoSphere(int N, boolean hemisphere, Texture texture) {
        this(N, 11, false, 2, hemisphere);
        this.getAppearance(true).setTexture(texture);
    }

    public GeoSphere(float radius, int N, boolean hemisphere, Texture texture) {
        this(radius, N, 11, false, 2, hemisphere);
        this.getAppearance(true).setTexture(texture);
    }

    public GeoSphere(int N, Texture texture) {
        this(N, false, texture);
    }

    public GeoSphere(float radius, int N, Texture texture) {
        this(radius, N, false, texture);
    }

    public GeoSphere(int N, boolean hemisphere, String texture) {
        this(N, hemisphere, (Texture)TextureLoader.getInstance().getTexture(texture));
    }

    public GeoSphere(float radius, int N, boolean hemisphere, String texture) {
        this(radius, N, hemisphere, TextureLoader.getInstance().getTexture(texture));
    }

    public GeoSphere(int N, String texture) {
        this(N, false, texture);
    }

    public GeoSphere(float radius, int N, String texture) {
        this(radius, N, false, texture);
    }

    public GeoSphere(int N, boolean hemisphere, Colorf color) {
        this(N, 3, false, 2, hemisphere);
        this.getAppearance(true).getColoringAttributes(true).setColor(color);
    }

    public GeoSphere(float radius, int N, boolean hemisphere, Colorf color) {
        this(radius, N, 3, false, 2, hemisphere);
        this.getAppearance(true).getColoringAttributes(true).setColor(color);
        if (color.hasAlpha()) {
            this.getAppearance(true).getTransparencyAttributes(true).setTransparency(color.getAlpha());
        }
    }

    public GeoSphere(int N, Colorf color) {
        this(N, false, color);
    }

    public GeoSphere(float radius, int N, Colorf color) {
        this(radius, N, false, color);
    }

    public GeoSphere(int N, boolean hemisphere, Appearance app) {
        this(N, 3 | GeomFactory.getFeaturesFromAppearance(app), false, GeomFactory.getTexCoordsSize(app), hemisphere);
        this.setAppearance(app);
    }

    public GeoSphere(float radius, int N, boolean hemisphere, Appearance app) {
        this(radius, N, 3 | GeomFactory.getFeaturesFromAppearance(app), false, GeomFactory.getTexCoordsSize(app), hemisphere);
        this.setAppearance(app);
    }

    public GeoSphere(int N, Appearance app) {
        this(N, false, app);
    }

    public GeoSphere(float radius, int N, Appearance app) {
        this(radius, N, false, app);
    }
}

