/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph.primitives;

import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.TexCoord2f;
import org.openmali.vecmath2.TexCoord3f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.scenegraph.primitives.GeomFactory;
import org.xith3d.scenegraph.primitives.GeometryType;

public class GeometryConstruct {
    private GeometryType geometryTypeHint;
    private Tuple3f[] coords;
    private Vector3f[] normals;
    private TexCoord2f[] texCoords2f;
    private TexCoord3f[] texCoords3f;
    private Colorf[] colors;
    private int[] indices;
    private int[] stripLengths;

    public GeometryType getGeometryTypeHint() {
        return this.geometryTypeHint;
    }

    public Tuple3f[] getCoordinates() {
        return this.coords;
    }

    public int numVertices() {
        if (this.coords == null) {
            return 0;
        }
        return this.coords.length;
    }

    public Vector3f[] getNormals() {
        return this.normals;
    }

    public int numNormals() {
        if (this.normals == null) {
            return 0;
        }
        return this.normals.length;
    }

    public TexCoord2f[] getTextureCoordinates2f() {
        return this.texCoords2f;
    }

    public int numTextureCoordinates2f() {
        if (this.texCoords2f == null) {
            return 0;
        }
        return this.texCoords2f.length;
    }

    public TexCoord3f[] getTextureCoordinates3f() {
        return this.texCoords3f;
    }

    public int numTextureCoordinates3f() {
        if (this.texCoords3f == null) {
            return 0;
        }
        return this.texCoords3f.length;
    }

    public Colorf[] getColors() {
        return this.colors;
    }

    public int numColors() {
        if (this.colors == null) {
            return 0;
        }
        return this.colors.length;
    }

    public int[] getIndices() {
        return this.indices;
    }

    public int numIndices() {
        if (this.indices == null) {
            return 0;
        }
        return this.indices.length;
    }

    public int[] getStripLengths() {
        return this.stripLengths;
    }

    public int calculateFeatures() {
        return GeomFactory.calculateFeatures(this.getCoordinates(), this.getNormals(), this.getColors(), this.getTextureCoordinates2f(), this.getTextureCoordinates3f());
    }

    public void check() {
        if (this.getGeometryTypeHint() == null) {
            throw new Error("GeometryTypeHint must not be null");
        }
        if (this.numVertices() == 0) {
            throw new Error("vertices must not be null nor 0 for " + (Object)((Object)this.getGeometryTypeHint()));
        }
        switch (this.getGeometryTypeHint()) {
            case INDEXED_TRIANGLE_STRIP_ARRAY: {
                if (this.numIndices() == 0) {
                    throw new Error("vertices must not be null nor 0 for " + (Object)((Object)this.getGeometryTypeHint()));
                }
                if (this.getStripLengths() != null && this.getStripLengths().length != 0) break;
                throw new Error("stripLength must not be null nor 0 for " + (Object)((Object)this.getGeometryTypeHint()));
            }
            case INDEXED_TRIANGLE_ARRAY: {
                if (this.numIndices() != 0) break;
                throw new Error("vertices must not be null nor 0 for " + (Object)((Object)this.getGeometryTypeHint()));
            }
            case TRIANGLE_STRIP_ARRAY: {
                if (this.getStripLengths() != null && this.getStripLengths().length != 0) break;
                throw new Error("stripLength must not be null nor 0 for " + (Object)((Object)this.getGeometryTypeHint()));
            }
        }
    }

    private GeometryConstruct(GeometryType geometryTypeHint, Tuple3f[] coords, Vector3f[] normals, TexCoord2f[] texCoords2f, TexCoord3f[] texCoords3f, Colorf[] colors, int[] indices, int[] stripLengths) {
        this.geometryTypeHint = geometryTypeHint;
        this.coords = coords;
        this.normals = normals;
        this.texCoords2f = texCoords2f;
        this.texCoords3f = texCoords3f;
        this.colors = colors;
        this.indices = indices;
        this.stripLengths = stripLengths;
        this.check();
    }

    public GeometryConstruct(GeometryType geometryTypeHint, Tuple3f[] coords, Vector3f[] normals, TexCoord2f[] texCoords2f, Colorf[] colors, int[] indices, int[] stripLengths) {
        this(geometryTypeHint, coords, normals, texCoords2f, null, colors, indices, stripLengths);
    }

    public GeometryConstruct(GeometryType geometryTypeHint, Tuple3f[] coords, Vector3f[] normals, TexCoord3f[] texCoords3f, Colorf[] colors, int[] indices, int[] stripLengths) {
        this(geometryTypeHint, coords, normals, null, texCoords3f, colors, indices, stripLengths);
    }

    public GeometryConstruct(GeometryType geometryTypeHint, Tuple3f[] coords, Vector3f[] normals, TexCoord2f[] texCoords2f, Colorf[] colors) {
        this(geometryTypeHint, coords, normals, texCoords2f, null, colors, null, null);
    }

    public GeometryConstruct(GeometryType geometryTypeHint, Tuple3f[] coords, Vector3f[] normals, TexCoord3f[] texCoords3f, Colorf[] colors) {
        this(geometryTypeHint, coords, normals, null, texCoords3f, colors, null, null);
    }

    public GeometryConstruct(GeometryType geometryTypeHint, Tuple3f[] coords, Vector3f[] normals, TexCoord2f[] texCoords2f, int[] indices, int[] stripLengths) {
        this(geometryTypeHint, coords, normals, texCoords2f, null, null, indices, stripLengths);
    }

    public GeometryConstruct(GeometryType geometryTypeHint, Tuple3f[] coords, Vector3f[] normals, TexCoord3f[] texCoords3f, int[] indices, int[] stripLengths) {
        this(geometryTypeHint, coords, normals, null, texCoords3f, null, indices, stripLengths);
    }

    public GeometryConstruct(GeometryType geometryTypeHint, Tuple3f[] coords, Vector3f[] normals, TexCoord2f[] texCoords2f) {
        this(geometryTypeHint, coords, normals, texCoords2f, null, null, null, null);
    }

    public GeometryConstruct(GeometryType geometryTypeHint, Tuple3f[] coords, Vector3f[] normals, TexCoord3f[] texCoords3f) {
        this(geometryTypeHint, coords, normals, null, texCoords3f, null, null, null);
    }
}

