/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph.primitives;

import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.TexCoord2f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.IndexedTriangleArray;
import org.xith3d.scenegraph.IndexedTriangleStripArray;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.TriangleArray;
import org.xith3d.scenegraph.TriangleStripArray;
import org.xith3d.scenegraph.primitives.Cylinder;
import org.xith3d.scenegraph.primitives.GeomFactory;
import org.xith3d.scenegraph.primitives.GeometryConstruct;
import org.xith3d.scenegraph.primitives.GeometryType;

public class Grid
extends Shape3D {
    private static GeometryType geomConstructTypeHint = GeometryType.INDEXED_TRIANGLE_STRIP_ARRAY;

    public static void setGeometryConstructionTypeHint(GeometryType hint) {
        switch (hint) {
            case INDEXED_TRIANGLE_STRIP_ARRAY: 
            case INDEXED_TRIANGLE_ARRAY: 
            case TRIANGLE_STRIP_ARRAY: 
            case TRIANGLE_ARRAY: {
                geomConstructTypeHint = hint;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Currently " + Cylinder.class.getSimpleName() + " does not support " + (Object)((Object)hint));
            }
        }
    }

    public static GeometryType getGeometryConstructionTypeHint() {
        return geomConstructTypeHint;
    }

    public static GeometryConstruct createGeometryConstructITSA(float width, float height, int resX, int resY, int features, boolean colorAlpha, int texCoordsSize) {
        if (resX < 1 || resY < 1) {
            throw new IllegalArgumentException("insufficient resolution");
        }
        Point3f[] vertices = null;
        Vector3f[] normals = null;
        TexCoord2f[] texCoords = null;
        vertices = new Point3f[(resX + 1) * (resY + 1)];
        if ((features & 2) > 0) {
            normals = new Vector3f[vertices.length];
        }
        if ((features & 8) > 0 && texCoordsSize == 2) {
            texCoords = new TexCoord2f[vertices.length];
        }
        int k = 0;
        for (int j = 0; j < resY + 1; ++j) {
            for (int i = 0; i < resX + 1; ++i) {
                vertices[k] = new Point3f(width * (-0.5f + (float)i / (float)resX), height * (-0.5f + (float)j / (float)resY), 0.0f);
                if (normals != null) {
                    normals[k] = new Vector3f(0.0f, 0.0f, 1.0f);
                }
                if (texCoords != null) {
                    float tx = (float)i * 1.0f / (float)resX;
                    float ty = (float)j * 1.0f / (float)resY;
                    texCoords[k] = new TexCoord2f(tx, ty);
                }
                ++k;
            }
        }
        int stripLength = 2 + resX * 2;
        int[] indices = new int[stripLength * resY];
        for (int j = 0; j < resY; ++j) {
            for (int i = 0; i < resX + 1; ++i) {
                k = j * stripLength + i * 2;
                if (j % 2 == 0) {
                    indices[k + 0] = (j + 0) * (resX + 1) + i;
                    indices[k + 1] = (j + 1) * (resX + 1) + i;
                    continue;
                }
                indices[k + 0] = (j + 0) * (resX + 1) + (resX - i);
                indices[k + 1] = (j + 1) * (resX + 1) + (resX - i);
            }
        }
        Colorf[] colors = null;
        if ((features & 4) != 0) {
            colors = GeomFactory.generateColors(colorAlpha, (Tuple3f[])vertices);
        }
        int[] stripLengths = new int[resY];
        for (int i = 0; i < resY; ++i) {
            stripLengths[i] = stripLength;
        }
        return new GeometryConstruct(GeometryType.INDEXED_TRIANGLE_STRIP_ARRAY, (Tuple3f[])vertices, normals, texCoords, colors, indices, stripLengths);
    }

    public static IndexedTriangleStripArray createGeometryITSA(float width, float height, int resX, int resY, int features, boolean colorAlpha, int texCoordsSize) {
        GeometryConstruct gcITSA = Grid.createGeometryConstructITSA(width, height, resX, resY, features |= 1, colorAlpha, texCoordsSize);
        return GeomFactory.createIndexedTriangleStripArray(gcITSA);
    }

    public static GeometryConstruct createGeometryConstructITA(float width, float height, int resX, int resY, int features, boolean colorAlpha, int texCoordsSize) {
        GeometryConstruct gcITSA = Grid.createGeometryConstructITSA(width, height, resX, resY, features |= 1, colorAlpha, texCoordsSize);
        return GeomFactory.convertGeometryConstructITSA2ITA(gcITSA);
    }

    public static IndexedTriangleArray createGeometryITA(float width, float height, int resX, int resY, int features, boolean colorAlpha, int texCoordsSize) {
        GeometryConstruct gcITSA = Grid.createGeometryConstructITSA(width, height, resX, resY, features |= 1, colorAlpha, texCoordsSize);
        return GeomFactory.createITAfromITSA(gcITSA);
    }

    public static GeometryConstruct createGeometryConstructTSA(float width, float height, int resX, int resY, int features, boolean colorAlpha, int texCoordsSize) {
        GeometryConstruct gcITSA = Grid.createGeometryConstructITSA(width, height, resX, resY, features |= 1, colorAlpha, texCoordsSize);
        return GeomFactory.convertGeometryConstructITSA2TSA(gcITSA);
    }

    public static TriangleStripArray createGeometryTSA(float width, float height, int resX, int resY, int features, boolean colorAlpha, int texCoordsSize) {
        GeometryConstruct gcITSA = Grid.createGeometryConstructITSA(width, height, resX, resY, features |= 1, colorAlpha, texCoordsSize);
        return GeomFactory.createTSAfromITSA(gcITSA);
    }

    public static GeometryConstruct createGeometryConstructTA(float width, float height, int resX, int resY, int features, boolean colorAlpha, int texCoordsSize) {
        GeometryConstruct gcITSA = Grid.createGeometryConstructITSA(width, height, resX, resY, features |= 1, colorAlpha, texCoordsSize);
        return GeomFactory.convertGeometryConstructITSA2TA(gcITSA);
    }

    public static TriangleArray createGeometryTA(float width, float height, int resX, int resY, int features, boolean colorAlpha, int texCoordsSize) {
        GeometryConstruct gcITSA = Grid.createGeometryConstructITSA(width, height, resX, resY, features |= 1, colorAlpha, texCoordsSize);
        return GeomFactory.createTAfromITSA(gcITSA);
    }

    public static Geometry createGeometry(float width, float height, int resX, int resY, int features, boolean colorAlpha, int texCoordsSize) {
        switch (Grid.getGeometryConstructionTypeHint()) {
            case INDEXED_TRIANGLE_STRIP_ARRAY: {
                return Grid.createGeometryITSA(width, height, resX, resY, features, colorAlpha, texCoordsSize);
            }
            case INDEXED_TRIANGLE_ARRAY: {
                return Grid.createGeometryITA(width, height, resX, resY, features, colorAlpha, texCoordsSize);
            }
            case TRIANGLE_STRIP_ARRAY: {
                return Grid.createGeometryTSA(width, height, resX, resY, features, colorAlpha, texCoordsSize);
            }
            case TRIANGLE_ARRAY: {
                return Grid.createGeometryTA(width, height, resX, resY, features, colorAlpha, texCoordsSize);
            }
        }
        throw new Error(Grid.getGeometryConstructionTypeHint().getCorrespondingClass().getSimpleName() + " creation is not yet implemented.");
    }

    public Grid(float width, float height, int resX, int resY, int features, boolean colorAlpha, int texCoordsSize) {
        super(Grid.createGeometry(width, height, resX, resY, features, colorAlpha, texCoordsSize));
    }

    public Grid(float width, float height, int resX, int resY, Texture texture) {
        this(width, height, resX, resY, 11, false, 2);
        this.getAppearance(true).setTexture(texture);
    }

    public Grid(float width, float height, int resX, int resY, String texture) {
        this(width, height, resX, resY, TextureLoader.getInstance().getTexture(texture));
    }

    public Grid(float width, float height, int resX, int resY, Colorf color) {
        this(width, height, resX, resY, 3, false, 2);
        this.getAppearance(true).getColoringAttributes(true).setColor(color);
        if (color.hasAlpha()) {
            this.getAppearance(true).getTransparencyAttributes(true).setTransparency(color.getAlpha());
        }
    }

    public Grid(float width, float height, int resX, int resY, Appearance app) {
        this(width, height, resX, resY, 3 | GeomFactory.getFeaturesFromAppearance(app), false, GeomFactory.getTexCoordsSize(app));
        this.setAppearance(app);
    }
}

