/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph.primitives;

import org.openmali.vecmath2.Colorf;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.StaticTransform;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.primitives.Cylinder;
import org.xith3d.scenegraph.primitives.GeomFactory;

public class Ring
extends Cylinder {
    public Ring(float alpha, int slices, int features, boolean colorAlpha, int texCoordsSize) {
        super(alpha, slices, features, colorAlpha, texCoordsSize);
        StaticTransform.scale(this, 1.0f, 0.0f, 1.0f);
    }

    public Ring(float radius, float alpha, int slices, int features, boolean colorAlpha, int texCoordsSize) {
        this(alpha, slices, features, colorAlpha, texCoordsSize);
        StaticTransform.scale(this, radius);
    }

    public Ring(float alpha, int slices, Texture texture) {
        this(alpha, slices, 11, false, 2);
        this.getAppearance(true).setTexture(texture);
    }

    public Ring(float radius, float alpha, int slices, Texture texture) {
        this(alpha, slices, texture);
        StaticTransform.scale(this, radius);
    }

    public Ring(float alpha, int slices, String texture) {
        this(alpha, slices, TextureLoader.getInstance().getTexture(texture));
    }

    public Ring(float radius, float alpha, int slices, String texture) {
        this(alpha, slices, texture);
        StaticTransform.scale(this, radius);
    }

    public Ring(float alpha, int slices, Colorf color) {
        this(alpha, slices, 3, false, 2);
        this.getAppearance(true).getColoringAttributes(true).setColor(color);
        if (color.hasAlpha()) {
            this.getAppearance(true).getTransparencyAttributes(true).setTransparency(color.getAlpha());
        }
    }

    public Ring(float radius, float alpha, int slices, Colorf color) {
        this(alpha, slices, color);
        StaticTransform.scale(this, radius);
    }

    public Ring(float alpha, int slices, Appearance app) {
        this(alpha, slices, 3 | GeomFactory.getFeaturesFromAppearance(app), false, GeomFactory.getTexCoordsSize(app));
        this.setAppearance(app);
    }

    public Ring(float radius, float alpha, int slices, Appearance app) {
        this(alpha, slices, app);
        StaticTransform.scale(this, radius);
    }
}

