/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph.primitives;

import org.jagatoo.opengl.enums.TextureFormat;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.render.BackgroundRenderPass;
import org.xith3d.render.BaseRenderPassConfig;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.GroupNode;
import org.xith3d.scenegraph.PolygonAttributes;
import org.xith3d.scenegraph.RenderingAttributes;
import org.xith3d.scenegraph.StaticTransform;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.View;
import org.xith3d.scenegraph.primitives.GeoSphere;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkyGeoHemisphere
extends BackgroundRenderPass {
    public static final int DEFAULT_SKY_SPLITS = 5;
    public static final float X_ROTATION = 4.712389f;

    private static Texture getTextureOrNull(String texture) {
        if (texture == null) {
            return null;
        }
        Texture2D tex = TextureLoader.getInstance().getTexture(texture, null, TextureFormat.RGB, Texture.MipmapMode.BASE_LEVEL, true, false, false);
        tex.enableAutoFreeLocalData();
        return tex;
    }

    public static <G extends GroupNode> G createSkyGeoHemisphereGroup(int frequency, Texture texture, G group) {
        GeoSphere hemisphere = new GeoSphere(5.0f, frequency, 9, false, 2, true);
        hemisphere.getGeometry().setOptimization(Geometry.Optimization.USE_DISPLAY_LISTS);
        StaticTransform.rotateX(hemisphere, 1.5707964f);
        StaticTransform.rotateZ(hemisphere, (float)Math.PI);
        Appearance appearance = hemisphere.getAppearance(true);
        RenderingAttributes renderingAttributes = new RenderingAttributes();
        renderingAttributes.setDepthBufferWriteEnabled(false);
        appearance.setRenderingAttributes(renderingAttributes);
        PolygonAttributes polygonAttributes = new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_FRONT);
        appearance.setPolygonAttributes(polygonAttributes);
        appearance.setTexture(texture);
        hemisphere.setAppearance(appearance);
        group.addChild(hemisphere);
        group.setPickableRecursive(false);
        return group;
    }

    public static BranchGroup createSkyGeoHemisphereGroup(int frequency, Texture texture) {
        return SkyGeoHemisphere.createSkyGeoHemisphereGroup(frequency, texture, new BranchGroup());
    }

    public static final BranchGroup createSkyGeoHemisphereGroup(int frequency, String textureName) {
        return SkyGeoHemisphere.createSkyGeoHemisphereGroup(frequency, SkyGeoHemisphere.getTextureOrNull(textureName));
    }

    public static final BranchGroup createSkyGeoHemisphereGroup(Texture texture) {
        return SkyGeoHemisphere.createSkyGeoHemisphereGroup(5, texture);
    }

    public static final BranchGroup createSkyGeoHemisphereGroup(String textureName) {
        return SkyGeoHemisphere.createSkyGeoHemisphereGroup(5, textureName);
    }

    public SkyGeoHemisphere(int frequency, Texture texture) {
        super(SkyGeoHemisphere.createSkyGeoHemisphereGroup(frequency, texture), new BaseRenderPassConfig(View.CameraMode.VIEW_FIXED_POSITION));
    }

    public SkyGeoHemisphere(int frequency, String textureName) {
        this(frequency, SkyGeoHemisphere.getTextureOrNull(textureName));
    }

    public SkyGeoHemisphere(Texture texture) {
        this(5, texture);
    }

    public SkyGeoHemisphere(String textureName) {
        this(5, textureName);
    }
}

