/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph.primitives;

import java.awt.Font;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Matrix3f;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.loaders.texture.TextureCreator;
import org.xith3d.scenegraph.Billboard;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.primitives.Rectangle;
import org.xith3d.scenegraph.primitives.TextRectangle;

public class TextBillboard
extends TextRectangle
implements Billboard {
    private long lastFrameId = -9223372036854775807L;
    protected Tuple3f[] zeroVertices;
    protected Point3f[] transformedVertices = new Point3f[]{new Point3f(), new Point3f(), new Point3f(), new Point3f()};

    public void updateOriginalVertexCoordinates() {
        this.getGeometry().getCoordinates(0, this.zeroVertices);
    }

    public Sized2iRO getSizeOnScreen() {
        return null;
    }

    public void updateFaceToCamera(Matrix3f viewRotation, long frameId, long nanoTime, long nanoStep) {
        if (frameId <= this.lastFrameId) {
            return;
        }
        for (int i = 0; i < 4; ++i) {
            this.transformedVertices[i].set((TupleNf)this.zeroVertices[i]);
            viewRotation.transform((Tuple3f)this.transformedVertices[i]);
        }
        this.getGeometry().setCoordinates(0, (Tuple3f[])this.transformedVertices);
        this.lastFrameId = frameId;
    }

    protected TextBillboard(float width, float height, Tuple3f position, Texture texture) {
        super(width, height, position, texture);
        this.zeroVertices = TextBillboard.createVertexCoords(width, height, position);
        this.getGeometry().setOptimization(Geometry.Optimization.NONE);
    }

    protected TextBillboard(float width, float height, Rectangle.ZeroPointLocation zpl, float zOffset, Texture texture) {
        super(width, height, zpl, zOffset, texture);
        this.zeroVertices = TextBillboard.createVertexCoords(width, height, TextBillboard.createPosition(width, height, zpl, zOffset, new Vector3f()));
        this.getGeometry().setOptimization(Geometry.Optimization.NONE);
    }

    public static TextBillboard createFixedWidth(float width, Tuple3f position, String text, Colorf color, Font font, int alignment) {
        Texture2D texture = TextureCreator.createTexture(text, color, font, alignment);
        float height = TextBillboard.getHeightFromFixedWidth(width, texture);
        TextBillboard rect = new TextBillboard(width, height, position, (Texture)texture);
        return rect;
    }

    public static TextBillboard createFixedWidth(float width, float zOffset, String text, Colorf color, Font font, int alignment) {
        Texture2D texture = TextureCreator.createTexture(text, color, font, alignment);
        float height = TextBillboard.getHeightFromFixedWidth(width, texture);
        TextBillboard rect = new TextBillboard(width, height, (Tuple3f)new Vector3f(0.0f, 0.0f, zOffset), (Texture)texture);
        return rect;
    }

    public static TextBillboard createFixedWidth(float width, String text, Colorf color, Font font, int alignment) {
        Texture2D texture = TextureCreator.createTexture(text, color, font, alignment);
        float height = TextBillboard.getHeightFromFixedWidth(width, texture);
        TextBillboard rect = new TextBillboard(width, height, (Tuple3f)null, (Texture)texture);
        return rect;
    }

    public static TextBillboard createFixedWidth(float width, Rectangle.ZeroPointLocation zpl, float zOffset, String text, Colorf color, Font font, int alignment) {
        Texture2D texture = TextureCreator.createTexture(text, color, font, alignment);
        float height = TextBillboard.getHeightFromFixedWidth(width, texture);
        return new TextBillboard(width, height, zpl, zOffset, (Texture)texture);
    }

    public static TextBillboard createFixedWidth(float width, Rectangle.ZeroPointLocation zpl, String text, Colorf color, Font font, int alignment) {
        Texture2D texture = TextureCreator.createTexture(text, color, font, alignment);
        float height = TextBillboard.getHeightFromFixedWidth(width, texture);
        return new TextBillboard(width, height, zpl, 0.0f, (Texture)texture);
    }

    public static TextBillboard createFixedWidth(float width, Tuple3f position, String text, Colorf color, Font font) {
        Texture2D texture = TextureCreator.createTexture(text, color, font, 0);
        float height = TextBillboard.getHeightFromFixedWidth(width, texture);
        TextBillboard rect = new TextBillboard(width, height, position, (Texture)texture);
        return rect;
    }

    public static TextBillboard createFixedWidth(float width, float zOffset, String text, Colorf color, Font font) {
        Texture2D texture = TextureCreator.createTexture(text, color, font, 0);
        float height = TextBillboard.getHeightFromFixedWidth(width, texture);
        TextBillboard rect = new TextBillboard(width, height, (Tuple3f)new Vector3f(0.0f, 0.0f, zOffset), (Texture)texture);
        return rect;
    }

    public static TextBillboard createFixedWidth(float width, String text, Colorf color, Font font) {
        Texture2D texture = TextureCreator.createTexture(text, color, font, 0);
        float height = TextBillboard.getHeightFromFixedWidth(width, texture);
        TextBillboard rect = new TextBillboard(width, height, (Tuple3f)null, (Texture)texture);
        return rect;
    }

    public static TextBillboard createFixedWidth(float width, Rectangle.ZeroPointLocation zpl, float zOffset, String text, Colorf color, Font font) {
        Texture2D texture = TextureCreator.createTexture(text, color, font, 0);
        float height = TextBillboard.getHeightFromFixedWidth(width, texture);
        return new TextBillboard(width, height, zpl, zOffset, (Texture)texture);
    }

    public static TextBillboard createFixedWidth(float width, Rectangle.ZeroPointLocation zpl, String text, Colorf color, Font font) {
        Texture2D texture = TextureCreator.createTexture(text, color, font, 0);
        float height = TextBillboard.getHeightFromFixedWidth(width, texture);
        return new TextBillboard(width, height, zpl, 0.0f, (Texture)texture);
    }

    public static TextBillboard createFixedHeight(float height, Tuple3f position, String text, Colorf color, Font font, int alignment) {
        Texture2D texture = TextureCreator.createTexture(text, color, font, alignment);
        float width = TextBillboard.getWidthFromFixedHeight(height, texture);
        return new TextBillboard(width, height, position, (Texture)texture);
    }

    public static TextBillboard createFixedHeight(float height, float zOffset, String text, Colorf color, Font font, int alignment) {
        Texture2D texture = TextureCreator.createTexture(text, color, font, alignment);
        float width = TextBillboard.getWidthFromFixedHeight(height, texture);
        return new TextBillboard(width, height, (Tuple3f)new Vector3f(0.0f, 0.0f, zOffset), (Texture)texture);
    }

    public static TextBillboard createFixedHeight(float height, String text, Colorf color, Font font, int alignment) {
        Texture2D texture = TextureCreator.createTexture(text, color, font, alignment);
        float width = TextBillboard.getWidthFromFixedHeight(height, texture);
        return new TextBillboard(width, height, (Tuple3f)null, (Texture)texture);
    }

    public static TextBillboard createFixedHeight(float height, Rectangle.ZeroPointLocation zpl, float zOffset, String text, Colorf color, Font font, int alignment) {
        Texture2D texture = TextureCreator.createTexture(text, color, font, alignment);
        float width = TextBillboard.getWidthFromFixedHeight(height, texture);
        return new TextBillboard(width, height, zpl, zOffset, (Texture)texture);
    }

    public static TextBillboard createFixedHeight(float height, Rectangle.ZeroPointLocation zpl, String text, Colorf color, Font font, int alignment) {
        Texture2D texture = TextureCreator.createTexture(text, color, font, alignment);
        float width = TextBillboard.getWidthFromFixedHeight(height, texture);
        return new TextBillboard(width, height, zpl, 0.0f, (Texture)texture);
    }

    public static TextBillboard createFixedHeight(float height, Tuple3f position, String text, Colorf color, Font font) {
        Texture2D texture = TextureCreator.createTexture(text, color, font, 0);
        float width = TextBillboard.getWidthFromFixedHeight(height, texture);
        return new TextBillboard(width, height, position, (Texture)texture);
    }

    public static TextBillboard createFixedHeight(float height, float zOffset, String text, Colorf color, Font font) {
        Texture2D texture = TextureCreator.createTexture(text, color, font, 0);
        float width = TextBillboard.getWidthFromFixedHeight(height, texture);
        return new TextBillboard(width, height, (Tuple3f)new Vector3f(0.0f, 0.0f, zOffset), (Texture)texture);
    }

    public static TextBillboard createFixedHeight(float height, String text, Colorf color, Font font) {
        Texture2D texture = TextureCreator.createTexture(text, color, font, 0);
        float width = TextBillboard.getWidthFromFixedHeight(height, texture);
        return new TextBillboard(width, height, (Tuple3f)null, (Texture)texture);
    }

    public static TextBillboard createFixedHeight(float height, Rectangle.ZeroPointLocation zpl, float zOffset, String text, Colorf color, Font font) {
        Texture2D texture = TextureCreator.createTexture(text, color, font, 0);
        float width = TextBillboard.getWidthFromFixedHeight(height, texture);
        return new TextBillboard(width, height, zpl, zOffset, (Texture)texture);
    }

    public static TextBillboard createFixedHeight(float height, Rectangle.ZeroPointLocation zpl, String text, Colorf color, Font font) {
        Texture2D texture = TextureCreator.createTexture(text, color, font, 0);
        float width = TextBillboard.getWidthFromFixedHeight(height, texture);
        return new TextBillboard(width, height, zpl, 0.0f, (Texture)texture);
    }
}

