/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph.traversal.impl;

import java.util.ArrayList;
import java.util.List;
import org.xith3d.scenegraph.GroupNode;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.traversal.TraversalCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ShapeFinder
implements TraversalCallback {
    private Shape3D shape;
    private List<Shape3D> shapes;
    private boolean isSearchModeAll;

    @Override
    public boolean traversalCheckGroup(GroupNode group) {
        return this.shape == null;
    }

    @Override
    public boolean traversalOperation(Node node) {
        if (node instanceof Shape3D) {
            if (!this.isSearchModeAll) {
                this.shape = (Shape3D)node;
                return false;
            }
            this.shapes.add((Shape3D)node);
        }
        return true;
    }

    private ShapeFinder(boolean isSearchModeAll) {
        this.isSearchModeAll = isSearchModeAll;
        if (isSearchModeAll) {
            this.shapes = new ArrayList<Shape3D>();
        } else {
            this.shape = null;
        }
    }

    public static Shape3D findFirstShape(GroupNode group) {
        ShapeFinder sf = new ShapeFinder(false);
        group.traverse(sf);
        return sf.shape;
    }

    public static List<Shape3D> findAllShapes(GroupNode group) {
        ShapeFinder sf = new ShapeFinder(true);
        group.traverse(sf);
        return sf.shapes;
    }
}

