/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph.utils;

import java.util.concurrent.ConcurrentLinkedQueue;
import org.xith3d.utility.logging.X3DLog;

public class LODWorkerThread
extends Thread {
    private static final LODWorkerThread instance = new LODWorkerThread();
    private boolean shutDown = false;
    private volatile boolean waiting = false;
    private final ConcurrentLinkedQueue<Runnable> queue = new ConcurrentLinkedQueue();

    public boolean cancel(Runnable job) {
        return this.queue.remove(job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(Runnable job) {
        this.queue.add(job);
        if (this.waiting) {
            ConcurrentLinkedQueue<Runnable> concurrentLinkedQueue = this.queue;
            synchronized (concurrentLinkedQueue) {
                this.queue.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDown() {
        ConcurrentLinkedQueue<Runnable> concurrentLinkedQueue = this.queue;
        synchronized (concurrentLinkedQueue) {
            this.shutDown = true;
            this.queue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            ConcurrentLinkedQueue<Runnable> concurrentLinkedQueue = this.queue;
            synchronized (concurrentLinkedQueue) {
                if (this.shutDown) {
                    break;
                }
                try {
                    if (this.queue.isEmpty()) {
                        this.waiting = true;
                        this.queue.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            try {
                Runnable runnable = this.queue.poll();
                runnable.run();
            }
            catch (Throwable t) {
                X3DLog.print(t);
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static LODWorkerThread getInstance() {
        return instance;
    }

    protected LODWorkerThread() {
        super("Xith LOD worker thread");
        this.setPriority(1);
        this.start();
    }
}

