/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.schedops.movement;

import org.openmali.FastMath;
import org.openmali.vecmath2.Matrix3f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.Vector3f;
import org.openmali.vecmath2.util.MatrixUtils;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.scenegraph.Transformable;
import org.xith3d.schedops.movement.GroupAnimator;
import org.xith3d.schedops.movement.TransformationDirectives;
import org.xith3d.utility.interpolate.AngleInterpolater;

public class GroupRotator
extends GroupAnimator {
    private AngleInterpolater angleX;
    private AngleInterpolater angleY;
    private AngleInterpolater angleZ;
    private AngleInterpolater angleU;
    private final Matrix3f rotMatX = new Matrix3f();
    private final Matrix3f rotMatY = new Matrix3f();
    private final Matrix3f rotMatZ = new Matrix3f();
    private final Matrix3f rotMat = new Matrix3f();

    protected AngleInterpolater getAngleInterpolater(TransformationDirectives.Axes axis) {
        if (axis == null) {
            return this.angleU;
        }
        switch (axis) {
            case X_AXIS: {
                return this.angleX;
            }
            case Y_AXIS: {
                return this.angleY;
            }
            case Z_AXIS: {
                return this.angleZ;
            }
        }
        return null;
    }

    protected float getRotationValue(TransformationDirectives.Axes axis, long gameMicros) {
        return this.getAngleInterpolater(axis).getValue(gameMicros);
    }

    public void startAnimation(long gameTime, UpdatingThread.TimingMode timingMode) {
        long micros = timingMode.getMicroSeconds(gameTime);
        if (this.getTransformationDirectives().getUserAxis() == null) {
            this.angleX.startIncreasing(micros);
            this.angleY.startIncreasing(micros);
            this.angleZ.startIncreasing(micros);
        } else {
            this.angleU.startIncreasing(micros);
        }
        super.startAnimation(gameTime, timingMode);
    }

    public void stopAnimation() {
        if (this.getTransformationDirectives().getUserAxis() == null) {
            this.angleX.stop();
            this.angleY.stop();
            this.angleZ.stop();
        } else {
            this.angleU.stop();
        }
        super.stopAnimation();
    }

    public boolean animate(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        if (!this.isAnimating() || this.getNumTransformNodes() == 0) {
            return false;
        }
        long micros = timingMode.getMicroSeconds(gameTime);
        if (this.getTransformationDirectives().isDirty()) {
            this.setTransformationDirectives(this.getTransformationDirectives());
        }
        Matrix3f rotMat = null;
        if (this.getTransformationDirectives().getUserAxis() == null) {
            float x = this.angleX.getValue(micros);
            float y = this.angleY.getValue(micros);
            float z = this.angleZ.getValue(micros);
            float sin_x = FastMath.sin((float)x);
            float cos_x = FastMath.cos((float)x);
            float sin_y = FastMath.sin((float)y);
            float cos_y = FastMath.cos((float)y);
            float sin_z = FastMath.sin((float)z);
            float cos_z = FastMath.cos((float)z);
            this.rotMatX.set(1.0f, 0.0f, 0.0f, 0.0f, cos_x, -sin_x, 0.0f, sin_x, cos_x);
            this.rotMatY.set(cos_y, 0.0f, sin_y, 0.0f, 1.0f, 0.0f, -sin_y, 0.0f, cos_y);
            this.rotMatZ.set(cos_z, -sin_z, 0.0f, sin_z, cos_z, 0.0f, 0.0f, 0.0f, 1.0f);
            switch (this.getTransformationDirectives().getAxisOrder()) {
                case XYZ: {
                    this.rotMatX.mul(this.rotMatY);
                    this.rotMatX.mul(this.rotMatZ);
                    rotMat = this.rotMatX;
                    break;
                }
                case XZY: {
                    this.rotMatX.mul(this.rotMatZ);
                    this.rotMatX.mul(this.rotMatY);
                    rotMat = this.rotMatX;
                    break;
                }
                case YXZ: {
                    this.rotMatY.mul(this.rotMatX);
                    this.rotMatY.mul(this.rotMatZ);
                    rotMat = this.rotMatY;
                    break;
                }
                case YZX: {
                    this.rotMatY.mul(this.rotMatZ);
                    this.rotMatY.mul(this.rotMatY);
                    rotMat = this.rotMatY;
                    break;
                }
                case ZXY: {
                    this.rotMatZ.mul(this.rotMatX);
                    this.rotMatZ.mul(this.rotMatY);
                    rotMat = this.rotMatZ;
                    break;
                }
                case ZYX: {
                    this.rotMatZ.mul(this.rotMatY);
                    this.rotMatZ.mul(this.rotMatX);
                    rotMat = this.rotMatZ;
                }
            }
        } else {
            Vector3f axis = this.getTransformationDirectives().getUserAxis();
            float angle = this.angleU.getValue(micros);
            rotMat = this.rotMat;
            MatrixUtils.getRotationMatrix((Tuple3f)axis, (float)angle, (Matrix3f)rotMat);
        }
        this.t3dMain.setRotation(rotMat);
        this.setTransform(this.t3dMain);
        return true;
    }

    public void setTransformationDirectives(TransformationDirectives rotDirecs) {
        if (rotDirecs == null) {
            return;
        }
        if (rotDirecs.getUserAxis() == null) {
            if (this.angleX != null) {
                this.angleX.setValue(rotDirecs.getInitValueX() * ((float)Math.PI * 2));
                this.angleX.setSpeed(rotDirecs.getSpeedX() * ((float)Math.PI * 2));
            } else {
                this.angleX = new AngleInterpolater(rotDirecs.getInitValueX() * ((float)Math.PI * 2), rotDirecs.getSpeedX() * ((float)Math.PI * 2), 0.0f, (float)Math.PI * 2, true);
            }
            if (this.angleY != null) {
                this.angleY.setValue(rotDirecs.getInitValueY() * ((float)Math.PI * 2));
                this.angleY.setSpeed(rotDirecs.getSpeedY() * ((float)Math.PI * 2));
            } else {
                this.angleY = new AngleInterpolater(rotDirecs.getInitValueY() * ((float)Math.PI * 2), rotDirecs.getSpeedY() * ((float)Math.PI * 2), 0.0f, (float)Math.PI * 2, true);
            }
            if (this.angleZ != null) {
                this.angleZ.setValue(rotDirecs.getInitValueZ() * ((float)Math.PI * 2));
                this.angleZ.setSpeed(rotDirecs.getSpeedZ() * ((float)Math.PI * 2));
            } else {
                this.angleZ = new AngleInterpolater(rotDirecs.getInitValueZ() * ((float)Math.PI * 2), rotDirecs.getSpeedZ() * ((float)Math.PI * 2), 0.0f, (float)Math.PI * 2, true);
            }
            this.angleU = null;
        } else {
            this.angleX = null;
            this.angleY = null;
            this.angleZ = null;
            if (this.angleU != null) {
                this.angleU.setValue(rotDirecs.getInitValueUser() * ((float)Math.PI * 2));
                this.angleU.setSpeed(rotDirecs.getSpeedUser() * ((float)Math.PI * 2));
            } else {
                this.angleU = new AngleInterpolater(rotDirecs.getInitValueUser() * ((float)Math.PI * 2), rotDirecs.getSpeedUser() * ((float)Math.PI * 2), 0.0f, (float)Math.PI * 2, true);
            }
        }
        super.setTransformationDirectives(rotDirecs);
        rotDirecs.setClean();
    }

    public GroupRotator(Transformable tn, TransformationDirectives rotDirecs) {
        super(tn, rotDirecs);
    }

    public GroupRotator(TransformationDirectives rotDirecs) {
        super(rotDirecs);
    }

    public GroupRotator(Transformable tn) {
        this(tn, new TransformationDirectives());
    }
}

