/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.schedops.movement;

import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.scenegraph.Transformable;
import org.xith3d.schedops.movement.GroupAnimator;
import org.xith3d.schedops.movement.TransformationDirectives;
import org.xith3d.utility.interpolate.DistanceInterpolater;

public class GroupTranslator
extends GroupAnimator {
    private DistanceInterpolater distX;
    private DistanceInterpolater distY;
    private DistanceInterpolater distZ;
    private DistanceInterpolater distU;
    private Vector3f transVec = new Vector3f();

    protected DistanceInterpolater getDistanceInterpolater(TransformationDirectives.Axes axis) {
        if (axis == null) {
            return this.distU;
        }
        switch (axis) {
            case X_AXIS: {
                return this.distX;
            }
            case Y_AXIS: {
                return this.distY;
            }
            case Z_AXIS: {
                return this.distZ;
            }
        }
        return null;
    }

    protected float getTranslationValue(TransformationDirectives.Axes axis, long gameMicros) {
        return this.getDistanceInterpolater(axis).getValue(gameMicros);
    }

    public void startAnimation(long gameTime, UpdatingThread.TimingMode timingMode) {
        long micros = timingMode.getMicroSeconds(gameTime);
        if (this.getTransformationDirectives().getUserAxis() == null) {
            this.distX.startIncreasing(micros);
            this.distY.startIncreasing(micros);
            this.distZ.startIncreasing(micros);
        } else {
            this.distU.startIncreasing(micros);
        }
        super.startAnimation(gameTime, timingMode);
    }

    public void stopAnimation() {
        if (this.getTransformationDirectives().getUserAxis() == null) {
            this.distX.stop();
            this.distY.stop();
            this.distZ.stop();
        } else {
            this.distU.stop();
        }
        super.stopAnimation();
    }

    public boolean animate(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        if (!this.isAnimating() || this.getNumTransformNodes() == 0) {
            return false;
        }
        long micros = timingMode.getMicroSeconds(gameTime);
        if (this.getTransformationDirectives().isDirty()) {
            this.setTransformationDirectives(this.getTransformationDirectives());
        }
        if (this.getTransformationDirectives().getUserAxis() == null) {
            this.transVec.setX(this.distX.getValue(micros));
            this.transVec.setY(this.distY.getValue(micros));
            this.transVec.setZ(this.distZ.getValue(micros));
        } else {
            this.transVec.set((TupleNf)this.getTransformationDirectives().getUserAxis());
            this.transVec.scale(this.distU.getValue(micros));
        }
        this.t3dMain.setTranslation((Tuple3f)this.transVec);
        this.setTransform(this.t3dMain);
        return true;
    }

    public void setTransformationDirectives(TransformationDirectives transDirecs) {
        if (transDirecs == null) {
            return;
        }
        if (transDirecs.getUserAxis() == null) {
            if (this.distX != null) {
                this.distX.setValue(transDirecs.getInitValueX());
                this.distX.setSpeed(transDirecs.getSpeedX());
            } else {
                this.distX = new DistanceInterpolater(transDirecs.getInitValueX(), transDirecs.getSpeedX(), 0.0f, Float.MAX_VALUE);
            }
            if (this.distY != null) {
                this.distY.setValue(transDirecs.getInitValueY());
                this.distY.setSpeed(transDirecs.getSpeedY());
            } else {
                this.distY = new DistanceInterpolater(transDirecs.getInitValueY(), transDirecs.getSpeedY(), 0.0f, Float.MAX_VALUE);
            }
            if (this.distZ != null) {
                this.distZ.setValue(transDirecs.getInitValueZ());
                this.distZ.setSpeed(transDirecs.getSpeedZ());
            } else {
                this.distZ = new DistanceInterpolater(transDirecs.getInitValueZ(), transDirecs.getSpeedZ(), 0.0f, Float.MAX_VALUE);
            }
            this.distU = null;
        } else {
            this.distX = null;
            this.distY = null;
            this.distZ = null;
            if (this.distU != null) {
                this.distU.setValue(transDirecs.getInitValueUser());
                this.distU.setSpeed(transDirecs.getSpeedUser());
            } else {
                this.distU = new DistanceInterpolater(transDirecs.getInitValueUser(), transDirecs.getSpeedUser(), 0.0f, Float.MAX_VALUE);
            }
        }
        super.setTransformationDirectives(transDirecs);
        transDirecs.setClean();
    }

    public GroupTranslator(Transformable tn, TransformationDirectives transDirecs) {
        super(tn, transDirecs);
    }

    public GroupTranslator(TransformationDirectives transDirecs) {
        super(transDirecs);
    }

    public GroupTranslator(Transformable tn) {
        this(tn, new TransformationDirectives());
    }
}

