/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.schedops.values;

import org.jagatoo.input.devices.Keyboard;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.devices.components.Keys;
import org.openmali.vecmath2.Point3f;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.schedops.values.Adjuster;

public class KeyPoint3fAdjuster
extends Adjuster {
    private Point3f data;
    private Key ADD_KEY;
    private Key SUB_KEY;
    private Key PRINT_KEY;
    private boolean ADD_PRESSED;
    private boolean SUB_PRESSED;
    private float speed;
    private Adjuster.Mode mode;
    private Axis axis;
    private Keyboard keyboard;

    public KeyPoint3fAdjuster(String name, Point3f data, Axis axis, float delta, Adjuster.Mode mode, Keyboard keyboard) {
        this(name, data, axis, delta, mode, keyboard, Keys.NUMPAD_ADD, Keys.NUMPAD_SUBTRACT, Keys.NUMPAD_ENTER);
    }

    public KeyPoint3fAdjuster(String name, Point3f data, Axis axis, float delta, Adjuster.Mode mode, Keyboard keyboard, Key ADD_KEY, Key SUB_KEY, Key PRINT_KEY) {
        this.name = name;
        this.data = data;
        this.axis = axis;
        this.speed = delta;
        this.mode = mode;
        this.keyboard = keyboard;
        this.ADD_KEY = ADD_KEY;
        this.SUB_KEY = SUB_KEY;
        this.PRINT_KEY = PRINT_KEY;
    }

    public void update(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        this.changed = false;
        float delta = (float)timingMode.getMilliSeconds(frameTime) / 1000.0f * this.speed;
        if (this.keyboard.isKeyPressed(this.PRINT_KEY)) {
            this.getState();
        }
        switch (this.mode) {
            case SEQUENTIAL: {
                if (this.ADD_PRESSED) {
                    if (!this.keyboard.isKeyPressed(this.ADD_KEY)) {
                        this.add(delta);
                        this.changed = true;
                        this.ADD_PRESSED = false;
                    }
                } else if (!this.keyboard.isKeyPressed(this.ADD_KEY)) {
                    this.ADD_PRESSED = true;
                }
                if (this.SUB_PRESSED) {
                    if (this.keyboard.isKeyPressed(this.SUB_KEY)) break;
                    this.add(delta);
                    this.changed = true;
                    this.SUB_PRESSED = false;
                    break;
                }
                if (this.keyboard.isKeyPressed(this.SUB_KEY)) break;
                this.SUB_PRESSED = true;
                break;
            }
            case CONTINUOUS: {
                if (this.keyboard.isKeyPressed(this.ADD_KEY)) {
                    this.add(delta);
                    this.changed = true;
                }
                if (!this.keyboard.isKeyPressed(this.SUB_KEY)) break;
                this.sub(delta);
                this.changed = true;
                break;
            }
        }
    }

    private void sub(float delta) {
        switch (this.axis) {
            case X: {
                this.data.subX(delta);
                break;
            }
            case Y: {
                this.data.subY(delta);
                break;
            }
            case Z: {
                this.data.subZ(delta);
                break;
            }
        }
    }

    private void add(float delta) {
        switch (this.axis) {
            case X: {
                this.data.addX(delta);
                break;
            }
            case Y: {
                this.data.addY(delta);
                break;
            }
            case Z: {
                this.data.addZ(delta);
                break;
            }
        }
    }

    public String getState() {
        return this.data.toString();
    }

    public void setAxis(Axis axis) {
        this.axis = axis;
    }

    public float getSpeed() {
        return this.speed;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Axis {
        X,
        Y,
        Z;

    }
}

