/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.selection;

import org.openmali.spatial.bounds.Bounds;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.scenegraph.Group;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.StaticTransform;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.primitives.Cone;
import org.xith3d.scenegraph.primitives.Line;
import org.xith3d.selection.AbstractNodeSelectable;
import org.xith3d.selection.SelectionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoundingBoxSelectable<NodeType extends Node>
extends AbstractNodeSelectable<NodeType> {
    private TransformGroup group;

    @Override
    public void setSelected(SelectionManager selectionManager, boolean selected) {
        super.setSelected(selectionManager, selected);
        Object node = this.getNode();
        if (selected && this.group == null) {
            Tuple3f center = Tuple3f.fromPool();
            Bounds bounds = ((Node)node).getBounds();
            bounds.getCenter(center);
            float radius = bounds.getMaxCenterDistance();
            this.group = new TransformGroup(((Node)node).getWorldTransform());
            this.group.addChild(this.createBox(radius));
            this.group.addChild(this.createCoordinateSystem(radius));
            ((Node)node).getRoot().addChild(this.group);
            Tuple3f.toPool((Tuple3f)center);
        } else if (this.group != null) {
            ((Node)node).getRoot().removeChild(this.group);
            this.group = null;
        }
    }

    @Override
    public void onMoved(SelectionManager selectionManager, Vector3f delta) {
        TransformGroup tg = ((Node)this.getNode()).getTransformGroup();
        if (tg != null) {
            Vector3f trans = (Vector3f)tg.getTransform().getTranslation().add((TupleNf)delta);
            tg.getTransform().setTranslation((Tuple3f)trans);
            tg.updateTransform();
            tg.getTransform().setTranslation((Tuple3f)trans);
            tg.updateTransform();
        }
        this.group.setTransform(((Node)this.getNode()).getWorldTransform());
    }

    private Group createBox(float r) {
        Group box = new Group();
        float ou = r;
        float in = 0.8f * r;
        float lw = 4.0f;
        Colorf col = Colorf.BLUE;
        Line[] lines = new Line[]{new Line(new Tuple3f(-ou, ou, ou), new Tuple3f(-in, ou, ou), lw, col), new Line(new Tuple3f(ou, ou, ou), new Tuple3f(in, ou, ou), lw, col), new Line(new Tuple3f(-ou, ou, ou), new Tuple3f(-ou, in, ou), lw, col), new Line(new Tuple3f(ou, ou, ou), new Tuple3f(ou, in, ou), lw, col), new Line(new Tuple3f(-ou, -ou, ou), new Tuple3f(-in, -ou, ou), lw, col), new Line(new Tuple3f(ou, -ou, ou), new Tuple3f(in, -ou, ou), lw, col), new Line(new Tuple3f(-ou, -ou, ou), new Tuple3f(-ou, -in, ou), lw, col), new Line(new Tuple3f(ou, -ou, ou), new Tuple3f(ou, -in, ou), lw, col), new Line(new Tuple3f(-ou, ou, -ou), new Tuple3f(-in, ou, -ou), lw, col), new Line(new Tuple3f(ou, ou, -ou), new Tuple3f(in, ou, -ou), lw, col), new Line(new Tuple3f(-ou, ou, -ou), new Tuple3f(-ou, in, -ou), lw, col), new Line(new Tuple3f(ou, ou, -ou), new Tuple3f(ou, in, -ou), lw, col), new Line(new Tuple3f(-ou, -ou, -ou), new Tuple3f(-in, -ou, -ou), lw, col), new Line(new Tuple3f(ou, -ou, -ou), new Tuple3f(in, -ou, -ou), lw, col), new Line(new Tuple3f(-ou, -ou, -ou), new Tuple3f(-ou, -in, -ou), lw, col), new Line(new Tuple3f(ou, -ou, -ou), new Tuple3f(ou, -in, -ou), lw, col), new Line(new Tuple3f(ou, -ou, ou), new Tuple3f(ou, -in, ou), lw, col), new Line(new Tuple3f(ou, ou, ou), new Tuple3f(ou, in, ou), lw, col), new Line(new Tuple3f(ou, -ou, ou), new Tuple3f(ou, -ou, in), lw, col), new Line(new Tuple3f(ou, ou, ou), new Tuple3f(ou, ou, in), lw, col), new Line(new Tuple3f(ou, -ou, -ou), new Tuple3f(ou, -in, -ou), lw, col), new Line(new Tuple3f(ou, ou, -ou), new Tuple3f(ou, in, -ou), lw, col), new Line(new Tuple3f(ou, -ou, -ou), new Tuple3f(ou, -ou, -in), lw, col), new Line(new Tuple3f(ou, ou, -ou), new Tuple3f(ou, ou, -in), lw, col), new Line(new Tuple3f(-ou, -ou, ou), new Tuple3f(-ou, -in, ou), lw, col), new Line(new Tuple3f(-ou, ou, ou), new Tuple3f(-ou, in, ou), lw, col), new Line(new Tuple3f(-ou, -ou, ou), new Tuple3f(-ou, -ou, in), lw, col), new Line(new Tuple3f(-ou, ou, ou), new Tuple3f(-ou, ou, in), lw, col), new Line(new Tuple3f(-ou, -ou, -ou), new Tuple3f(-ou, -in, -ou), lw, col), new Line(new Tuple3f(-ou, ou, -ou), new Tuple3f(-ou, in, -ou), lw, col), new Line(new Tuple3f(-ou, -ou, -ou), new Tuple3f(-ou, -ou, -in), lw, col), new Line(new Tuple3f(-ou, ou, -ou), new Tuple3f(-ou, ou, -in), lw, col), new Line(new Tuple3f(-ou, ou, ou), new Tuple3f(-in, ou, ou), lw, col), new Line(new Tuple3f(ou, ou, ou), new Tuple3f(in, ou, ou), lw, col), new Line(new Tuple3f(-ou, ou, ou), new Tuple3f(-ou, ou, in), lw, col), new Line(new Tuple3f(ou, ou, ou), new Tuple3f(ou, ou, in), lw, col), new Line(new Tuple3f(-ou, ou, -ou), new Tuple3f(-in, ou, -ou), lw, col), new Line(new Tuple3f(ou, ou, -ou), new Tuple3f(in, ou, -ou), lw, col), new Line(new Tuple3f(-ou, ou, -ou), new Tuple3f(-ou, ou, -in), lw, col), new Line(new Tuple3f(ou, ou, -ou), new Tuple3f(ou, ou, -in), lw, col), new Line(new Tuple3f(-ou, -ou, ou), new Tuple3f(-in, -ou, ou), lw, col), new Line(new Tuple3f(ou, -ou, ou), new Tuple3f(in, -ou, ou), lw, col), new Line(new Tuple3f(-ou, -ou, ou), new Tuple3f(-ou, -ou, in), lw, col), new Line(new Tuple3f(ou, -ou, ou), new Tuple3f(ou, -ou, in), lw, col), new Line(new Tuple3f(-ou, -ou, -ou), new Tuple3f(-in, -ou, -ou), lw, col), new Line(new Tuple3f(ou, -ou, -ou), new Tuple3f(in, -ou, -ou), lw, col), new Line(new Tuple3f(-ou, -ou, -ou), new Tuple3f(-ou, -ou, -in), lw, col), new Line(new Tuple3f(ou, -ou, -ou), new Tuple3f(ou, -ou, -in), lw, col)};
        for (int i = 0; i < lines.length; ++i) {
            box.addChild(lines[i]);
        }
        return box;
    }

    private Group createCoordinateSystem(float r) {
        Group coords = new Group();
        Colorf col = Colorf.GREEN;
        float lw = 2.0f;
        Line[] lines = new Line[]{new Line(new Tuple3f(r, 0.0f, 0.0f), 2.0f, col), new Line(new Tuple3f(0.0f, r, 0.0f), 2.0f, col), new Line(new Tuple3f(0.0f, 0.0f, r), 2.0f, col)};
        for (int i = 0; i < lines.length; ++i) {
            coords.addChild(lines[i]);
        }
        Cone cone = new Cone(r / 10.0f, r / 3.0f, 10, col);
        StaticTransform.rotateZ(cone, -1.5707964f);
        StaticTransform.translate(cone, r, 0.0f, 0.0f);
        coords.addChild(cone);
        cone = new Cone(r / 10.0f, r / 3.0f, 10, col);
        StaticTransform.translate(cone, 0.0f, r, 0.0f);
        coords.addChild(cone);
        cone = new Cone(r / 10.0f, r / 3.0f, 10, col);
        StaticTransform.rotateX(cone, 1.5707964f);
        StaticTransform.translate(cone, 0.0f, 0.0f, r);
        coords.addChild(cone);
        return coords;
    }

    public BoundingBoxSelectable(NodeType node) {
        super(node);
    }
}

