/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.sound.drivers.javasound;

import java.nio.ByteBuffer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import org.xith3d.sound.BufferFormat;
import org.xith3d.sound.SoundBuffer;
import org.xith3d.sound.drivers.javasound.SoundDriverImpl;
import org.xith3d.utility.logging.X3DLog;

public class SoundBufferImpl
implements SoundBuffer {
    private DataLine.Info info;
    protected AudioFormat af;
    protected byte[] data;
    protected int size;

    public SoundBufferImpl(SoundDriverImpl driver) {
    }

    public void setData(BufferFormat format, int size, int frequency, ByteBuffer data) {
        X3DLog.debug(new Object[]{"buffer is size=", size, ", freq=", frequency, ", format", format});
        int bits = 16;
        int channels = 1;
        boolean signed = true;
        if (format == BufferFormat.MONO8) {
            bits = 8;
            channels = 1;
            signed = false;
        } else if (format == BufferFormat.MONO16) {
            bits = 16;
            channels = 1;
            signed = true;
        } else if (format == BufferFormat.STEREO8) {
            bits = 8;
            channels = 2;
            signed = false;
        } else if (format == BufferFormat.STEREO16) {
            bits = 16;
            channels = 2;
            signed = true;
        }
        this.af = new AudioFormat(frequency, bits, channels, signed, false);
        this.info = new DataLine.Info(Clip.class, this.af, size);
        data.rewind();
        this.data = new byte[size];
        data.get(this.data);
        this.size = size;
    }

    public DataLine.Info getInfo() {
        return this.info;
    }
}

