/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.sound.drivers.javasound;

import java.util.ArrayList;
import java.util.List;
import org.openmali.vecmath2.Tuple3f;
import org.xith3d.sound.SoundBuffer;
import org.xith3d.sound.SoundDriver;
import org.xith3d.sound.SoundException;
import org.xith3d.sound.SoundSource;
import org.xith3d.sound.drivers.javasound.SoundBufferImpl;
import org.xith3d.sound.drivers.javasound.SoundSourceImpl;
import org.xith3d.utility.logging.X3DLog;

public class SoundDriverImpl
implements SoundDriver {
    private List<SoundSource> sources = new ArrayList<SoundSource>();
    private List<SoundSource> availableSources = new ArrayList<SoundSource>();
    private boolean isOnline;

    public void newFrameSync() {
    }

    public void newFrameAsync() {
    }

    public void setListenerVelocity(Tuple3f velocity) {
    }

    public void setListenerPosition(Tuple3f position) {
    }

    public void setListenerOrientation(Tuple3f direction, Tuple3f up) {
    }

    public void setListenerVolume(float gain) {
    }

    public float getListenerVolume() {
        return 1.0f;
    }

    public void setDopplerVelocity(float velocity) {
    }

    public float getDopplerVelocity() {
        return 1.0f;
    }

    public void setDopplerFactor(float factor) {
    }

    public float getDopplerFactor() {
        return 0.0f;
    }

    public SoundSource allocateSoundSource() throws SoundException {
        if (this.availableSources.size() == 0) {
            throw new SoundException("no sound sources available");
        }
        SoundSource s = this.availableSources.remove(this.availableSources.size() - 1);
        this.sources.add(s);
        return s;
    }

    public SoundBuffer allocateSoundBuffer() {
        return new SoundBufferImpl(this);
    }

    public void delete(SoundSource source) {
        this.sources.remove(source);
        this.availableSources.add(source);
    }

    public void delete(SoundBuffer buffer) {
    }

    public int getNumAvailableSources() {
        return this.availableSources.size();
    }

    public int getNumSources() {
        return this.sources.size() + this.availableSources.size();
    }

    public void shutdown() {
        if (!this.isOnline()) {
            return;
        }
        for (int j = 0; j < this.sources.size(); ++j) {
            SoundSourceImpl ss = (SoundSourceImpl)this.sources.get(j);
            ss.close();
        }
        this.isOnline = false;
    }

    public final boolean isOnline() {
        return this.isOnline;
    }

    public SoundDriverImpl() {
        boolean done = false;
        int n = 0;
        while (!done) {
            try {
                SoundSourceImpl ss = new SoundSourceImpl(this);
                this.availableSources.add(ss);
                if (n++ != 60) continue;
                break;
            }
            catch (Error e) {
                X3DLog.print(e);
                done = true;
            }
        }
        this.setListenerVolume(1.0f);
        this.isOnline = true;
        X3DLog.debug("JavaSound sound driver initialized with ", this.availableSources.size(), " available sources");
    }
}

